/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.datatools.enablement.sybase.asa.schemaobjecteditor.examples.tableeditor.model;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import org.eclipse.datatools.enablement.sybase.asa.models.sybaseasabasesqlmodel.SybaseASABaseDatabase;
import org.eclipse.datatools.enablement.sybase.asa.schemaobjecteditor.examples.ASADDLGeneratorWrapper;
import org.eclipse.datatools.enablement.sybase.asa.schemaobjecteditor.examples.commonui.privilege.CustomizedCopier;
import org.eclipse.datatools.enablement.sybase.asa.schemaobjecteditor.examples.tableeditor.model.ASATableSchemaImmutableModel;
import org.eclipse.datatools.enablement.sybase.asa.schemaobjecteditor.examples.utils.PrivilegesUtil;
import org.eclipse.datatools.enablement.sybase.ddl.SybaseDdlScript;
import org.eclipse.datatools.enablement.sybase.models.sybasesqlmodel.SybaseAuthorizedObject;
import org.eclipse.datatools.enablement.sybase.models.sybasesqlmodel.SybasePrivilege;
import org.eclipse.datatools.modelbase.sql.accesscontrol.AuthorizationIdentifier;
import org.eclipse.datatools.modelbase.sql.accesscontrol.Privilege;
import org.eclipse.datatools.modelbase.sql.schema.Catalog;
import org.eclipse.datatools.modelbase.sql.schema.Database;
import org.eclipse.datatools.modelbase.sql.schema.SQLObject;
import org.eclipse.datatools.modelbase.sql.schema.SQLSchemaFactory;
import org.eclipse.datatools.modelbase.sql.schema.Schema;
import org.eclipse.datatools.modelbase.sql.tables.BaseTable;
import org.eclipse.datatools.modelbase.sql.tables.Column;
import org.eclipse.datatools.modelbase.sql.tables.Table;
import org.eclipse.datatools.sqltools.core.DatabaseIdentifier;
import org.eclipse.datatools.sqltools.core.profile.ProfileUtil;
import org.eclipse.datatools.sqltools.schemaobjecteditor.ddl.IDDLProvider;
import org.eclipse.datatools.sqltools.schemaobjecteditor.model.AbstractSchemaObjectEditModel;
import org.eclipse.datatools.sqltools.schemaobjecteditor.model.ISchemaObjectImmutableModel;
import org.eclipse.datatools.sqltools.sql.util.ModelUtil;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.change.ChangeDescription;
import org.eclipse.emf.ecore.change.ChangeFactory;
import org.eclipse.emf.ecore.change.util.ChangeRecorder;
import org.eclipse.emf.ecore.util.EcoreUtil;

public class ASATableSchemaEditModel
extends AbstractSchemaObjectEditModel {
    ChangeDescription[] _authIDsChangeDescription;
    ChangeDescription[] _indexesChangeDescription;
    ChangeRecorder[] _authIDsChangeRecoreder;
    ChangeRecorder[] _indexesChangeRecoreder;

    public ASATableSchemaEditModel(ASATableSchemaImmutableModel model, DatabaseIdentifier databaseIdentifier) {
        super((ISchemaObjectImmutableModel)model, databaseIdentifier);
        this._dGeneratorWrapper = new ASADDLGeneratorWrapper(this._dIdentifier);
    }

    protected EcoreUtil.Copier createCopier() {
        return new CustomizedCopier();
    }

    public Object getAdapter(Class adapter) {
        if (adapter.equals(IDDLProvider.class)) {
            return new IDDLProvider(){

                public String getDDL() {
                    ASADDLGeneratorWrapper wrapper = new ASADDLGeneratorWrapper(ASATableSchemaEditModel.this._dIdentifier);
                    String ddl = "";
                    if (wrapper != null) {
                        ArrayList<Object> objTobeGenDDL = new ArrayList<Object>();
                        objTobeGenDDL.add(ASATableSchemaEditModel.this._mainObject);
                        Iterator iter = ((BaseTable)ASATableSchemaEditModel.this._mainObject).getConstraints().iterator();
                        while (iter.hasNext()) {
                            objTobeGenDDL.add(iter.next());
                        }
                        for (AuthorizationIdentifier authid : (List)ASATableSchemaEditModel.this.getAdditionalSQLObjects().get("authids")) {
                            List privileges = PrivilegesUtil.getReceivedSQLObjectPrivileges(authid, ASATableSchemaEditModel.this._mainObject);
                            for (Privilege p : privileges) {
                                if (p == null) continue;
                                objTobeGenDDL.add(p);
                            }
                        }
                        for (Column col : ((Table)ASATableSchemaEditModel.this._mainObject).getColumns()) {
                            for (AuthorizationIdentifier authid : (List)ASATableSchemaEditModel.this.getAdditionalSQLObjects().get("authids")) {
                                List privileges = PrivilegesUtil.getReceivedSQLObjectPrivileges(authid, (SQLObject)col);
                                for (Privilege p : privileges) {
                                    if (p == null) continue;
                                    objTobeGenDDL.add(p);
                                }
                            }
                        }
                        String[] ddls = wrapper.getCreateStatementsDDL(objTobeGenDDL.toArray(new SQLObject[objTobeGenDDL.size()]));
                        if (ddls == null) {
                            return "";
                        }
                        StringBuffer sb = new StringBuffer("");
                        int i = 0;
                        while (i < ddls.length) {
                            sb.append(ddls[i]);
                            sb.append(System.getProperty("line.separator"));
                            sb.append(ASATableSchemaEditModel.this.getSQLDelimiter());
                            sb.append(System.getProperty("line.separator"));
                            ++i;
                        }
                        ddl = sb.toString();
                    }
                    return ddl;
                }
            };
        }
        return null;
    }

    protected void createAndAttachNecessaryTempObjects() {
        BaseTable table = (BaseTable)this._immutableModel.getMainSQLObject();
        Database db = table.getSchema().getDatabase();
        SybaseASABaseDatabase database = (SybaseASABaseDatabase)EcoreUtil.create((EClass)db.eClass());
        database.setName(table.getSchema().getDatabase().getName());
        database.setVendor(table.getSchema().getDatabase().getVendor());
        database.setVersion(table.getSchema().getDatabase().getVersion());
        Schema belongedSchema = SQLSchemaFactory.eINSTANCE.createSchema();
        belongedSchema.setName(table.getSchema().getName());
        for (Schema s : db.getSchemas()) {
            Schema tmpSchema = SQLSchemaFactory.eINSTANCE.createSchema();
            tmpSchema.setName(s.getName());
            tmpSchema.setDatabase((Database)database);
        }
        ((BaseTable)this._mainObject).setSchema(belongedSchema);
        belongedSchema.setDatabase((Database)database);
        Catalog catalog = SQLSchemaFactory.eINSTANCE.createCatalog();
        catalog.setName(database.getName());
        belongedSchema.setCatalog(catalog);
        catalog.setDatabase((Database)database);
        EList privileges = ((SybaseAuthorizedObject)this._mainObject).getPrivileges();
        for (SybasePrivilege p : privileges) {
            AuthorizationIdentifier grantee = p.getGrantee();
            grantee.getReceivedPrivilege().add((Object)p);
        }
        for (Column col : ((Table)this._mainObject).getColumns()) {
            EList colPrivileges = ((SybaseAuthorizedObject)col).getPrivileges();
            for (SybasePrivilege p : colPrivileges) {
                AuthorizationIdentifier grantee = p.getGrantee();
                grantee.getReceivedPrivilege().add((Object)p);
            }
        }
        for (Object obj : this._immutableModel.getAdditionalSQLObjects().values()) {
            if (!(obj instanceof BaseTable)) continue;
            BaseTable originalTable = (BaseTable)obj;
            BaseTable copiedTable = (BaseTable)this._copier.get(obj);
            if (copiedTable == this._mainObject) continue;
            Schema schema = SQLSchemaFactory.eINSTANCE.createSchema();
            schema.setDatabase((Database)database);
            schema.setName(originalTable.getSchema().getName());
            copiedTable.setSchema(schema);
        }
        ((BaseTable)this._mainObject).getIndex().addAll((Collection)this._additionalObjects.get("indexes"));
    }

    protected String getSQLDelimiter() {
        return ";";
    }

    public String getDeltaDDL() {
        StringBuffer sb = new StringBuffer("");
        sb.append(this.getIndexDeltaDDL());
        this._changeRecorder.summarize();
        sb.append(super.formatDeltaDDL(this._dGeneratorWrapper.generateDeltaDDL((EObject)this._mainObject, this._changeDescription, null)));
        sb.append(this.getPrivilegeDeltaDDL());
        return sb.toString();
    }

    protected String getDeltaDDL(Object[] eObjects, ChangeDescription[] changeDescription) {
        if (eObjects.length != changeDescription.length) {
            return null;
        }
        String[] deltaDDL = new String[]{};
        if (this._dGeneratorWrapper == null) {
            this._dGeneratorWrapper = new ASADDLGeneratorWrapper(this._dIdentifier);
        }
        String currentUser = ProfileUtil.getProfileUserName((DatabaseIdentifier)this._dIdentifier, (boolean)false);
        StringBuffer sb = new StringBuffer("");
        if (changeDescription != null) {
            int index = 0;
            while (index < changeDescription.length) {
                if (eObjects[index] instanceof EObject) {
                    String targetUser = ModelUtil.getSchemaName((EObject)((EObject)eObjects[index]));
                    this._dGeneratorWrapper.setGenSetUser(currentUser != null && !currentUser.equals(targetUser));
                    deltaDDL = this._dGeneratorWrapper.generateDeltaDDL((EObject)eObjects[index], changeDescription[index], null);
                    sb.append(super.formatDeltaDDL(deltaDDL));
                }
                ++index;
            }
        }
        return sb.toString();
    }

    private String getPrivilegeDeltaDDL() {
        Collection authIds = (Collection)this._additionalObjects.get("authids");
        if (authIds == null) {
            return "";
        }
        Object[] authIdObjects = authIds.toArray();
        int i = 0;
        while (this._authIDsChangeRecoreder != null && i < this._authIDsChangeRecoreder.length) {
            this._authIDsChangeRecoreder[i].summarize();
            ++i;
        }
        return this.getDeltaDDL(authIdObjects, this._authIDsChangeDescription);
    }

    private String getIndexDeltaDDL() {
        Collection indexes = (Collection)this._additionalObjects.get("indexes");
        if (indexes == null) {
            return "";
        }
        Object[] indexObjects = indexes.toArray();
        int i = 0;
        while (this._indexesChangeRecoreder != null && i < this._indexesChangeRecoreder.length) {
            this._indexesChangeRecoreder[i].summarize();
            ++i;
        }
        return this.getDeltaDDL(indexObjects, this._indexesChangeDescription);
    }

    public void startLogging() {
        Collection indexes;
        super.startLogging();
        Collection authIds = (Collection)this._additionalObjects.get("authids");
        if (authIds != null) {
            this._authIDsChangeDescription = new ChangeDescription[authIds.size()];
            this._authIDsChangeRecoreder = new ChangeRecorder[authIds.size()];
            Object[] authIdObjects = authIds.toArray();
            int i = 0;
            while (i < authIds.size()) {
                this._resource.getContents().add((Object)((EObject)authIdObjects[i]));
                this._authIDsChangeDescription[i] = ChangeFactory.eINSTANCE.createChangeDescription();
                this._authIDsChangeRecoreder[i] = new ChangeRecorder();
                this._authIDsChangeRecoreder[i].beginRecording(this._authIDsChangeDescription[i], Collections.singletonList(authIdObjects[i]));
                ++i;
            }
        }
        if ((indexes = (Collection)this._additionalObjects.get("indexes")) != null) {
            this._indexesChangeDescription = new ChangeDescription[indexes.size()];
            this._indexesChangeRecoreder = new ChangeRecorder[indexes.size()];
            Object[] indexObjects = indexes.toArray();
            int i = 0;
            while (i < indexes.size()) {
                this._resource.getContents().add((Object)((EObject)indexObjects[i]));
                this._indexesChangeDescription[i] = ChangeFactory.eINSTANCE.createChangeDescription();
                this._indexesChangeRecoreder[i] = new ChangeRecorder();
                this._indexesChangeRecoreder[i].beginRecording(this._indexesChangeDescription[i], Collections.singletonList(indexObjects[i]));
                ++i;
            }
        }
    }

    public void stopLogging() {
        super.stopLogging();
        int i = 0;
        while (this._authIDsChangeDescription != null && i < this._authIDsChangeDescription.length) {
            this._authIDsChangeRecoreder[i].endRecording();
            ++i;
        }
        i = 0;
        while (this._indexesChangeDescription != null && i < this._indexesChangeDescription.length) {
            this._indexesChangeRecoreder[i].endRecording();
            ++i;
        }
    }

    protected SybaseDdlScript getDeltaDDLScript(EObject rootObject, ChangeDescription _changeSummary) {
        if (this._dGeneratorWrapper instanceof ASADDLGeneratorWrapper) {
            return ((ASADDLGeneratorWrapper)this._dGeneratorWrapper).getDeltaDDLScript(rootObject, _changeSummary, null, true);
        }
        return null;
    }
}

