/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.datatools.connectivity.oda.spec.valueexpr;

import org.eclipse.datatools.connectivity.oda.OdaException;
import org.eclipse.datatools.connectivity.oda.nls.Messages;
import org.eclipse.datatools.connectivity.oda.spec.ValidationContext;
import org.eclipse.datatools.connectivity.oda.spec.ValueExpression;

public class NestedValueExpression
extends ValueExpression {
    private static final String NAME_PREFIX = "NESTED_";
    private ValueExpression m_nestedExpr;

    public NestedValueExpression(ValueExpression nestedExpr) {
        if (nestedExpr == null) {
            throw new NullPointerException(Messages.bind((String)Messages.querySpec_NULL_CONSTRUCTOR_ARG, (Object)NestedValueExpression.class.getName()));
        }
        this.m_nestedExpr = nestedExpr;
    }

    public ValueExpression getNestedExpression() {
        return this.m_nestedExpr;
    }

    public void validateSyntax(ValidationContext context) throws OdaException {
        this.m_nestedExpr.validateSyntax(context);
    }

    public String getName() {
        return NAME_PREFIX + this.m_nestedExpr.getName();
    }

    public Integer getOdaDataType() {
        if (super.getOdaDataType() == null) {
            return this.m_nestedExpr.getOdaDataType();
        }
        return super.getOdaDataType();
    }

    public String toString() {
        StringBuffer buffer = new StringBuffer(String.valueOf(NestedValueExpression.class.getSimpleName()) + " " + "(");
        buffer.append(String.valueOf(this.m_nestedExpr.getName()) + ")");
        buffer.append("\n      nestedExpr= {" + this.m_nestedExpr + "} ");
        return buffer.toString();
    }
}

