/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.datatools.connectivity.oda.design.internal.ui.profile.browse;

import org.eclipse.datatools.connectivity.oda.design.internal.ui.profile.browse.IBrowseButtonHost;
import org.eclipse.datatools.connectivity.oda.design.internal.ui.profile.browse.IMenuButtonProvider;
import org.eclipse.datatools.connectivity.oda.design.internal.ui.profile.browse.MenuButton;
import org.eclipse.datatools.connectivity.oda.design.internal.ui.profile.browse.MenuButtonProvider;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Decorations;
import org.eclipse.swt.widgets.Menu;
import org.eclipse.swt.widgets.MenuItem;
import org.eclipse.swt.widgets.Widget;

public class ProfileStoreBrowseButton {
    private static final int BUTTON_MIN_WIDTH = 80;
    private MenuButton button;
    private Menu menu;
    private IMenuButtonProvider provider;
    private IBrowseButtonHost host;
    private SelectionAdapter listener = new SelectionAdapter(){

        public void widgetSelected(SelectionEvent e) {
            Widget widget = e.widget;
            ProfileStoreBrowseButton.this.host.browseSelected();
            if (widget instanceof MenuItem) {
                ProfileStoreBrowseButton.this.provider.handleSelectionEvent((String)widget.getData());
            } else if (widget instanceof MenuButton) {
                ProfileStoreBrowseButton.this.provider.handleSelectionEvent(((MenuButtonProvider)ProfileStoreBrowseButton.this.provider).getDefaultOptionType());
            }
        }
    };

    public ProfileStoreBrowseButton(Composite parent, int style, IMenuButtonProvider provider, IBrowseButtonHost host) {
        this.host = host;
        this.button = new MenuButton(parent, style, provider.getButtonText());
        this.button.addSelectionListener((SelectionListener)this.listener);
        this.button.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                ProfileStoreBrowseButton.this.refreshMenuItems();
            }
        });
        this.menu = new Menu((Decorations)parent.getShell(), 8);
        this.button.setDropDownMenu(this.menu);
        this.button.setToolTipText(provider.getToolTipText());
        this.setMenuButtonProvider(provider);
        this.refresh();
    }

    public void setLayoutData(Object layoutData) {
        this.button.setLayoutData(layoutData);
    }

    public void refreshMenuItems() {
        ((MenuButtonProvider)this.provider).resetProperties();
        this.populateMenuItems();
    }

    public void setEnabled(boolean enable) {
        this.button.setEnabled(enable);
    }

    public boolean isEnabled() {
        return this.button.isEnabled();
    }

    public MenuButton getControl() {
        return this.button;
    }

    public IMenuButtonProvider getMenuButtonProvider() {
        return this.provider;
    }

    public void refresh() {
    }

    public void setMenuButtonProvider(IMenuButtonProvider provider) {
        if (provider != null && provider != this.provider) {
            this.provider = provider;
            provider.setInput(this);
            this.populateMenuItems();
        }
    }

    private void populateMenuItems() {
        int i = 0;
        while (i < this.menu.getItemCount()) {
            this.menu.getItem(i).dispose();
            --i;
            ++i;
        }
        String[] types = this.provider.getMenuItems();
        int i2 = 0;
        while (i2 < types.length) {
            MenuItem item = new MenuItem(this.menu, 8);
            item.setText(this.provider.getMenuItemText(types[i2]));
            item.setData((Object)types[i2]);
            item.setImage(this.provider.getMenuItemImage(types[i2]));
            item.addSelectionListener((SelectionListener)this.listener);
            ++i2;
        }
        if (this.menu.getItemCount() <= 0) {
            this.button.setDropDownMenu(null);
        }
        this.refresh();
    }

    public void handleSelection(String path, boolean isRelative) {
        this.host.setProfileStorePath(path, isRelative);
    }

    public int computeButtonWidth() {
        return ProfileStoreBrowseButton.computeButtonWidth(this.button);
    }

    static int computeButtonWidth(MenuButton button) {
        int defaultWidth = button.computeSize((int)-1, (int)-1).x;
        return defaultWidth < 80 ? 80 : defaultWidth;
    }
}

