/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.datatools.sqltools.sqlbuilder.input;

import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.datatools.sqltools.sqlbuilder.input.SQLBuilderWindowStateInput;
import org.eclipse.datatools.sqltools.sqlbuilder.model.ControlStateInfo;
import org.eclipse.datatools.sqltools.sqlbuilder.model.IControlStateInfo;
import org.eclipse.datatools.sqltools.sqlbuilder.model.IWindowStateInfo;
import org.eclipse.datatools.sqltools.sqlbuilder.model.WindowStateInfo;
import org.eclipse.ui.IElementFactory;
import org.eclipse.ui.IMemento;

public class SQLBuilderWindowStateFactory
implements IElementFactory {
    public static final String ID_SQL_BUILDER_STORAGE_EDITOR_INPUT_FACTORY = "org.eclipse.datatools.sqltools.sqlbuilder.input.SQLBuilderWindowStateFactory";
    public static final String ID_XML_MEMENTO_ROOT_ELEMENT = "SQLQueryBuilder";
    public static final String KEY_WINDOW_STATE_TYPE = "windowState";
    public static final String KEY_WINDOW_STATE_VERSION = "version";
    public static final String KEY_WINDOW_STATE_HEIGHT = "height";
    public static final String KEY_WINDOW_STATE_WIDTH = "width";
    public static final String KEY_WINDOW_CONTROL_TYPE = "control";
    public static final String KEY_SECTION_NAME = "name";
    public static final String KEY_SECTION_VISIBLE_STATE = "isVisible";
    public static final String KEY_SECTION_HIDEABLE_STATE = "isHideable";
    public static final String KEY_SECTION_HEIGHT = "height";
    public static final String KEY_SECTION_WIDTH = "width";
    public static final String NAME_SQL_SOURCE_VIEWER = "SQLSourceViewer";
    public static final String NAME_DESIGN_VIEWER = "DesignViewer";
    public static final String NAME_GRAPH_CONTROL = "GraphControl";
    public static final String NAME_OUTLINE_VIEWER = "OutlineViewer";

    public IAdaptable createElement(IMemento memento) {
        Integer widthValue;
        if (memento == null) {
            return null;
        }
        IMemento windowStateElement = memento.getChild(KEY_WINDOW_STATE_TYPE);
        if (windowStateElement == null) {
            return null;
        }
        WindowStateInfo windowStateInfo = new WindowStateInfo();
        windowStateInfo.setVersion(windowStateElement.getString(KEY_WINDOW_STATE_VERSION));
        Integer heightValue = SQLBuilderWindowStateFactory.getAttributeValueAsInteger(windowStateElement, "height");
        if (heightValue != null) {
            windowStateInfo.setHeight(heightValue);
        }
        if ((widthValue = SQLBuilderWindowStateFactory.getAttributeValueAsInteger(windowStateElement, "width")) != null) {
            windowStateInfo.setWidth(widthValue);
        }
        IMemento[] winStateControls = windowStateElement.getChildren(KEY_WINDOW_CONTROL_TYPE);
        int i = 0;
        while (i < winStateControls.length) {
            block10: {
                String isVisibleString;
                ControlStateInfo ctrlStateInfo;
                IMemento controlElement;
                block12: {
                    String controlName;
                    block14: {
                        block13: {
                            block11: {
                                controlElement = winStateControls[i];
                                controlName = controlElement.getString(KEY_SECTION_NAME);
                                if (controlName == null || controlName.length() == 0) break block10;
                                ctrlStateInfo = new ControlStateInfo();
                                if (!controlName.equals(NAME_SQL_SOURCE_VIEWER)) break block11;
                                ctrlStateInfo.setControlType(1);
                                break block12;
                            }
                            if (!controlName.equals(NAME_DESIGN_VIEWER)) break block13;
                            ctrlStateInfo.setControlType(4);
                            break block12;
                        }
                        if (!controlName.equals(NAME_GRAPH_CONTROL)) break block14;
                        ctrlStateInfo.setControlType(2);
                        break block12;
                    }
                    if (!controlName.equals(NAME_OUTLINE_VIEWER)) break block10;
                    ctrlStateInfo.setControlType(3);
                }
                heightValue = SQLBuilderWindowStateFactory.getAttributeValueAsInteger(controlElement, "height");
                if (heightValue != null) {
                    ctrlStateInfo.setHeight(heightValue);
                }
                if ((widthValue = SQLBuilderWindowStateFactory.getAttributeValueAsInteger(controlElement, "width")) != null) {
                    ctrlStateInfo.setWidth(widthValue);
                }
                boolean isVisible = (isVisibleString = SQLBuilderWindowStateFactory.getAttributeValue(controlElement, KEY_SECTION_VISIBLE_STATE)) != null && isVisibleString.trim().length() > 0 ? Boolean.valueOf(isVisibleString) : true;
                ctrlStateInfo.setIsVisible(isVisible);
                String isHideableString = SQLBuilderWindowStateFactory.getAttributeValue(controlElement, KEY_SECTION_HIDEABLE_STATE);
                boolean isHideable = isHideableString != null && isHideableString.trim().length() > 0 ? Boolean.valueOf(isHideableString) : true;
                ctrlStateInfo.setIsHideable(isHideable);
                windowStateInfo.put(ctrlStateInfo.getControlType(), ctrlStateInfo);
            }
            ++i;
        }
        return new SQLBuilderWindowStateInput(windowStateInfo);
    }

    private static String getAttributeValue(IMemento memento, String attrName) {
        if (memento == null) {
            return null;
        }
        return memento.getString(attrName);
    }

    private static Integer getAttributeValueAsInteger(IMemento memento, String attrName) {
        return SQLBuilderWindowStateFactory.convertToInteger(SQLBuilderWindowStateFactory.getAttributeValue(memento, attrName));
    }

    private static Integer convertToInteger(String intString) {
        if (intString == null || intString.trim().length() == 0) {
            return null;
        }
        int intValue = -1;
        try {
            intValue = Integer.parseInt(intString);
        }
        catch (NumberFormatException numberFormatException) {}
        return new Integer(intValue);
    }

    public static void saveState(IMemento memento, SQLBuilderWindowStateInput windowStateInput) {
        if (memento == null || windowStateInput == null) {
            return;
        }
        IWindowStateInfo windowStateInfo = windowStateInput.getWindowStateInfo();
        if (windowStateInfo == null) {
            throw new IllegalArgumentException("SQLBuilderWindowStateInput");
        }
        IMemento winStateElement = memento.createChild(KEY_WINDOW_STATE_TYPE);
        winStateElement.putString(KEY_WINDOW_STATE_VERSION, windowStateInfo.getVersion());
        SQLBuilderWindowStateFactory.saveSizeAttribute(winStateElement, "height", windowStateInfo.getHeight());
        SQLBuilderWindowStateFactory.saveSizeAttribute(winStateElement, "width", windowStateInfo.getWidth());
        IControlStateInfo controlStateInfo = windowStateInfo.get(1);
        SQLBuilderWindowStateFactory.saveControlState(winStateElement, controlStateInfo, NAME_SQL_SOURCE_VIEWER);
        controlStateInfo = windowStateInfo.get(4);
        SQLBuilderWindowStateFactory.saveControlState(winStateElement, controlStateInfo, NAME_DESIGN_VIEWER);
        controlStateInfo = windowStateInfo.get(2);
        SQLBuilderWindowStateFactory.saveControlState(winStateElement, controlStateInfo, NAME_GRAPH_CONTROL);
        controlStateInfo = windowStateInfo.get(3);
        SQLBuilderWindowStateFactory.saveControlState(winStateElement, controlStateInfo, NAME_OUTLINE_VIEWER);
    }

    private static void saveSizeAttribute(IMemento memento, String key, int length) {
        if (length != -1) {
            memento.putString(key, Integer.toString(length));
        }
    }

    private static void saveControlState(IMemento memento, IControlStateInfo controlStateInfo, String controlName) {
        if (controlStateInfo == null) {
            return;
        }
        IMemento controlMemento = memento.createChild(KEY_WINDOW_CONTROL_TYPE);
        controlMemento.putString(KEY_SECTION_NAME, controlName);
        controlMemento.putString(KEY_SECTION_VISIBLE_STATE, Boolean.toString(controlStateInfo.isVisible()));
        controlMemento.putString(KEY_SECTION_HIDEABLE_STATE, Boolean.toString(controlStateInfo.isHideable()));
        SQLBuilderWindowStateFactory.saveSizeAttribute(controlMemento, "height", controlStateInfo.getHeight());
        SQLBuilderWindowStateFactory.saveSizeAttribute(controlMemento, "width", controlStateInfo.getWidth());
    }
}

