/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.datatools.enablement.oda.xml.ui.wizards;

import org.eclipse.core.runtime.Preferences;
import org.eclipse.datatools.connectivity.oda.OdaException;
import org.eclipse.datatools.connectivity.oda.design.DataSetDesign;
import org.eclipse.datatools.connectivity.oda.design.ResourceIdentifiers;
import org.eclipse.datatools.connectivity.oda.design.ui.designsession.DesignSessionUtil;
import org.eclipse.datatools.connectivity.oda.design.ui.wizards.DataSetWizardPage;
import org.eclipse.datatools.enablement.oda.xml.ui.UiPlugin;
import org.eclipse.datatools.enablement.oda.xml.ui.i18n.Messages;
import org.eclipse.datatools.enablement.oda.xml.ui.utils.ExceptionHandler;
import org.eclipse.datatools.enablement.oda.xml.ui.utils.XMLRelationInfoUtil;
import org.eclipse.datatools.enablement.oda.xml.ui.wizards.ColumnMappingPage;
import org.eclipse.datatools.enablement.oda.xml.ui.wizards.DataSetDesignPopulator;
import org.eclipse.datatools.enablement.oda.xml.ui.wizards.RowMappingDialog;
import org.eclipse.datatools.enablement.oda.xml.ui.wizards.XMLInformationHolder;
import org.eclipse.datatools.enablement.oda.xml.ui.wizards.XMLTreeViewer;
import org.eclipse.datatools.enablement.oda.xml.util.ui.ATreeNode;
import org.eclipse.datatools.enablement.oda.xml.util.ui.SchemaPopulationUtil;
import org.eclipse.jface.wizard.IWizardPage;
import org.eclipse.swt.custom.StyledText;
import org.eclipse.swt.events.MenuDetectEvent;
import org.eclipse.swt.events.MenuDetectListener;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.FormAttachment;
import org.eclipse.swt.layout.FormData;
import org.eclipse.swt.layout.FormLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Menu;
import org.eclipse.swt.widgets.MenuItem;
import org.eclipse.swt.widgets.TreeItem;
import org.eclipse.ui.PlatformUI;

public class XPathChoosePage
extends DataSetWizardPage {
    private static String DEFAULT_MESSAGE = Messages.getString("wizard.defaultMessage.selectXPath");
    private static final String EMPTY_STRING = "";
    private transient XMLTreeViewer availableXmlTree;
    private transient StyledText xmlPathText;
    private transient Group rightGroup;
    private Menu quickFixMenu;
    private ATreeNode treeNode;
    private TreeItem selectedItem;
    private String xsdFileName;
    private String xmlFileName;
    private String xmlEncoding;
    private String initRootPath;
    private String rootPath;
    private int selectRadioIndex = 1;
    protected boolean supportsXMLParameter = true;

    public XPathChoosePage() {
        this(Messages.getString("wizard.title.newDataSet"));
    }

    public XPathChoosePage(String pageName) {
        super(pageName);
        this.setTitle(pageName);
        this.setMessage(DEFAULT_MESSAGE);
        this.setPageComplete(false);
        this.supportsXMLParameter = true;
    }

    public void createPageCustomControl(Composite parent) {
        this.setControl(this.createPageControl(parent));
        if (XMLInformationHolder.hasDestroyed()) {
            XMLInformationHolder.start(this.getInitializationDesign());
        }
        this.initializeControl();
        this.populateXMLTree();
        XMLRelationInfoUtil.setSystemHelp(this.getControl(), "org.eclipse.datatools.oda.cshelp.Wizard_XMLXPath_ID");
    }

    private void initializeControl() {
        this.xsdFileName = XMLInformationHolder.getPropertyValue("SCHEMAFILELIST");
        this.xmlFileName = XMLInformationHolder.getPropertyValue("FILELIST");
        this.xmlEncoding = XMLInformationHolder.getPropertyValue("ENCODINGLIST");
        String queryText = XMLInformationHolder.getPropertyValue("RELATIONINFORMATION");
        String tableName = XMLRelationInfoUtil.getTableName(queryText);
        this.rootPath = tableName != null ? XMLRelationInfoUtil.getXPathExpression(queryText, tableName) : EMPTY_STRING;
        this.backupRootPath();
        if (this.rootPath != null && this.rootPath.length() > 0) {
            this.xmlPathText.setText(this.rootPath);
        }
    }

    private void backupRootPath() {
        this.initRootPath = this.rootPath;
    }

    protected void refresh(DataSetDesign dataSetDesign) {
        DEFAULT_MESSAGE = Messages.getString("xPathChoosePage.messages.elementSelection.label");
        if (XMLInformationHolder.hasDestroyed()) {
            XMLInformationHolder.start(dataSetDesign);
        }
        this.refresh();
    }

    protected void refresh() {
        this.xmlFileName = XMLInformationHolder.getPropertyValue("FILELIST");
        this.xsdFileName = XMLInformationHolder.getPropertyValue("SCHEMAFILELIST");
        this.xmlEncoding = XMLInformationHolder.getPropertyValue("ENCODINGLIST");
        this.populateXMLTree();
        this.backupRootPath();
        this.availableXmlTree.getSingleButton().setEnabled(false);
        this.setMessage(DEFAULT_MESSAGE);
    }

    public Control createPageControl(Composite parent) {
        DEFAULT_MESSAGE = Messages.getString("wizard.defaultMessage.selectXPath");
        this.setMessage(DEFAULT_MESSAGE);
        Composite composite = new Composite(parent, 0);
        FormLayout layout = new FormLayout();
        composite.setLayout((Layout)layout);
        this.createLeftGroup(composite);
        this.availableXmlTree.getSingleButton().addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                RowMappingDialog dialog = new RowMappingDialog(PlatformUI.getWorkbench().getDisplay().getActiveShell(), Messages.getString("RowMappingDialog.title"), XPathChoosePage.this.selectedItem, XPathChoosePage.this.selectRadioIndex, XPathChoosePage.this.rootPath, XPathChoosePage.this.supportsXMLParameter);
                if (dialog.open() == 0) {
                    XPathChoosePage.this.rootPath = dialog.getSelectedPath();
                    XPathChoosePage.this.selectRadioIndex = dialog.getSelectIndex();
                    XPathChoosePage.this.xmlPathText.setText(XPathChoosePage.this.rootPath);
                }
            }
        });
        this.createRightGroup(composite);
        return composite;
    }

    private void createLeftGroup(Composite composite2) {
        this.availableXmlTree = new XMLTreeViewer(composite2, false);
        this.availableXmlTree.getSingleButton().setToolTipText(Messages.getString("xPathChoosePage.messages.btnAdd.tooltip"));
        this.availableXmlTree.getTree().addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                TreeItem[] items = XPathChoosePage.this.availableXmlTree.getTree().getSelection();
                XPathChoosePage.this.selectedItem = null;
                int i = 0;
                while (i < items.length) {
                    XPathChoosePage.this.selectedItem = items[0];
                    if (items[i].getGrayed()) {
                        XPathChoosePage.this.availableXmlTree.getTree().setRedraw(false);
                        XPathChoosePage.this.availableXmlTree.getTree().deselectAll();
                        XPathChoosePage.this.availableXmlTree.getTree().setRedraw(true);
                        XPathChoosePage.this.availableXmlTree.getTree().redraw();
                    }
                    ++i;
                }
                if (XPathChoosePage.this.selectedItem != null) {
                    XPathChoosePage.this.availableXmlTree.getSingleButton().setEnabled(true);
                } else {
                    XPathChoosePage.this.availableXmlTree.getSingleButton().setEnabled(false);
                }
            }
        });
    }

    private void createRightGroup(Composite composite2) {
        FormData data = new FormData();
        data.top = new FormAttachment(0, 5);
        data.left = new FormAttachment((Control)this.availableXmlTree.getBtnComposite(), 5);
        data.right = new FormAttachment(100, -5);
        data.bottom = new FormAttachment(100, -5);
        this.rightGroup = new Group(composite2, 0);
        this.rightGroup.setLayout((Layout)new FormLayout());
        this.rightGroup.setText(Messages.getString("xPathChoosePage.messages.elementSelection.label"));
        this.rightGroup.setLayoutData((Object)data);
        data = new FormData();
        data.top = new FormAttachment(0, 5);
        data.left = new FormAttachment(0, 5);
        data.right = new FormAttachment(100, -5);
        Label label = new Label((Composite)this.rightGroup, 0);
        label.setText(Messages.getString("xPathChoosePage.messages.xPathExpression"));
        label.setLayoutData((Object)data);
        data = new FormData();
        data.top = new FormAttachment(0, 25);
        data.left = new FormAttachment(0, 5);
        data.right = new FormAttachment(100, -5);
        this.xmlPathText = new StyledText((Composite)this.rightGroup, 2048);
        this.xmlPathText.setLayoutData((Object)data);
        this.xmlPathText.setOrientation(0x2000000);
        this.xmlPathText.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                XPathChoosePage.this.rootPath = XPathChoosePage.this.xmlPathText.getText().trim();
                XPathChoosePage.this.setPageStatus();
            }
        });
        if (this.supportsXMLParameter) {
            this.createQuickFixMenu();
            this.xmlPathText.addMenuDetectListener(new MenuDetectListener(){

                public void menuDetected(MenuDetectEvent event) {
                    XPathChoosePage.this.quickFixMenu.setLocation(event.x, event.y);
                    XPathChoosePage.this.quickFixMenu.setVisible(true);
                    XPathChoosePage.this.updateMenuItemStatus(XPathChoosePage.this.xmlPathText);
                }
            });
        }
    }

    private void createQuickFixMenu() {
        this.quickFixMenu = new Menu((Control)this.xmlPathText);
        MenuItem createItem = new MenuItem(this.quickFixMenu, 8);
        createItem.setText(Messages.getString("ColumnMappingDialog.MenuItem.CreateParameter"));
        createItem.addSelectionListener(new SelectionListener(){

            public void widgetSelected(SelectionEvent event) {
                XPathChoosePage.this.createXMLParameter(XPathChoosePage.this.xmlPathText);
            }

            public void widgetDefaultSelected(SelectionEvent event) {
            }
        });
        MenuItem deleteItem = new MenuItem(this.quickFixMenu, 8);
        deleteItem.setText(Messages.getString("ColumnMappingDialog.MenuItem.DeleteParameter"));
        deleteItem.addSelectionListener(new SelectionListener(){

            public void widgetSelected(SelectionEvent event) {
                XPathChoosePage.this.deleteXMLParameter(XPathChoosePage.this.xmlPathText);
            }

            public void widgetDefaultSelected(SelectionEvent event) {
            }
        });
        this.updateMenuItemStatus(this.xmlPathText);
    }

    private void updateMenuItemStatus(StyledText text) {
        String selectionText = text.getSelectionText().trim();
        boolean deleteEnabled = selectionText.length() > 0 && selectionText.startsWith("{?") && selectionText.endsWith("?}");
        this.quickFixMenu.getItem(0).setEnabled(selectionText.length() > 0 && !deleteEnabled);
        this.quickFixMenu.getItem(1).setEnabled(deleteEnabled);
    }

    private void createXMLParameter(StyledText text) {
        String selectedValue = text.getSelectionText();
        String changedValue = "{?" + selectedValue + "?}";
        this.resetXPathText(text, changedValue);
    }

    private void resetXPathText(StyledText text, String changedValue) {
        String xpathString = text.getText().trim();
        String result = String.valueOf(xpathString.substring(0, text.getSelection().x)) + changedValue + xpathString.substring(text.getSelection().y);
        text.setText(result);
    }

    private void deleteXMLParameter(StyledText text) {
        String selectedValue = text.getSelectionText();
        String changedValue = selectedValue.substring(2, selectedValue.length() - 2);
        this.resetXPathText(text, changedValue);
    }

    private void populateXMLTree() {
        try {
            this.availableXmlTree.getTree().removeAll();
            if (!(this.xsdFileName != null && this.xsdFileName.trim().length() != 0 || this.xmlFileName != null && this.xmlFileName.trim().length() != 0)) {
                this.setErrorMessage(Messages.getString("xPathChoosePage.messages.noURLOfSourceOrSchema"));
                return;
            }
            this.setErrorMessage(null);
            int numberOfElement = 0;
            Preferences preferences = UiPlugin.getDefault().getPluginPreferences();
            if (preferences.contains("user_max_num_of_element_passed")) {
                numberOfElement = preferences.getInt("user_max_num_of_element_passed");
            } else {
                numberOfElement = 100000;
                preferences.setValue("user_max_num_of_element_passed", numberOfElement);
            }
            this.treeNode = SchemaPopulationUtil.getSchemaTree((String)this.xsdFileName, (String)this.xmlFileName, (String)this.xmlEncoding, (int)numberOfElement, (Object)DesignSessionUtil.createRuntimeResourceIdentifiers((ResourceIdentifiers)this.getHostResourceIdentifiers()));
            if (this.treeNode == null || this.treeNode.getChildren() == null || this.treeNode.getChildren().length == 0) {
                OdaException ex = new OdaException(Messages.getString("dataset.error.populateXMLTree"));
                ExceptionHandler.showException(this.getShell(), Messages.getString("error.label"), ex.getMessage(), ex);
            } else {
                this.availableXmlTree.populateTree(this.treeNode, this.rootPath, false, false);
            }
        }
        catch (Exception e) {
            ExceptionHandler.showException(this.getShell(), Messages.getString("error.label"), e.getMessage(), e);
        }
    }

    private void setPageStatus() {
        if (!this.isRootPathValid()) {
            this.setPageComplete(false);
            this.setMessage(Messages.getFormattedString("error.invalidXpath", new Object[]{this.rootPath == null ? EMPTY_STRING : this.rootPath}), 3);
        } else {
            if (this.initRootPath != null && !this.initRootPath.equals(EMPTY_STRING) && !this.initRootPath.equals(this.rootPath)) {
                this.setMessage(Messages.getString("xPathChoosePage.messages.xpathChange"), 1);
            } else {
                this.setMessage(DEFAULT_MESSAGE);
            }
            this.setPageComplete(true);
        }
    }

    private boolean isRootPathValid() {
        return this.rootPath != null && this.rootPath.trim().length() != 0;
    }

    private void resetXPathPropInHandle(String pathStr) {
        if (pathStr != null && pathStr.trim().length() > 0) {
            XMLInformationHolder.setPropertyValue("XPATHTEXT", pathStr);
            if (XMLInformationHolder.getPropertyValue("TABLENAME") != null) {
                String relationInfo = XMLInformationHolder.getPropertyValue("RELATIONINFORMATION");
                if (relationInfo == null || relationInfo.trim().length() == 0) {
                    return;
                }
                String tableName = XMLInformationHolder.getPropertyValue("TABLENAME");
                String infoStr = XMLRelationInfoUtil.replaceXpathExpression(tableName, relationInfo, pathStr);
                XMLInformationHolder.setPropertyValue("RELATIONINFORMATION", infoStr);
            }
        }
    }

    public IWizardPage getNextPage() {
        if (this.isValid()) {
            IWizardPage page = super.getNextPage();
            if (page instanceof ColumnMappingPage) {
                ((ColumnMappingPage)page).refresh();
            }
            return page;
        }
        return null;
    }

    public boolean canFlipToNextPage() {
        return this.rootPath != null && this.rootPath.trim().length() != 0;
    }

    private boolean isValid() {
        if (this.getControl() == null || this.getControl().isDisposed()) {
            return true;
        }
        if (!this.isRootPathValid()) {
            this.setMessage(Messages.getFormattedString("error.invalidXpath", new Object[]{this.rootPath == null ? EMPTY_STRING : this.rootPath}), 3);
            return false;
        }
        this.resetXPathPropInHandle(this.rootPath);
        return true;
    }

    protected DataSetDesign collectDataSetDesign(DataSetDesign design) {
        try {
            this.resetXPathPropInHandle(this.rootPath);
            this.savePage(design);
        }
        catch (OdaException odaException) {}
        return design;
    }

    private void savePage(DataSetDesign dataSetDesign) throws OdaException {
        if (XMLInformationHolder.hasDestroyed()) {
            return;
        }
        if (dataSetDesign != null && this.getQueryText(dataSetDesign) != null && !this.getQueryText(dataSetDesign).equals(XMLInformationHolder.getPropertyValue("RELATIONINFORMATION"))) {
            this.setQueryText(dataSetDesign, XMLInformationHolder.getPropertyValue("RELATIONINFORMATION"));
            this.updateDesign(dataSetDesign);
        }
    }

    protected void updateDesign(DataSetDesign dataSetDesign) {
        DataSetDesignPopulator.populateMetaData(dataSetDesign);
    }

    protected String getQueryText(DataSetDesign dataSetDesign) {
        return dataSetDesign.getQueryText();
    }

    protected void setQueryText(DataSetDesign dataSetDesign, String queryText) {
        dataSetDesign.setQueryText(queryText);
    }

    protected boolean canLeave() {
        return this.isValid();
    }

    public void setVisible(boolean visible) {
        super.setVisible(visible);
        this.getControl().setFocus();
    }

    protected void cleanup() {
        XMLInformationHolder.destory();
    }
}

