/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.datatools.connectivity.oda.flatfile;

import com.ibm.icu.util.ULocale;
import java.util.Map;
import java.util.Properties;
import org.eclipse.datatools.connectivity.oda.IConnection;
import org.eclipse.datatools.connectivity.oda.IDataSetMetaData;
import org.eclipse.datatools.connectivity.oda.IQuery;
import org.eclipse.datatools.connectivity.oda.OdaException;
import org.eclipse.datatools.connectivity.oda.flatfile.CommonConstants;
import org.eclipse.datatools.connectivity.oda.flatfile.DataSetMetaData;
import org.eclipse.datatools.connectivity.oda.flatfile.FlatFileQuery;
import org.eclipse.datatools.connectivity.oda.flatfile.ResourceInputStream;
import org.eclipse.datatools.connectivity.oda.flatfile.ResourceLocator;
import org.eclipse.datatools.connectivity.oda.flatfile.i18n.Messages;

public class Connection
implements IConnection {
    private boolean isOpen = false;
    private Map appContext = null;
    private char delimiter;
    private String charSet;
    private boolean hasColumnNames;
    private boolean hasTypeLine;
    private boolean trailNullColumns;
    private String homeFolder;
    private String fileURI;
    private Object ri;

    public void open(Properties connProperties) throws OdaException {
        if (connProperties == null) {
            throw new OdaException(Messages.getString("connection_CONNECTION_PROPERTIES_MISSING"));
        }
        this.populateFileLocation(connProperties);
        this.populateDelimiter(connProperties);
        this.populateInclColumnNames(connProperties);
        this.populateInclTypeLine(connProperties);
        this.populateTrailNullCols(connProperties);
        this.populateCharSet(connProperties);
    }

    private void populateFileLocation(Properties connProperties) throws OdaException {
        this.homeFolder = connProperties.getProperty("HOME");
        if (this.homeFolder != null && this.homeFolder.trim().length() == 0) {
            this.homeFolder = null;
        }
        this.fileURI = connProperties.getProperty("URI");
        if (this.fileURI != null && this.fileURI.trim().length() == 0) {
            this.fileURI = null;
        }
        if (this.homeFolder == null && this.fileURI == null) {
            throw new OdaException(Messages.getString("connection_MISSING_FILELOCATION"));
        }
        this.isOpen = true;
    }

    private void populateDelimiter(Properties connProperties) throws OdaException {
        String delimiterName = connProperties.getProperty("DELIMTYPE");
        if (delimiterName == null) {
            delimiterName = "COMMA";
            connProperties.setProperty("DELIMTYPE", delimiterName);
        } else if (CommonConstants.isValidDelimiterName(delimiterName)) {
            connProperties.setProperty("DELIMTYPE", delimiterName);
        } else {
            throw new OdaException(Messages.getString("Unsupported_Delimiter"));
        }
        this.delimiter = CommonConstants.getDelimiterValue(delimiterName).charAt(0);
    }

    private void populateCharSet(Properties connProperties) {
        this.charSet = connProperties.getProperty("CHARSET");
    }

    private void populateInclColumnNames(Properties connProperties) {
        boolean includeColumnNames = true;
        String inclColumnNames = connProperties.getProperty("INCLCOLUMNNAME");
        if (inclColumnNames != null && inclColumnNames.trim().length() > 0) {
            includeColumnNames = !inclColumnNames.equalsIgnoreCase("NO");
        }
        connProperties.setProperty("INCLCOLUMNNAME", includeColumnNames ? "YES" : "NO");
        this.hasColumnNames = includeColumnNames;
    }

    private void populateInclTypeLine(Properties connProperties) {
        boolean includeTypeLine = true;
        String inclTypeLine = connProperties.getProperty("INCLTYPELINE");
        if (inclTypeLine != null && inclTypeLine.trim().length() > 0) {
            includeTypeLine = !inclTypeLine.equalsIgnoreCase("NO");
        }
        connProperties.setProperty("INCLTYPELINE", includeTypeLine ? "YES" : "NO");
        this.hasTypeLine = includeTypeLine;
    }

    private void populateTrailNullCols(Properties connProperties) {
        boolean trailNullCols = true;
        String trailNullColsProp = connProperties.getProperty("TRAILNULLCOLS");
        if (trailNullColsProp != null && trailNullColsProp.trim().length() > 0) {
            trailNullCols = !trailNullColsProp.equalsIgnoreCase("NO");
        }
        connProperties.setProperty("TRAILNULLCOLS", trailNullCols ? "YES" : "NO");
        this.trailNullColumns = trailNullCols;
    }

    public void setAppContext(Object context) throws OdaException {
        this.appContext = (Map)context;
    }

    public void close() throws OdaException {
        this.isOpen = false;
    }

    public boolean isOpen() throws OdaException {
        return this.isOpen;
    }

    public IDataSetMetaData getMetaData(String dataSetType) throws OdaException {
        return new DataSetMetaData(this);
    }

    public IQuery newQuery(String dataSourceType) throws OdaException {
        if (!this.isOpen()) {
            throw new OdaException(Messages.getString("common_CONNECTION_HAS_NOT_OPEN"));
        }
        return new FlatFileQuery(this);
    }

    public void commit() throws OdaException {
        throw new UnsupportedOperationException();
    }

    public void rollback() throws OdaException {
        throw new UnsupportedOperationException();
    }

    public void setLocale(ULocale locale) throws OdaException {
        throw new UnsupportedOperationException();
    }

    public int getMaxQueries() throws OdaException {
        return 0;
    }

    public char getDelimeter() {
        return this.delimiter;
    }

    public String getCharSet() {
        return this.charSet;
    }

    public boolean hasTypeLine() {
        return this.hasTypeLine;
    }

    public boolean hasColumnNames() {
        return this.hasColumnNames;
    }

    public boolean trailNullColumns() {
        return this.trailNullColumns;
    }

    public String getHomeFolder() {
        return this.homeFolder;
    }

    public String getFileURI() {
        return this.fileURI;
    }

    public ResourceInputStream getInputStream(String tableName) throws OdaException {
        Object resource;
        if (this.ri == null && this.appContext != null && (resource = this.appContext.get("org.eclipse.datatools.connectivity.oda.util_consumerResourceIds")) != null) {
            this.ri = resource;
        }
        return ResourceLocator.getResourceInputStream(this.homeFolder, tableName, this.fileURI, this.ri);
    }
}

