/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.datatools.sqltools.result.internal.ui.view;

import java.util.ArrayList;
import java.util.Date;
import org.eclipse.datatools.sqltools.result.IReExecutionRunnable;
import org.eclipse.datatools.sqltools.result.OperationCommand;
import org.eclipse.datatools.sqltools.result.ResultsViewPlugin;
import org.eclipse.datatools.sqltools.result.internal.core.ReExecutionRegistryReader;
import org.eclipse.datatools.sqltools.result.internal.index.IResultHistoryIndex;
import org.eclipse.datatools.sqltools.result.internal.model.ResultInstance;
import org.eclipse.datatools.sqltools.result.internal.ui.Messages;
import org.eclipse.datatools.sqltools.result.internal.ui.actions.ReExecuteAction;
import org.eclipse.datatools.sqltools.result.internal.ui.view.ItemsLimitationTreeViewer;
import org.eclipse.datatools.sqltools.result.internal.ui.view.ResultHistoryHelper;
import org.eclipse.datatools.sqltools.result.internal.ui.view.ResultSectionFactory;
import org.eclipse.datatools.sqltools.result.internal.ui.view.ResultsHistoryContentProvider;
import org.eclipse.datatools.sqltools.result.internal.ui.view.ResultsViewLabelProvider;
import org.eclipse.datatools.sqltools.result.internal.utils.SerializationHelper;
import org.eclipse.datatools.sqltools.result.model.IResultInstance;
import org.eclipse.datatools.sqltools.result.ui.ResultsViewUIPlugin;
import org.eclipse.datatools.sqltools.result.ui.view.ResultsViewControl;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IContributionItem;
import org.eclipse.jface.action.IMenuListener;
import org.eclipse.jface.action.IMenuManager;
import org.eclipse.jface.action.MenuManager;
import org.eclipse.jface.action.Separator;
import org.eclipse.jface.viewers.ColumnLayoutData;
import org.eclipse.jface.viewers.ColumnPixelData;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.ISelectionProvider;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.TableLayout;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.jface.viewers.ViewerSorter;
import org.eclipse.osgi.util.NLS;
import org.eclipse.swt.custom.BusyIndicator;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.MouseEvent;
import org.eclipse.swt.events.MouseListener;
import org.eclipse.swt.events.MouseTrackListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.graphics.FontData;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Menu;
import org.eclipse.swt.widgets.Text;
import org.eclipse.swt.widgets.TreeColumn;
import org.eclipse.swt.widgets.TreeItem;
import org.eclipse.ui.IMemento;
import org.eclipse.ui.texteditor.IUpdate;

public class ResultHistorySection {
    public static final String TAG_COLUMN_WIDTH = "columnWidth";
    private int[] _columnsWidth = new int[7];
    private Composite _detailParent;
    private Font _filterFont;
    private Text _queryExpressionText;
    private boolean _firstClick = true;
    private TreeViewer _resultsTreeTable;
    private ResultsViewControl _resultsViewControl;
    private ResultsViewLabelProvider _resultViewLabelProvider;
    private String _filterInfo;
    private static final int INITIAL_WIDTH = 80;
    private Runnable _searchHistory = new Runnable(){

        public void run() {
            String query = ResultHistorySection.this._queryExpressionText.getText();
            if (query == null || query.length() == 0) {
                ResultHistorySection.this._resultsTreeTable.getTree().setFont(ResultHistorySection.this._sysFont);
                ResultHistorySection.this._resultsTreeTable.setInput((Object)ResultsViewUIPlugin.getResultManager().getAllResults());
                ResultHistorySection.this._resultsTreeTable.refresh();
            } else {
                ResultHistorySection.this._resultsTreeTable.getTree().setFont(ResultHistorySection.this._filterFont);
                IResultHistoryIndex index = ResultsViewPlugin.getDefault().getResultHistoryIndex();
                IResultInstance[] instances = index.search(query);
                ResultHistorySection.this._resultsTreeTable.setInput((Object)instances);
                ResultHistorySection.this._resultsTreeTable.refresh();
            }
        }
    };
    private Font _sysFont;
    private int OPER_ORDER = -1;
    private int DATE_ORDER = -1;
    private int STATUS_ORDER = -1;
    private int FREQ_ORDER = -1;
    private int ACTION_ORDER = -1;
    private int CONSUMER_ORDER = -1;
    private int PROFILE_ORDER = -1;
    private static int ASCENDING = 1;

    public ResultHistorySection(Composite parent, Composite detailArea, ResultsViewControl resultsViewControl) {
        GridLayout layout = new GridLayout();
        layout.verticalSpacing = 1;
        layout.marginHeight = 0;
        layout.marginWidth = 0;
        layout.numColumns = 1;
        parent.setLayout((Layout)layout);
        this._resultsViewControl = resultsViewControl;
        this._queryExpressionText = new Text(parent, 2048);
        this._queryExpressionText.setToolTipText(Messages.ResultHistorySection_query_expression_tooltip);
        this._queryExpressionText.setLayoutData((Object)new GridData(768));
        this._queryExpressionText.setText(Messages.ResultHistorySection_query_expression);
        this._queryExpressionText.addMouseListener(new MouseListener(){

            public void mouseDoubleClick(MouseEvent e) {
            }

            public void mouseDown(MouseEvent e) {
                if (ResultHistorySection.this._firstClick) {
                    ResultHistorySection.this._queryExpressionText.setText("");
                    ResultHistorySection.this._firstClick = false;
                }
            }

            public void mouseUp(MouseEvent e) {
            }
        });
        this._queryExpressionText.addMouseTrackListener(new MouseTrackListener(){

            public void mouseEnter(MouseEvent e) {
            }

            public void mouseExit(MouseEvent e) {
                ResultHistorySection.this._queryExpressionText.clearSelection();
            }

            public void mouseHover(MouseEvent e) {
            }
        });
        this._queryExpressionText.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                if (!ResultHistorySection.this._firstClick) {
                    ResultHistorySection.this.prepareToQuery();
                } else {
                    ResultHistorySection.this._firstClick = false;
                }
            }
        });
        this._resultsTreeTable = new ItemsLimitationTreeViewer(parent, 66308, resultsViewControl);
        GridData gd = new GridData(1808);
        this._resultsTreeTable.getTree().setLayoutData((Object)gd);
        this._detailParent = detailArea;
        this.configureResultsTable(this._resultsTreeTable);
        this.createContextMenu();
        this._sysFont = this._resultsTreeTable.getTree().getFont();
        FontData[] fontData = this._sysFont.getFontData();
        int i = 0;
        while (i < fontData.length) {
            fontData[i].setStyle(fontData[i].getStyle() | 2);
            ++i;
        }
        this._filterFont = new Font((Device)this._resultsTreeTable.getTree().getDisplay(), fontData);
    }

    public void applyState(IMemento memento) {
        if (memento != null) {
            TableLayout layout = new TableLayout();
            boolean suc = true;
            int i = 0;
            while (i < 7) {
                Integer width = memento.getInteger(TAG_COLUMN_WIDTH + i);
                if (width == null) {
                    suc = false;
                    break;
                }
                this._columnsWidth[i] = width;
                ++i;
            }
            if (suc) {
                i = 0;
                while (i < 7) {
                    if (this._columnsWidth[i] != 0) {
                        layout.addColumnData((ColumnLayoutData)new ColumnPixelData(this._columnsWidth[i], true));
                    }
                    ++i;
                }
                this._resultsTreeTable.getTree().setLayout((Layout)layout);
            }
        }
    }

    private void configureResultsTable(TreeViewer resultsTable) {
        resultsTable.getTree().setHeaderVisible(true);
        this.createColumns();
        this._resultViewLabelProvider = new ResultsViewLabelProvider(this._resultsViewControl);
        resultsTable.setLabelProvider((IBaseLabelProvider)this._resultViewLabelProvider);
        resultsTable.setContentProvider((IContentProvider)new ResultsHistoryContentProvider());
        resultsTable.setInput((Object)ResultsViewUIPlugin.getResultManager().getAllResults());
        ((ItemsLimitationTreeViewer)resultsTable).addRefreshListener(new Listener(){

            public void handleEvent(Event event) {
                IResultInstance[] visibleItems = ResultHistorySection.this.getVisibleInstances();
                ArrayList<IResultInstance> visibleFinishedItems = new ArrayList<IResultInstance>();
                int i = 0;
                while (i < visibleItems.length) {
                    if (visibleItems[i].isFinished()) {
                        visibleFinishedItems.add(visibleItems[i]);
                    }
                    ++i;
                }
                ResultHistorySection.this._resultsViewControl.getRemoveAllVisibleFinishedResultAction().setInstances(visibleFinishedItems.toArray(new IResultInstance[0]));
                int succeededItems = 0;
                int failedItems = 0;
                int terminatedItems = 0;
                int warningItems = 0;
                int criticalItems = 0;
                int i2 = 0;
                while (i2 < visibleItems.length) {
                    switch (visibleItems[i2].getStatus()) {
                        case 3: {
                            ++succeededItems;
                            break;
                        }
                        case 6: {
                            ++failedItems;
                            break;
                        }
                        case 5: {
                            ++terminatedItems;
                            break;
                        }
                        case 4: {
                            ++warningItems;
                            break;
                        }
                        case 7: {
                            ++criticalItems;
                            break;
                        }
                    }
                    ++i2;
                }
                Object[] args = new Object[]{new Integer(visibleItems.length), new Integer(ResultsViewUIPlugin.getResultManager().getAllResults().length), new Integer(succeededItems), new Integer(failedItems), new Integer(terminatedItems), new Integer(warningItems), new Integer(criticalItems)};
                ResultHistorySection.this._filterInfo = NLS.bind((String)Messages.ResultView_filter_info, (Object[])args);
                if (ResultHistorySection.this._resultsViewControl.getView() != null) {
                    ResultHistorySection.this._resultsViewControl.getView().getViewSite().getActionBars().getStatusLineManager().setMessage(ResultHistorySection.this._filterInfo);
                }
            }
        });
        resultsTable.addSelectionChangedListener(new ISelectionChangedListener(){

            public void selectionChanged(SelectionChangedEvent event) {
                IStructuredSelection sel = (IStructuredSelection)event.getSelection();
                final Object obj = sel.getFirstElement();
                if (ResultHistorySection.this._resultsViewControl.getCurrentInstance() == (IResultInstance)obj) {
                    return;
                }
                final IResultInstance lastResultInstance = ResultHistorySection.this._resultsViewControl.getCurrentInstance();
                ResultHistorySection.this._resultsViewControl.setCurrentInstance((IResultInstance)obj);
                BusyIndicator.showWhile((Display)ResultHistorySection.this._detailParent.getDisplay(), (Runnable)new Runnable(){

                    public void run() {
                        ResultHistorySection.this._detailParent.getDisplay().syncExec(new Runnable(){

                            public void run() {
                                Composite comp;
                                if (ResultHistorySection.this._resultsViewControl.getResultSection() != null && (comp = ResultHistorySection.this._resultsViewControl.getResultSection().getControl()) != null && !comp.isDisposed()) {
                                    comp.dispose();
                                }
                                ResultHistorySection.this._resultsViewControl.setResultSection(ResultSectionFactory.createResultSection(ResultHistorySection.this._detailParent, ResultHistorySection.this._resultsViewControl));
                                ResultHistorySection.this._detailParent.layout(true);
                                ResultHistorySection.this._resultsViewControl.getResultSection().showDetail((IResultInstance)obj);
                                if (lastResultInstance instanceof ResultInstance) {
                                    Object[] objs = new Object[]{lastResultInstance.getParameters(), ((ResultInstance)lastResultInstance).getResults()};
                                    SerializationHelper.SaveObjects((Object[])objs, (String)((ResultInstance)lastResultInstance).getFileName());
                                    ((ResultInstance)lastResultInstance).reclaimedTransientThings();
                                }
                            }
                        });
                    }
                });
            }
        });
    }

    private void createColumns() {
        int columnNum = ResultHistoryHelper.getColumnNumber(this._resultsViewControl.getUsePreferences());
        boolean isFirstTimeToCreate = true;
        int i = 0;
        while (i < columnNum) {
            int configurableColumnIndex = ResultHistoryHelper.getConfigurableColumnIndex(i, this._resultsViewControl.getUsePreferences());
            int style = configurableColumnIndex == 1 ? 0x2000000 : 0;
            final TreeColumn column = new TreeColumn(this._resultsTreeTable.getTree(), style);
            switch (configurableColumnIndex) {
                case 0: {
                    column.setText(Messages.ResultHistorySection_status);
                    column.addSelectionListener((SelectionListener)new SelectionAdapter(){

                        public void widgetSelected(SelectionEvent e) {
                            ResultHistorySection resultHistorySection = ResultHistorySection.this;
                            resultHistorySection.STATUS_ORDER = resultHistorySection.STATUS_ORDER * -1;
                            ViewerSorter sorter = ResultHistorySection.this.getViewerSorter(0);
                            ResultHistorySection.this._resultsTreeTable.setSorter(sorter);
                            ResultHistorySection.this._resultsTreeTable.getTree().setSortColumn(column);
                            ResultHistorySection.this._resultsTreeTable.getTree().setSortDirection(ResultHistorySection.this.STATUS_ORDER == -1 ? 1024 : 128);
                        }
                    });
                    break;
                }
                case 1: {
                    column.setText(Messages.ResultHistorySection_operation);
                    column.addSelectionListener((SelectionListener)new SelectionAdapter(){

                        public void widgetSelected(SelectionEvent e) {
                            ResultHistorySection resultHistorySection = ResultHistorySection.this;
                            resultHistorySection.OPER_ORDER = resultHistorySection.OPER_ORDER * -1;
                            ViewerSorter sorter = ResultHistorySection.this.getViewerSorter(1);
                            ResultHistorySection.this._resultsTreeTable.setSorter(sorter);
                            ResultHistorySection.this._resultsTreeTable.getTree().setSortColumn(column);
                            ResultHistorySection.this._resultsTreeTable.getTree().setSortDirection(ResultHistorySection.this.OPER_ORDER == -1 ? 1024 : 128);
                        }
                    });
                    break;
                }
                case 2: {
                    column.setText(Messages.ResultHistorySection_frequency);
                    column.addSelectionListener((SelectionListener)new SelectionAdapter(){

                        public void widgetSelected(SelectionEvent e) {
                            ResultHistorySection resultHistorySection = ResultHistorySection.this;
                            resultHistorySection.FREQ_ORDER = resultHistorySection.FREQ_ORDER * -1;
                            ViewerSorter sorter = ResultHistorySection.this.getViewerSorter(2);
                            ResultHistorySection.this._resultsTreeTable.setSorter(sorter);
                            ResultHistorySection.this._resultsTreeTable.getTree().setSortColumn(column);
                            ResultHistorySection.this._resultsTreeTable.getTree().setSortDirection(ResultHistorySection.this.FREQ_ORDER == -1 ? 1024 : 128);
                        }
                    });
                    break;
                }
                case 3: {
                    column.setText(Messages.ResultHistorySection_date);
                    column.addSelectionListener((SelectionListener)new SelectionAdapter(){

                        public void widgetSelected(SelectionEvent e) {
                            ResultHistorySection resultHistorySection = ResultHistorySection.this;
                            resultHistorySection.DATE_ORDER = resultHistorySection.DATE_ORDER * -1;
                            ViewerSorter sorter = ResultHistorySection.this.getViewerSorter(3);
                            ResultHistorySection.this._resultsTreeTable.setSorter(sorter);
                            ResultHistorySection.this._resultsTreeTable.getTree().setSortColumn(column);
                            ResultHistorySection.this._resultsTreeTable.getTree().setSortDirection(ResultHistorySection.this.DATE_ORDER == -1 ? 1024 : 128);
                        }
                    });
                    break;
                }
                case 4: {
                    column.setText(Messages.ResultHistorySection_action_type);
                    column.addSelectionListener((SelectionListener)new SelectionAdapter(){

                        public void widgetSelected(SelectionEvent e) {
                            ResultHistorySection resultHistorySection = ResultHistorySection.this;
                            resultHistorySection.ACTION_ORDER = resultHistorySection.ACTION_ORDER * -1;
                            ViewerSorter sorter = ResultHistorySection.this.getViewerSorter(4);
                            ResultHistorySection.this._resultsTreeTable.setSorter(sorter);
                            ResultHistorySection.this._resultsTreeTable.getTree().setSortColumn(column);
                            ResultHistorySection.this._resultsTreeTable.getTree().setSortDirection(ResultHistorySection.this.ACTION_ORDER == -1 ? 1024 : 128);
                        }
                    });
                    break;
                }
                case 5: {
                    column.setText(Messages.ResultHistorySection_consumer_name);
                    column.addSelectionListener((SelectionListener)new SelectionAdapter(){

                        public void widgetSelected(SelectionEvent e) {
                            ResultHistorySection resultHistorySection = ResultHistorySection.this;
                            resultHistorySection.CONSUMER_ORDER = resultHistorySection.CONSUMER_ORDER * -1;
                            ViewerSorter sorter = ResultHistorySection.this.getViewerSorter(5);
                            ResultHistorySection.this._resultsTreeTable.setSorter(sorter);
                            ResultHistorySection.this._resultsTreeTable.getTree().setSortColumn(column);
                            ResultHistorySection.this._resultsTreeTable.getTree().setSortDirection(ResultHistorySection.this.CONSUMER_ORDER == -1 ? 1024 : 128);
                        }
                    });
                    break;
                }
                case 6: {
                    column.setText(Messages.ResultHistorySection_connection_profile);
                    column.addSelectionListener((SelectionListener)new SelectionAdapter(){

                        public void widgetSelected(SelectionEvent e) {
                            ResultHistorySection resultHistorySection = ResultHistorySection.this;
                            resultHistorySection.PROFILE_ORDER = resultHistorySection.PROFILE_ORDER * -1;
                            ViewerSorter sorter = ResultHistorySection.this.getViewerSorter(6);
                            ResultHistorySection.this._resultsTreeTable.setSorter(sorter);
                            ResultHistorySection.this._resultsTreeTable.getTree().setSortColumn(column);
                            ResultHistorySection.this._resultsTreeTable.getTree().setSortDirection(ResultHistorySection.this.PROFILE_ORDER == -1 ? 1024 : 128);
                        }
                    });
                    break;
                }
            }
            if (this._columnsWidth[configurableColumnIndex] != 0) {
                column.setWidth(this._columnsWidth[configurableColumnIndex]);
                isFirstTimeToCreate = false;
            } else {
                column.pack();
            }
            ++i;
        }
        if (isFirstTimeToCreate) {
            TreeColumn[] columns = this._resultsTreeTable.getTree().getColumns();
            int i2 = 0;
            while (i2 < columns.length) {
                columns[i2].setWidth(80);
                ++i2;
            }
        }
    }

    private void createContextMenu() {
        MenuManager mgr = new MenuManager();
        mgr.setRemoveAllWhenShown(true);
        mgr.addMenuListener(new IMenuListener(){

            public void menuAboutToShow(IMenuManager m) {
                ResultHistorySection.this.fillResultViewContextMenu(m);
            }
        });
        Menu menu = mgr.createContextMenu(this._resultsTreeTable.getControl());
        this._resultsTreeTable.getControl().setMenu(menu);
        if (this._resultsViewControl.getView() != null) {
            this._resultsViewControl.getView().getSite().registerContextMenu(mgr, (ISelectionProvider)this._resultsTreeTable);
        }
    }

    private void fillResultViewContextMenu(IMenuManager mgr) {
        IReExecutionRunnable runnable;
        IResultInstance ins;
        OperationCommand cmd;
        IAction[] actions = this._resultsViewControl.getRegisteredActions();
        int i = 0;
        while (i < actions.length) {
            mgr.add(actions[i]);
            if (actions[i] instanceof IUpdate) {
                ((IUpdate)actions[i]).update();
            }
            ++i;
        }
        ArrayList<IResultInstance> visibleFinishedItems = new ArrayList<IResultInstance>();
        IResultInstance[] visibleItems = this.getVisibleInstances();
        int i2 = 0;
        while (i2 < visibleItems.length) {
            if (visibleItems[i2].isFinished()) {
                visibleFinishedItems.add(visibleItems[i2]);
            }
            ++i2;
        }
        this._resultsViewControl.getRemoveAllVisibleFinishedResultAction().setInstances(visibleFinishedItems.toArray(new IResultInstance[0]));
        IStructuredSelection sel = (IStructuredSelection)this._resultsTreeTable.getSelection();
        if (!sel.isEmpty() && (cmd = (ins = (IResultInstance)sel.getFirstElement()).getOperationCommand()) != null && (runnable = ReExecutionRegistryReader.readProperReExecutionHandler((OperationCommand)cmd)) != null) {
            ReExecuteAction reExecuteAction = new ReExecuteAction(cmd, runnable);
            if (!ins.isFinished()) {
                reExecuteAction.setEnabled(false);
            }
            mgr.add((IAction)reExecuteAction);
        }
        mgr.add((IContributionItem)new Separator("additions"));
    }

    public TreeViewer getResultTable() {
        return this._resultsTreeTable;
    }

    public ISelection getSelection() {
        return this._resultsTreeTable.getSelection();
    }

    private boolean hasSubResult(Object e1, Object e2) {
        if (e1 instanceof IResultInstance && e2 instanceof IResultInstance) {
            IResultInstance ins1 = (IResultInstance)e1;
            IResultInstance ins2 = (IResultInstance)e2;
            if (!ins1.isParentResult() || !ins2.isParentResult()) {
                return true;
            }
        }
        return false;
    }

    private ViewerSorter getViewerSorter(int columnIndex) {
        switch (columnIndex) {
            case 3: {
                return new ViewerSorter(){

                    public int compare(Viewer viewer, Object e1, Object e2) {
                        if (ResultHistorySection.this.hasSubResult(e1, e2)) {
                            return 0;
                        }
                        if (e1 instanceof IResultInstance && e2 instanceof IResultInstance) {
                            Date date1 = ((IResultInstance)e1).getExecuteDate();
                            Date date2 = ((IResultInstance)e2).getExecuteDate();
                            if (ResultHistorySection.this.DATE_ORDER == ASCENDING) {
                                return date1.before(date2) ? -1 : 1;
                            }
                            return date1.after(date2) ? -1 : 1;
                        }
                        return 0;
                    }
                };
            }
            case 0: {
                return new ViewerSorter(){

                    public int compare(Viewer viewer, Object e1, Object e2) {
                        if (ResultHistorySection.this.hasSubResult(e1, e2)) {
                            return 0;
                        }
                        return super.compare(viewer, (Object)ResultHistorySection.this._resultViewLabelProvider.getColumnText(e1, 0), (Object)ResultHistorySection.this._resultViewLabelProvider.getConfigurableColumnText(e2, 0)) * ResultHistorySection.this.STATUS_ORDER;
                    }
                };
            }
            case 1: {
                return new ViewerSorter(){

                    public int compare(Viewer viewer, Object e1, Object e2) {
                        if (ResultHistorySection.this.hasSubResult(e1, e2)) {
                            return 0;
                        }
                        return super.compare(viewer, (Object)ResultHistorySection.this._resultViewLabelProvider.getColumnText(e1, 1), (Object)ResultHistorySection.this._resultViewLabelProvider.getConfigurableColumnText(e2, 1)) * ResultHistorySection.this.OPER_ORDER;
                    }
                };
            }
            case 2: {
                return new ViewerSorter(){

                    public int compare(Viewer viewer, Object e1, Object e2) {
                        if (ResultHistorySection.this.hasSubResult(e1, e2)) {
                            return 0;
                        }
                        try {
                            int freq1 = Integer.parseInt(ResultHistorySection.this._resultViewLabelProvider.getColumnText(e1, 2));
                            int freq2 = Integer.parseInt(ResultHistorySection.this._resultViewLabelProvider.getColumnText(e2, 2));
                            return (freq1 > freq2 ? 1 : -1) * ResultHistorySection.this.FREQ_ORDER;
                        }
                        catch (Exception exception) {
                            return 0;
                        }
                    }
                };
            }
            case 4: {
                return new ViewerSorter(){

                    public int compare(Viewer viewer, Object e1, Object e2) {
                        if (ResultHistorySection.this.hasSubResult(e1, e2)) {
                            return 0;
                        }
                        return super.compare(viewer, (Object)ResultHistorySection.this._resultViewLabelProvider.getColumnText(e1, 4), (Object)ResultHistorySection.this._resultViewLabelProvider.getConfigurableColumnText(e2, 4)) * ResultHistorySection.this.ACTION_ORDER;
                    }
                };
            }
            case 5: {
                return new ViewerSorter(){

                    public int compare(Viewer viewer, Object e1, Object e2) {
                        if (ResultHistorySection.this.hasSubResult(e1, e2)) {
                            return 0;
                        }
                        return super.compare(viewer, (Object)ResultHistorySection.this._resultViewLabelProvider.getColumnText(e1, 5), (Object)ResultHistorySection.this._resultViewLabelProvider.getConfigurableColumnText(e2, 5)) * ResultHistorySection.this.CONSUMER_ORDER;
                    }
                };
            }
            case 6: {
                return new ViewerSorter(){

                    public int compare(Viewer viewer, Object e1, Object e2) {
                        if (ResultHistorySection.this.hasSubResult(e1, e2)) {
                            return 0;
                        }
                        return super.compare(viewer, (Object)ResultHistorySection.this._resultViewLabelProvider.getColumnText(e1, 6), (Object)ResultHistorySection.this._resultViewLabelProvider.getConfigurableColumnText(e2, 6)) * ResultHistorySection.this.PROFILE_ORDER;
                    }
                };
            }
        }
        return null;
    }

    public IResultInstance[] getVisibleInstances() {
        TreeItem[] items = this._resultsTreeTable.getTree().getItems();
        IResultInstance[] visibleItems = new IResultInstance[items.length];
        int i = 0;
        while (i < items.length) {
            visibleItems[i] = (IResultInstance)items[i].getData();
            ++i;
        }
        return visibleItems;
    }

    public boolean isFilteredOut(IResultInstance instance) {
        ItemsLimitationTreeViewer viewer = (ItemsLimitationTreeViewer)this._resultsTreeTable;
        Object[] instances = viewer.getFilteredChildren(ResultsViewUIPlugin.getResultManager().getAllResults());
        int count = instances.length;
        int i = count - 1;
        while (i > -1) {
            if (instances[i] == instance) {
                return false;
            }
            --i;
        }
        return true;
    }

    private void prepareToQuery() {
        Display.getCurrent().timerExec(400, this._searchHistory);
    }

    public void reDisplayResults() {
        int i = 0;
        while (i < this._columnsWidth.length) {
            this._columnsWidth[i] = 0;
            ++i;
        }
        TreeColumn[] columns = this._resultsTreeTable.getTree().getColumns();
        int i2 = 0;
        while (i2 < columns.length) {
            int configurableColumnIndex = ResultHistoryHelper.getConfigurableColumnIndex(columns[i2].getText());
            if (configurableColumnIndex > -1) {
                this._columnsWidth[configurableColumnIndex] = columns[i2].getWidth();
            }
            columns[i2].dispose();
            ++i2;
        }
        this.createColumns();
        this._resultsTreeTable.refresh();
    }

    public void refresh() {
        this._resultsTreeTable.refresh();
    }

    public void dispose() {
        if (this._filterFont != null && !this._filterFont.isDisposed()) {
            this._filterFont.dispose();
        }
    }

    public void saveState(IMemento memento) {
        TreeColumn[] columns = this._resultsTreeTable.getTree().getColumns();
        int i = 0;
        while (i < this._columnsWidth.length) {
            this._columnsWidth[i] = 0;
            ++i;
        }
        i = 0;
        while (i < columns.length) {
            int configurableColumnIndex = ResultHistoryHelper.getConfigurableColumnIndex(i, this._resultsViewControl.getUsePreferences());
            if (configurableColumnIndex != -1) {
                this._columnsWidth[configurableColumnIndex] = columns[i].getWidth();
            }
            ++i;
        }
        i = 0;
        while (i < 7) {
            memento.putInteger(TAG_COLUMN_WIDTH + i, this._columnsWidth[i]);
            ++i;
        }
    }

    public void search() {
        BusyIndicator.showWhile((Display)this._resultsTreeTable.getTree().getDisplay(), (Runnable)new Runnable(){

            public void run() {
                if (!ResultHistorySection.this._firstClick) {
                    Display.getCurrent().syncExec(ResultHistorySection.this._searchHistory);
                } else {
                    ResultHistorySection.this._resultsTreeTable.setInput((Object)ResultsViewUIPlugin.getResultManager().getAllResults());
                }
            }
        });
    }
}

