/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.datatools.connectivity.oda.flatfile.util.querytextutil;

import java.util.ArrayList;
import java.util.Vector;
import org.eclipse.datatools.connectivity.oda.OdaException;
import org.eclipse.datatools.connectivity.oda.flatfile.i18n.Messages;
import org.eclipse.datatools.connectivity.oda.flatfile.util.FlatFileDataReader;

public class QueryTextUtil {
    private static final char QUERY_TEXT_DELIMITER = ':';
    private static final char COLUMNSINFO_BEGIN_DELIMITER = '{';
    private String query;
    private String columnsInfo;

    public QueryTextUtil(String queryText) throws OdaException {
        assert (queryText != null);
        String[] splits = this.splitQueryText(queryText);
        this.query = splits[0];
        this.columnsInfo = splits[1];
    }

    public String getQuery() {
        return this.query;
    }

    public String getColumnsInfo() {
        return this.columnsInfo;
    }

    private String[] splitQueryText(String queryText) throws OdaException {
        int delimiterIndex = -1;
        int columnsInfoBeginIndex = -1;
        String trimmedQueryText = queryText.trim();
        String[] splittedQueryText = new String[]{"", ""};
        boolean inQuote = false;
        boolean isEscaped = false;
        boolean isFrom = false;
        char[] chars = trimmedQueryText.toCharArray();
        int i = 0;
        while (i < chars.length) {
            if (!isFrom) {
                if (!inQuote && chars[i] == 'f' && i + 3 < chars.length && chars[i + 1] == 'r' && chars[i + 2] == 'o' && chars[i + 3] == 'm') {
                    isFrom = !isFrom;
                    i += 3;
                }
                if (chars[i] == '\"') {
                    if (!isEscaped) {
                        inQuote = !inQuote;
                    } else {
                        isEscaped = !isEscaped;
                    }
                } else if (chars[i] == '\\') {
                    isEscaped = !isEscaped;
                } else if (!inQuote && chars[i] == ':') {
                    delimiterIndex = i;
                } else if (!inQuote && chars[i] == '{') {
                    columnsInfoBeginIndex = i;
                    break;
                }
            } else if (chars[i] == '\"') {
                if (!isEscaped) {
                    inQuote = !inQuote;
                } else {
                    isEscaped = !isEscaped;
                }
            } else if (!inQuote && chars[i] == ':') {
                delimiterIndex = i;
            } else if (!inQuote && chars[i] == '{') {
                columnsInfoBeginIndex = i;
                break;
            }
            ++i;
        }
        if (inQuote) {
            throw new OdaException(Messages.getString("query_text_error"));
        }
        if (delimiterIndex != -1 && columnsInfoBeginIndex != -1) {
            splittedQueryText[0] = trimmedQueryText.substring(0, delimiterIndex).trim();
            splittedQueryText[1] = trimmedQueryText.substring(columnsInfoBeginIndex + 1, trimmedQueryText.length() - 1).trim();
        } else if (delimiterIndex == -1 && columnsInfoBeginIndex == -1) {
            splittedQueryText[0] = trimmedQueryText;
        } else {
            throw new OdaException(Messages.getString("query_text_error"));
        }
        return splittedQueryText;
    }

    protected static String stripSELECTKeyword(String formattedQuery) throws OdaException {
        String[] array = formattedQuery.split(" ", 2);
        if (array == null || array.length != 2 || !array[0].trim().equalsIgnoreCase("SELECT")) {
            throw new OdaException(Messages.getString("query_COMMAND_NOT_VALID"));
        }
        return array[1];
    }

    protected static String[] stripFROMKeyword(String query) throws OdaException {
        char[] chars = query.toCharArray();
        ArrayList<Integer> indiceList = new ArrayList<Integer>();
        boolean inQuote = false;
        boolean isEscaped = false;
        LookAheadMacher matcher = new LookAheadMacher("FROM ", " ", true);
        int i = 0;
        while (i < chars.length) {
            if (chars[i] == '\"') {
                if (!isEscaped) {
                    inQuote = !inQuote;
                } else {
                    isEscaped = !isEscaped;
                }
            } else if (chars[i] == '\\') {
                isEscaped = !isEscaped;
            } else if (!inQuote && matcher.match(chars, i)) {
                indiceList.add(i - 1);
            }
            ++i;
        }
        String[] result = new String[2];
        if (indiceList.size() <= 0) {
            throw new OdaException(Messages.getString("query_COMMAND_NOT_VALID"));
        }
        int splitInd = (Integer)indiceList.get(indiceList.size() - 1);
        result[0] = query.substring(0, splitInd);
        result[1] = QueryTextUtil.getUnQuotedName(query.substring(splitInd + matcher.getPatternLength()));
        return result;
    }

    public static String getQuotedName(String name) {
        if (name == null || name.charAt(0) == '\"' && name.charAt(name.length() - 1) == '\"') {
            return name;
        }
        StringBuffer sb = new StringBuffer("\"").append(name).append("\"");
        return sb.toString();
    }

    public static String getUnQuotedName(String name) {
        if (name == null || name.length() == 0) {
            return name;
        }
        int head = 0;
        int end = name.length();
        if (name.charAt(head) == '\"') {
            ++head;
        }
        if (name.charAt(name.length() - 1) == '\"') {
            --end;
        }
        return name.substring(head, end);
    }

    protected static String[] stripASKeyword(String[] querySelectAndFromFragments) {
        String[] result = new String[3];
        result[2] = querySelectAndFromFragments[1];
        String selectedColumns = querySelectAndFromFragments[0];
        if (!QueryTextUtil.isWildCard(selectedColumns)) {
            String[] columns = FlatFileDataReader.getStringArrayFromList(QueryTextUtil.getQueryColumnNamesVector(selectedColumns));
            int i = 0;
            while (i < columns.length) {
                String[] columnNameAlias = columns[i].split(" AS ");
                if (columnNameAlias != null) {
                    String string = result[0] = i == 0 ? columnNameAlias[0] : String.valueOf(result[0]) + "," + columnNameAlias[0].trim();
                    result[1] = columnNameAlias.length == 2 ? (i == 0 ? columnNameAlias[1] : String.valueOf(result[1]) + "," + columnNameAlias[1].trim()) : (i == 0 ? null : String.valueOf(result[1]) + "," + null);
                }
                ++i;
            }
        } else {
            result[0] = "*";
            result[1] = null;
        }
        return result;
    }

    public static String[] getQueryMetaData(String query) throws OdaException {
        return QueryTextUtil.stripASKeyword(QueryTextUtil.stripFROMKeyword(QueryTextUtil.stripSELECTKeyword(query)));
    }

    static boolean isWildCard(String cCN) {
        return cCN.equalsIgnoreCase("*");
    }

    static Vector getQueryColumnNamesVector(String queryColumnNames) {
        Vector<String> result = new Vector<String>();
        char[] chars = queryColumnNames.toCharArray();
        ArrayList<Integer> indiceList = new ArrayList<Integer>();
        boolean inQuote = false;
        boolean isEscaped = false;
        int beginIndex = 0;
        int endIndex = 0;
        int i = 0;
        while (i < chars.length) {
            if (chars[i] == '\"') {
                if (!isEscaped) {
                    inQuote = !inQuote;
                } else {
                    isEscaped = !isEscaped;
                }
            } else if (chars[i] == '\\') {
                isEscaped = !isEscaped;
            } else if (chars[i] == ',' && !inQuote) {
                indiceList.add(new Integer(i));
            }
            ++i;
        }
        if (indiceList.size() > 0) {
            int j = 0;
            while (j < indiceList.size()) {
                endIndex = (Integer)indiceList.get(j);
                result.add(queryColumnNames.substring(beginIndex, endIndex).trim());
                beginIndex = endIndex + 1;
                if (j == indiceList.size() - 1) {
                    result.add(queryColumnNames.substring(beginIndex, queryColumnNames.length()).trim());
                }
                ++j;
            }
        } else {
            result.add(queryColumnNames);
        }
        return result;
    }

    static class LookAheadMacher {
        private String pattern = "";
        private String heading = "";
        private boolean caseInsensitive = false;

        LookAheadMacher(String pattern, String heading, boolean caseInsensitive) {
            this.pattern = pattern;
            this.heading = heading;
            this.caseInsensitive = caseInsensitive;
        }

        int getPatternLength() {
            return this.pattern.length() + this.heading.length();
        }

        boolean match(char[] ch, int ind) {
            boolean first = false;
            if (this.caseInsensitive) {
                first = Character.toUpperCase(this.pattern.charAt(0)) == Character.toUpperCase(ch[ind]);
            } else {
                boolean bl = first = this.pattern.charAt(0) == ch[ind];
            }
            if (!first) {
                return false;
            }
            return this.match(String.valueOf(ch), ind);
        }

        boolean match(String toMatch, int start) {
            if (toMatch == null || toMatch.length() - start < this.pattern.length()) {
                return false;
            }
            if (start < this.heading.length() - 1) {
                return false;
            }
            String to = toMatch.substring(start - this.heading.length(), start);
            if (this.caseInsensitive ? !this.heading.equalsIgnoreCase(to) : !this.heading.equals(to)) {
                return false;
            }
            to = toMatch.substring(start, start + this.pattern.length());
            if (to.length() != this.pattern.length()) {
                return false;
            }
            return !(this.caseInsensitive ? !this.pattern.equalsIgnoreCase(to) : !this.pattern.equals(to));
        }
    }
}

