/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.datatools.sqltools.sqlbuilder.expressionbuilder.caseexpr;

import java.util.Iterator;
import java.util.Vector;
import org.eclipse.datatools.modelbase.sql.query.QueryValueExpression;
import org.eclipse.datatools.modelbase.sql.query.SQLQueryObject;
import org.eclipse.datatools.modelbase.sql.query.ValueExpressionCaseSimple;
import org.eclipse.datatools.modelbase.sql.query.ValueExpressionCaseSimpleContent;
import org.eclipse.datatools.modelbase.sql.query.ValueExpressionColumn;
import org.eclipse.datatools.modelbase.sql.query.ValueExpressionSimple;
import org.eclipse.datatools.sqltools.sqlbuilder.Messages;
import org.eclipse.datatools.sqltools.sqlbuilder.expressionbuilder.ExpressionBuilderDialog;
import org.eclipse.datatools.sqltools.sqlbuilder.expressionbuilder.ExpressionBuilderWizard;
import org.eclipse.datatools.sqltools.sqlbuilder.expressionbuilder.actions.DeleteCaseClauseAction;
import org.eclipse.datatools.sqltools.sqlbuilder.expressionbuilder.caseexpr.CaseClauseElement;
import org.eclipse.datatools.sqltools.sqlbuilder.expressionbuilder.caseexpr.CaseElseClauseElement;
import org.eclipse.datatools.sqltools.sqlbuilder.expressionbuilder.caseexpr.CaseSimplePage;
import org.eclipse.datatools.sqltools.sqlbuilder.expressionbuilder.caseexpr.CaseSimpleWhenContentElement;
import org.eclipse.datatools.sqltools.sqlbuilder.model.ExpressionHelper;
import org.eclipse.datatools.sqltools.sqlbuilder.model.SQLBuilderConstants;
import org.eclipse.datatools.sqltools.sqlbuilder.model.SQLDomainModel;
import org.eclipse.datatools.sqltools.sqlbuilder.util.LabelValuePair;
import org.eclipse.datatools.sqltools.sqlbuilder.views.BuilderUtility;
import org.eclipse.datatools.sqltools.sqlbuilder.views.DynamicComboBoxCellEditor;
import org.eclipse.datatools.sqltools.sqlbuilder.views.NavigableTableViewer;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IContributionItem;
import org.eclipse.jface.action.IMenuListener;
import org.eclipse.jface.action.IMenuManager;
import org.eclipse.jface.action.MenuManager;
import org.eclipse.jface.action.Separator;
import org.eclipse.jface.util.Assert;
import org.eclipse.jface.viewers.CellEditor;
import org.eclipse.jface.viewers.ColumnLayoutData;
import org.eclipse.jface.viewers.ColumnPixelData;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.ICellModifier;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.IStructuredContentProvider;
import org.eclipse.jface.viewers.ITableLabelProvider;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.jface.viewers.TableLayout;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Menu;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.TableColumn;
import org.eclipse.swt.widgets.TableItem;

public class CaseSimpleTable
extends NavigableTableViewer
implements IMenuListener {
    public static final String P_CASE_SIMPLE_WHEN = "org.eclipse.datatools.sqltools.sqlbuilder.expressionbuilder.P_CASE_SIMPLE_WHEN";
    public static final String P_CASE_SIMPLE_WHEN_EXPRESSION = "org.eclipse.datatools.sqltools.sqlbuilder.expressionbuilder.P_CASE_SIMPLE_WHEN_EXPRESSION";
    public static final String P_CASE_SIMPLE_OPERATOR = "org.eclipse.datatools.sqltools.sqlbuilder.expressionbuilder.P_CASE_SIMPLE_OPERATOR";
    public static final String P_CASE_SIMPLE_THEN = "org.eclipse.datatools.sqltools.sqlbuilder.expressionbuilder.P_CASE_SIMPLE_THEN";
    public static final String P_CASE_SIMPLE_RESULT_EXPRESSION = "org.eclipse.datatools.sqltools.sqlbuilder.expressionbuilder.P_CASE_SIMPLE_RESULT_EXPRESSION";
    private SQLDomainModel domainModel;
    private DynamicComboBoxCellEditor whenExpressionsComboBoxCellEditor;
    private DynamicComboBoxCellEditor resultExpressionsComboBoxCellEditor;
    private SQLQueryObject sqlStatement;
    private CaseSimplePage caseSimplePage;
    private Table table;
    private TableColumn c1;
    private TableColumn c2;
    private TableColumn c3;
    private TableColumn c4;
    private CellEditor[] editors;
    private CellEditor[] editorsForElse;
    private LabelValuePair[] valueItems = null;

    CaseSimpleTable(CaseSimplePage simplePage, Composite parent, SQLDomainModel domainModel, SQLQueryObject sqlStmt) {
        super(new Table(parent, 65538));
        this.domainModel = domainModel;
        this.sqlStatement = sqlStmt;
        this.caseSimplePage = simplePage;
        this.table = this.getTable();
        this.table.setLinesVisible(true);
        this.table.setHeaderVisible(true);
        this.table.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                CaseSimpleTable.this.refreshCellEditor(CaseSimpleTable.this.getTable().getSelectionIndex() >= 0 ? CaseSimpleTable.this.getTable().getSelectionIndex() : 0);
            }
        });
        this.c1 = new TableColumn(this.table, 0);
        this.c1.setText("");
        this.whenExpressionsComboBoxCellEditor = new DynamicComboBoxCellEditor((Composite)this.table, null, (Object)this);
        this.c2 = new TableColumn(this.table, 0);
        this.c2.setText(Messages._UI_COLUMN_CASE_EXPRESSION);
        this.c3 = new TableColumn(this.table, 0);
        this.c3.setText("");
        this.resultExpressionsComboBoxCellEditor = new DynamicComboBoxCellEditor((Composite)this.table, null, (Object)this);
        this.c4 = new TableColumn(this.table, 0);
        this.c4.setText(Messages._UI_COLUMN_RESULT_EXPRESSION);
        TableLayout layout = new TableLayout();
        layout.addColumnData((ColumnLayoutData)new ColumnPixelData(45, true));
        layout.addColumnData((ColumnLayoutData)new ColumnPixelData(150, true));
        layout.addColumnData((ColumnLayoutData)new ColumnPixelData(60, true));
        layout.addColumnData((ColumnLayoutData)new ColumnPixelData(150, true));
        this.table.setLayout((Layout)layout);
        String[] properties = new String[]{P_CASE_SIMPLE_WHEN, P_CASE_SIMPLE_WHEN_EXPRESSION, P_CASE_SIMPLE_THEN, P_CASE_SIMPLE_RESULT_EXPRESSION};
        this.setColumnProperties(properties);
        this.editors = new CellEditor[4];
        this.editors[0] = null;
        this.editors[1] = this.whenExpressionsComboBoxCellEditor;
        this.editors[2] = null;
        this.editors[3] = this.resultExpressionsComboBoxCellEditor;
        this.editorsForElse = new CellEditor[4];
        this.editorsForElse[0] = null;
        this.editorsForElse[1] = this.whenExpressionsComboBoxCellEditor;
        this.editorsForElse[2] = null;
        this.editorsForElse[3] = null;
        this.setCellEditors(this.editors);
        this.setCellModifier(new CaseSimpleTableCellModifier(this));
        this.setLabelProvider((IBaseLabelProvider)new CaseSimpleTableLabelProvider());
        this.setContentProvider((IContentProvider)new CaseSimpleTableContentProvider());
        MenuManager contextMenu = new MenuManager("#PopUp");
        contextMenu.add((IContributionItem)new Separator("additions"));
        contextMenu.setRemoveAllWhenShown(true);
        contextMenu.addMenuListener((IMenuListener)this);
        Menu menu = contextMenu.createContextMenu(this.getControl());
        this.getControl().setMenu(menu);
    }

    public CaseSimplePage getCaseSimplePage() {
        return this.caseSimplePage;
    }

    public SQLDomainModel getDomainModel() {
        return this.domainModel;
    }

    public SQLQueryObject getSQLStatement() {
        return this.sqlStatement;
    }

    @Override
    public void refresh() {
        if (!this.isCellEditorActive()) {
            super.refresh();
        }
    }

    public void refreshCellEditor(int row) {
        boolean whenExistsExpression = false;
        boolean resultExistsExpression = false;
        boolean elseExistsExpression = false;
        Object obj = this.getElementAt(row);
        if (obj instanceof CaseSimpleWhenContentElement) {
            Object when = ((CaseSimpleWhenContentElement)obj).getWhen();
            Object result = ((CaseSimpleWhenContentElement)obj).getResult();
            if (when instanceof QueryValueExpression && !((QueryValueExpression)when).toString().equals("")) {
                whenExistsExpression = true;
            }
            if (result instanceof QueryValueExpression && !((QueryValueExpression)result).toString().equals("")) {
                resultExistsExpression = true;
            }
            BuilderUtility.fillColumnComboBox(this.whenExpressionsComboBoxCellEditor, this.sqlStatement, true, whenExistsExpression);
            BuilderUtility.fillColumnComboBox(this.resultExpressionsComboBoxCellEditor, this.sqlStatement, true, resultExistsExpression);
            this.editors[0] = null;
            this.editors[1] = this.whenExpressionsComboBoxCellEditor;
            this.editors[2] = null;
            this.editors[3] = this.resultExpressionsComboBoxCellEditor;
            this.setCellEditors(this.editors);
        } else if (obj instanceof CaseElseClauseElement) {
            Object expr = ((CaseElseClauseElement)obj).getResult();
            if (expr instanceof QueryValueExpression) {
                elseExistsExpression = true;
            }
            BuilderUtility.fillColumnComboBox(this.whenExpressionsComboBoxCellEditor, this.sqlStatement, true, elseExistsExpression);
            this.editorsForElse[0] = null;
            this.editorsForElse[1] = this.whenExpressionsComboBoxCellEditor;
            this.editorsForElse[2] = null;
            this.editorsForElse[3] = null;
            this.setCellEditors(this.editorsForElse);
        }
    }

    public void refreshWhenContent(Vector colValues) {
        this.valueItems = new LabelValuePair[colValues.size()];
        int i = 0;
        while (i < colValues.size()) {
            if (colValues.elementAt(i) instanceof QueryValueExpression) {
                QueryValueExpression exp = (QueryValueExpression)colValues.elementAt(i);
                this.valueItems[i] = new LabelValuePair(exp.toString(), exp);
            } else if (colValues.elementAt(i) instanceof String) {
                this.valueItems[i] = new LabelValuePair((String)colValues.elementAt(i), ExpressionHelper.createExpression(colValues.elementAt(i)));
            }
            ++i;
        }
    }

    public void menuAboutToShow(IMenuManager menu) {
        DeleteCaseClauseAction deleteCaseClauseAction = new DeleteCaseClauseAction(this, this.caseSimplePage);
        if (this.table.getSelectionCount() > 0) {
            TableItem tableItem = this.table.getSelection()[0];
            Object data = tableItem.getData();
            if (data instanceof CaseSimpleWhenContentElement) {
                deleteCaseClauseAction.setText(Messages._UI_ACTION_DELETE_WHEN_CLAUSE);
            } else if (data instanceof CaseElseClauseElement) {
                deleteCaseClauseAction.setText(Messages._UI_ACTION_DELETE_ELSE_EXPRESSION);
            }
        }
        menu.add((IAction)deleteCaseClauseAction);
    }

    protected void inputChanged(Object input, Object oldInput) {
        super.inputChanged(input, oldInput);
    }

    public class CaseSimpleTableCellModifier
    implements ICellModifier {
        CaseSimpleTable viewer;
        Object currentElement;
        Object currentValue;
        String currentProperty;
        CaseSimpleWhenContentElement contentElement;
        CaseElseClauseElement elseElement;
        CaseClauseElement caseElement;
        QueryValueExpression expr;

        public CaseSimpleTableCellModifier(CaseSimpleTable viewer) {
            this.viewer = viewer;
        }

        public boolean canModify(Object element, String property) {
            return property.equals(CaseSimpleTable.P_CASE_SIMPLE_WHEN_EXPRESSION) || property.equals(CaseSimpleTable.P_CASE_SIMPLE_RESULT_EXPRESSION);
        }

        public Object getValue(Object element, String property) {
            return element;
        }

        public void modify(Object element, String property, Object value) {
            this.currentElement = element;
            this.currentProperty = property;
            this.currentValue = value;
            if (property.equals(CaseSimpleTable.P_CASE_SIMPLE_WHEN_EXPRESSION) || property.equals(CaseSimpleTable.P_CASE_SIMPLE_RESULT_EXPRESSION)) {
                Assert.isTrue((boolean)(this.currentElement instanceof TableItem));
                Object data = ((TableItem)this.currentElement).getData();
                if (this.currentValue == null) {
                    return;
                }
                if (data instanceof CaseSimpleWhenContentElement) {
                    this.contentElement = (CaseSimpleWhenContentElement)data;
                    if (this.currentValue instanceof QueryValueExpression) {
                        this.expr = this.currentValue instanceof ValueExpressionColumn ? ExpressionHelper.createValueExpressionColumn((ValueExpressionColumn)this.currentValue) : (this.currentValue instanceof ValueExpressionSimple ? (ValueExpressionSimple)this.currentValue : (QueryValueExpression)this.currentValue);
                        if (property.equals(CaseSimpleTable.P_CASE_SIMPLE_WHEN_EXPRESSION)) {
                            this.contentElement.setWhenExpression(this.expr);
                        } else if (property.equals(CaseSimpleTable.P_CASE_SIMPLE_RESULT_EXPRESSION)) {
                            this.contentElement.setResultExpression(this.expr);
                        }
                        Display.getCurrent().asyncExec(new Runnable(){

                            @Override
                            public void run() {
                                CaseSimpleTableCellModifier.this.viewer.refresh();
                            }
                        });
                        CaseSimpleTable.this.getCaseSimplePage().updateFinishButton();
                    } else if (this.currentValue instanceof String) {
                        String valueString = (String)this.currentValue;
                        Object currExpr = null;
                        if (property.equals(CaseSimpleTable.P_CASE_SIMPLE_WHEN_EXPRESSION)) {
                            currExpr = this.contentElement.getWhen();
                        } else if (property.equals(CaseSimpleTable.P_CASE_SIMPLE_RESULT_EXPRESSION)) {
                            currExpr = this.contentElement.getResult();
                        }
                        CaseSimpleTable.this.getCaseSimplePage().setElementToUpdate(this.contentElement);
                        if (valueString.equals(SQLBuilderConstants.P_BUILD_EXPRESSION) || valueString.equals(SQLBuilderConstants.P_EDIT_EXPRESSION) || valueString.equals(SQLBuilderConstants.P_REPLACE_EXPRESSION)) {
                            ExpressionBuilderWizard wizard = new ExpressionBuilderWizard(CaseSimpleTable.this.getDomainModel(), CaseSimpleTable.this.getSQLStatement());
                            if (valueString.equals(SQLBuilderConstants.P_BUILD_EXPRESSION) || valueString.equals(SQLBuilderConstants.P_REPLACE_EXPRESSION)) {
                                wizard.setInputExpression(null);
                            } else if (valueString.equals(SQLBuilderConstants.P_EDIT_EXPRESSION)) {
                                wizard.setInputExpression((QueryValueExpression)currExpr);
                            }
                            wizard.setIsColumn(false);
                            ExpressionBuilderDialog dialog = new ExpressionBuilderDialog(Display.getDefault().getActiveShell(), wizard);
                            dialog.create();
                            dialog.setBlockOnOpen(true);
                            int result = dialog.open();
                            QueryValueExpression newExpr = null;
                            if (result == 0) {
                                newExpr = wizard.getSQLExpression();
                            }
                            if (newExpr != null) {
                                if (property.equals(CaseSimpleTable.P_CASE_SIMPLE_WHEN_EXPRESSION)) {
                                    this.contentElement.setWhenExpression(newExpr);
                                } else if (property.equals(CaseSimpleTable.P_CASE_SIMPLE_RESULT_EXPRESSION)) {
                                    this.contentElement.setResultExpression(newExpr);
                                }
                                Display.getCurrent().asyncExec(new Runnable(){

                                    @Override
                                    public void run() {
                                        CaseSimpleTableCellModifier.this.viewer.refresh();
                                    }
                                });
                            }
                            CaseSimpleTable.this.getCaseSimplePage().updateFinishButton();
                        }
                    }
                } else if (data instanceof CaseElseClauseElement) {
                    this.elseElement = (CaseElseClauseElement)data;
                    if (this.currentValue instanceof QueryValueExpression) {
                        this.expr = this.currentValue instanceof ValueExpressionColumn ? ExpressionHelper.createValueExpressionColumn((ValueExpressionColumn)this.currentValue) : (this.currentValue instanceof ValueExpressionSimple ? (ValueExpressionSimple)this.currentValue : (QueryValueExpression)this.currentValue);
                        if (property.equals(CaseSimpleTable.P_CASE_SIMPLE_WHEN_EXPRESSION)) {
                            this.elseElement.setResult(this.expr);
                        }
                        Display.getCurrent().asyncExec(new Runnable(){

                            @Override
                            public void run() {
                                CaseSimpleTableCellModifier.this.viewer.refresh();
                            }
                        });
                        CaseSimpleTable.this.getCaseSimplePage().updateFinishButton();
                    } else if (this.currentValue instanceof String) {
                        String valueString = (String)this.currentValue;
                        Object currExpr = null;
                        if (property.equals(CaseSimpleTable.P_CASE_SIMPLE_WHEN_EXPRESSION)) {
                            currExpr = this.elseElement.getResult();
                        }
                        CaseSimpleTable.this.getCaseSimplePage().setElementToUpdate(this.contentElement);
                        if (valueString.equals(SQLBuilderConstants.P_BUILD_EXPRESSION) || valueString.equals(SQLBuilderConstants.P_EDIT_EXPRESSION) || valueString.equals(SQLBuilderConstants.P_REPLACE_EXPRESSION)) {
                            ExpressionBuilderWizard wizard = new ExpressionBuilderWizard(CaseSimpleTable.this.getDomainModel(), CaseSimpleTable.this.getSQLStatement());
                            if (valueString.equals(SQLBuilderConstants.P_BUILD_EXPRESSION) || valueString.equals(SQLBuilderConstants.P_REPLACE_EXPRESSION)) {
                                wizard.setInputExpression(null);
                            } else if (valueString.equals(SQLBuilderConstants.P_EDIT_EXPRESSION)) {
                                wizard.setInputExpression((QueryValueExpression)currExpr);
                            }
                            wizard.setIsColumn(false);
                            ExpressionBuilderDialog dialog = new ExpressionBuilderDialog(Display.getDefault().getActiveShell(), wizard);
                            dialog.create();
                            dialog.setBlockOnOpen(true);
                            int result = dialog.open();
                            QueryValueExpression newExpr = null;
                            if (result == 0) {
                                newExpr = wizard.getSQLExpression();
                            }
                            if (newExpr != null) {
                                if (property.equals(CaseSimpleTable.P_CASE_SIMPLE_WHEN_EXPRESSION)) {
                                    this.elseElement.setResult(newExpr);
                                }
                                Display.getCurrent().asyncExec(new Runnable(){

                                    @Override
                                    public void run() {
                                        CaseSimpleTableCellModifier.this.viewer.refresh();
                                    }
                                });
                            }
                            CaseSimpleTable.this.getCaseSimplePage().updateFinishButton();
                        }
                    }
                }
            }
        }
    }

    public class CaseSimpleTableContentProvider
    implements IStructuredContentProvider {
        protected Vector tableElements;
        protected ValueExpressionCaseSimple sqlCaseSimple;
        protected boolean firstClause;

        public void dispose() {
        }

        public void inputChanged(Viewer viewer, Object old, Object newobj) {
        }

        public Object[] getElements(Object property) {
            if (property instanceof ValueExpressionCaseSimple) {
                this.tableElements = new Vector();
                this.sqlCaseSimple = (ValueExpressionCaseSimple)property;
                Iterator e = this.sqlCaseSimple.getContentList().iterator();
                ValueExpressionCaseSimpleContent content = null;
                while (e.hasNext()) {
                    content = (ValueExpressionCaseSimpleContent)e.next();
                    this.firstClause = true;
                    this.createNewContentElement(content);
                }
                if (content == null) {
                    this.createNewContentElement(null);
                }
                if (this.sqlCaseSimple.getCaseElse() != null) {
                    this.createCaseElseClauseElement();
                }
                CaseSimpleTable.this.getCaseSimplePage().updateFinishButton();
                return this.tableElements.toArray();
            }
            return null;
        }

        private void createNewContentElement(ValueExpressionCaseSimpleContent content) {
            this.tableElements.add(new CaseSimpleWhenContentElement(this.sqlCaseSimple, content, this.firstClause));
        }

        private void createCaseElseClauseElement() {
            this.tableElements.add(new CaseElseClauseElement(this.sqlCaseSimple));
        }
    }

    class CaseSimpleTableLabelProvider
    extends LabelProvider
    implements ITableLabelProvider {
        CaseSimpleTableLabelProvider() {
        }

        public String getColumnText(Object object, int columnIndex) {
            if (object instanceof CaseSimpleWhenContentElement) {
                CaseSimpleWhenContentElement contentElement = (CaseSimpleWhenContentElement)object;
                return contentElement.getColumnText(columnIndex);
            }
            if (object instanceof CaseClauseElement) {
                CaseClauseElement caseElement = (CaseClauseElement)object;
                return caseElement.getColumnText(columnIndex);
            }
            if (object instanceof CaseElseClauseElement) {
                CaseElseClauseElement elseElement = (CaseElseClauseElement)object;
                return elseElement.getColumnText(columnIndex);
            }
            return "";
        }

        public Image getColumnImage(Object object, int columnIndex) {
            return null;
        }
    }
}

