/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.datatools.enablement.oda.xml.ui.wizards;

import java.util.Properties;
import org.eclipse.datatools.connectivity.oda.IConnection;
import org.eclipse.datatools.connectivity.oda.IParameterMetaData;
import org.eclipse.datatools.connectivity.oda.IQuery;
import org.eclipse.datatools.connectivity.oda.IResultSetMetaData;
import org.eclipse.datatools.connectivity.oda.OdaException;
import org.eclipse.datatools.connectivity.oda.design.DataSetDesign;
import org.eclipse.datatools.connectivity.oda.design.DataSetParameters;
import org.eclipse.datatools.connectivity.oda.design.DesignFactory;
import org.eclipse.datatools.connectivity.oda.design.ParameterMode;
import org.eclipse.datatools.connectivity.oda.design.ResourceIdentifiers;
import org.eclipse.datatools.connectivity.oda.design.ResultSetColumns;
import org.eclipse.datatools.connectivity.oda.design.ResultSetDefinition;
import org.eclipse.datatools.connectivity.oda.design.ui.designsession.DesignSessionUtil;
import org.eclipse.datatools.enablement.oda.xml.impl.Driver;
import org.eclipse.datatools.enablement.oda.xml.ui.wizards.XMLInformationHolder;

public class DataSetDesignPopulator {
    private static final String EMPTY_STRING = "";

    public static void populateMetaData(DataSetDesign dataSetDesign) {
        block6: {
            IConnection conn = null;
            try {
                try {
                    Driver jdbcDriver = new Driver();
                    conn = jdbcDriver.getConnection(null);
                    Properties properties = new Properties();
                    String xmlFile = XMLInformationHolder.getPropertyValue("XML_FILE");
                    if (xmlFile == null || xmlFile.trim().length() == 0) {
                        xmlFile = XMLInformationHolder.getPropertyValue("FILELIST");
                    }
                    properties.setProperty("FILELIST", xmlFile == null ? EMPTY_STRING : xmlFile);
                    String xmlEncoding = XMLInformationHolder.getPropertyValue("ENCODINGLIST");
                    properties.setProperty("ENCODINGLIST", xmlEncoding == null ? EMPTY_STRING : xmlEncoding);
                    conn.setAppContext((Object)DesignSessionUtil.createResourceIdentifiersContext((ResourceIdentifiers)dataSetDesign.getDataSourceDesign().getHostResourceIdentifiers()));
                    conn.open(properties);
                    IQuery query = conn.newQuery(null);
                    query.setMaxRows(1);
                    query.prepare(XMLInformationHolder.getPropertyValue("RELATIONINFORMATION"));
                    IResultSetMetaData metadata = query.getMetaData();
                    DataSetDesignPopulator.setParameterMetaData(dataSetDesign, query.getParameterMetaData());
                    DataSetDesignPopulator.setResultSetMetaData(dataSetDesign, metadata);
                }
                catch (OdaException odaException) {
                    dataSetDesign.setResultSets(null);
                    DataSetDesignPopulator.closeConnection(conn);
                    break block6;
                }
            }
            catch (Throwable throwable) {
                DataSetDesignPopulator.closeConnection(conn);
                throw throwable;
            }
            DataSetDesignPopulator.closeConnection(conn);
        }
    }

    private static void closeConnection(IConnection conn) {
        try {
            if (conn != null) {
                conn.close();
            }
        }
        catch (OdaException e) {
            e.printStackTrace();
        }
    }

    private static void setResultSetMetaData(DataSetDesign dataSetDesign, IResultSetMetaData md) throws OdaException {
        ResultSetColumns columns = DesignSessionUtil.toResultSetColumnsDesign((IResultSetMetaData)md);
        if (columns != null) {
            ResultSetDefinition resultSetDefn = DesignFactory.eINSTANCE.createResultSetDefinition();
            resultSetDefn.setResultSetColumns(columns);
            dataSetDesign.setPrimaryResultSet(resultSetDefn);
            dataSetDesign.getResultSets().setDerivedMetaData(true);
        } else {
            dataSetDesign.setResultSets(null);
        }
    }

    private static void setParameterMetaData(DataSetDesign dataSetDesign, IParameterMetaData paramMeta) {
        try {
            DataSetDesignPopulator.mergeParameterMetaData(dataSetDesign, paramMeta);
        }
        catch (OdaException odaException) {}
    }

    private static void mergeParameterMetaData(DataSetDesign dataSetDesign, IParameterMetaData md) throws OdaException {
        if (md == null || dataSetDesign == null) {
            return;
        }
        DataSetParameters dataSetParameter = DesignSessionUtil.toDataSetParametersDesign((IParameterMetaData)md, (ParameterMode)ParameterMode.IN_LITERAL);
        dataSetDesign.setParameters(dataSetParameter);
    }
}

