/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.datatools.sqltools.debugger.core;

import org.eclipse.datatools.sqltools.core.DatabaseIdentifier;
import org.eclipse.datatools.sqltools.core.ServerIdentifier;
import org.eclipse.datatools.sqltools.core.profile.ProfileUtil;
import org.eclipse.datatools.sqltools.debugger.core.IDebugHandler;

public class ClientConInfo {
    private int _connId;
    private String _user;
    private Object _status = null;
    private IDebugHandler _debugHandler;
    private DatabaseIdentifier _databaseIdentifier;
    private ServerIdentifier _serverIdentifier;

    public ClientConInfo(IDebugHandler debugHandler, DatabaseIdentifier databaseIdentifier, int connid, String user) {
        this._debugHandler = debugHandler;
        this._databaseIdentifier = databaseIdentifier;
        this._connId = connid;
        this._user = user;
        this._serverIdentifier = ProfileUtil.getServerIdentifier((DatabaseIdentifier)this._databaseIdentifier);
    }

    public int getConnId() {
        return this._connId;
    }

    public String getUser() {
        return this._user;
    }

    public boolean updateStatus(String db, String user, Object status) {
        boolean changed = false;
        if (!this.equals(db, this._databaseIdentifier.getDBname())) {
            changed = true;
            this._databaseIdentifier.setDBname(db);
        }
        if (!this.equals(user, this._user)) {
            changed = true;
            this._user = user;
        }
        if (this._status == null) {
            this._status = status;
            return changed || status != null;
        }
        if (!this._status.equals(status)) {
            this._status = status;
            changed = true;
        }
        return changed;
    }

    public Object getStatus() {
        return this._status;
    }

    private boolean equals(String s1, String s2) {
        return s1 == null ? s2 == null : s1.equals(s2);
    }

    public boolean isAttached() {
        if (this._debugHandler != null) {
            return this._debugHandler.isAttached(this.getConnId());
        }
        return false;
    }

    public IDebugHandler getDebugHandler() {
        return this._debugHandler;
    }

    public ServerIdentifier getServerIdentifier() {
        return this._serverIdentifier;
    }

    public DatabaseIdentifier getDatabaseIdentifier() {
        return this._databaseIdentifier;
    }

    public void setStatus(Object status) {
        this._status = status;
    }
}

