/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.datatools.sqltools.result.internal.ui.view;

import org.eclipse.datatools.sqltools.result.internal.ui.LongDataDialog;
import org.eclipse.datatools.sqltools.result.internal.ui.Messages;
import org.eclipse.datatools.sqltools.result.internal.ui.PreferenceConstants;
import org.eclipse.datatools.sqltools.result.ui.ResultsViewUIPlugin;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.swt.custom.TableEditor;
import org.eclipse.swt.events.MouseAdapter;
import org.eclipse.swt.events.MouseEvent;
import org.eclipse.swt.events.MouseListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.TableColumn;
import org.eclipse.swt.widgets.TableItem;

public class ParameterTableViewer
extends TableViewer {
    public static final int PARAM_NAME = 0;
    public static final int PARAM_TYPE = 1;
    public static final int PARAM_DATA_TYPE = 2;
    public static final int PARAM_VALUE = 3;
    public static final int PARAM_VALUE_OUT = 4;
    protected static final String BUTTON_TEXT = "...";

    public ParameterTableViewer(Composite parent, int style) {
        super(parent, style);
        this.configureTableViewer();
    }

    protected void configureTableViewer() {
        this.setupMouseListener(this.getTable());
        this.getTable().setLinesVisible(true);
        this.getTable().setHeaderVisible(true);
        this.getTable().setLayoutData((Object)new GridData(1808));
        TableColumn nameColumn = new TableColumn(this.getTable(), 0);
        nameColumn.setText(Messages.MultipleTabsGridSection_parameter_name);
        TableColumn typeColumn = new TableColumn(this.getTable(), 0);
        typeColumn.setText(Messages.MultipleTabsGridSection_parameter_type);
        TableColumn dataTypeColumn = new TableColumn(this.getTable(), 0);
        dataTypeColumn.setText(Messages.MultipleTabsGridSection_parameter_datatype);
        TableColumn valueColumn = new TableColumn(this.getTable(), 0);
        valueColumn.setText(Messages.MultipleTabsGridSection_value);
        TableColumn outValueColumn = new TableColumn(this.getTable(), 0);
        outValueColumn.setText(Messages.MultipleTabsGridSection_value_out);
        int defaultWidth = 0;
        int columnCount = this.getTable().getColumnCount();
        int i = 0;
        while (i < columnCount) {
            TableColumn column = this.getTable().getColumn(i);
            column.pack();
            defaultWidth = defaultWidth + column.getWidth() + this.getTable().getGridLineWidth();
            ++i;
        }
        Composite comp = this.getTable().getParent();
        int moreWidth = comp.getParent().getBounds().width - 2 - defaultWidth;
        if (moreWidth > 0) {
            int i2 = 0;
            while (i2 < columnCount) {
                TableColumn col = this.getTable().getColumn(i2);
                col.setWidth(col.getWidth() + moreWidth / columnCount);
                ++i2;
            }
        }
        this.getTable().pack();
    }

    protected void setupMouseListener(final Table paramTable) {
        final TableEditor editor = new TableEditor(paramTable);
        editor.horizontalAlignment = 16384;
        paramTable.addMouseListener((MouseListener)new MouseAdapter(){

            public void mouseDown(MouseEvent evt) {
                int b = evt.button;
                int stateMask = evt.stateMask;
                if (b == 1 && stateMask == 0) {
                    int rowSelected = paramTable.getSelectionIndex();
                    if (rowSelected == -1) {
                        return;
                    }
                    TableItem tabItem = paramTable.getItem(rowSelected);
                    int columnSelected = -1;
                    int columns = paramTable.getColumnCount();
                    int maxColumnCount = columns == 0 ? 0 : columns - 1;
                    Rectangle clientR = paramTable.getClientArea();
                    Point point = new Point(evt.x, evt.y);
                    int i = 0;
                    while (i <= maxColumnCount) {
                        Rectangle rect = tabItem.getBounds(i);
                        if (rect.y > clientR.y + clientR.height) {
                            return;
                        }
                        if (rect.contains(point)) {
                            columnSelected = i;
                            break;
                        }
                        ++i;
                    }
                    if (columnSelected != -1) {
                        Control oldEditor;
                        int parameterMaxLength = ResultsViewUIPlugin.getDefault().getPreferenceStore().getInt(PreferenceConstants.ELLIPSIS_ENABLED_VALUE_LENGTH);
                        if (columnSelected > 2 && tabItem.getText(columnSelected).length() > parameterMaxLength) {
                            oldEditor = editor.getEditor();
                            if (oldEditor != null) {
                                oldEditor.dispose();
                            }
                            Button button = new Button((Composite)paramTable, 8);
                            button.setText(ParameterTableViewer.BUTTON_TEXT);
                            button.setToolTipText(Messages.MultibleTabsEllipsisToolTipText);
                            button.setSize(button.computeSize(-1, -1));
                            editor.minimumWidth = button.computeSize((int)-1, (int)-1).x;
                            editor.setEditor((Control)button, tabItem, columnSelected);
                            ParameterTableViewer.this.addListenerForEllipses(paramTable, tabItem, columnSelected, button);
                        } else {
                            oldEditor = editor.getEditor();
                            if (oldEditor != null) {
                                oldEditor.dispose();
                            }
                        }
                    }
                }
            }
        });
    }

    protected void addListenerForEllipses(final Table paramTable, TableItem tabItem, int columnSelected, Button button) {
        final String paramName = tabItem.getText(0);
        final String paramDatatype = tabItem.getText(2);
        final String paramValue = tabItem.getText(columnSelected);
        button.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                LongDataDialog dialog = new LongDataDialog(paramTable.getShell(), paramName, paramDatatype, paramValue);
                dialog.open();
            }
        });
    }
}

