/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.datatools.enablement.oda.xml.util;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.eclipse.datatools.enablement.oda.xml.util.IXMLPathNode;
import org.eclipse.datatools.enablement.oda.xml.util.XMLAttr;
import org.eclipse.datatools.enablement.oda.xml.util.XMLElement;
import org.eclipse.datatools.enablement.oda.xml.util.XMLPath;

class XMLPathHolder {
    private List elementBlocks = new ArrayList();

    public XMLPathHolder() {
        this.elementBlocks.add(new XMLElementBlock(new XMLElement("/", 1)));
    }

    public void startElement(String elementName) {
        XMLElementBlock parent = (XMLElementBlock)this.elementBlocks.get(this.elementBlocks.size() - 1);
        XMLElement child = parent.addSubElement(elementName);
        this.elementBlocks.add(new XMLElementBlock(child));
    }

    public void endElement() {
        this.elementBlocks.remove(this.elementBlocks.size() - 1);
    }

    public XMLPath getCurrentElementPath() {
        IXMLPathNode[] nodes = new IXMLPathNode[this.elementBlocks.size() - 1];
        int i = 1;
        while (i < this.elementBlocks.size()) {
            nodes[i - 1] = ((XMLElementBlock)this.elementBlocks.get(i)).getElement();
            ++i;
        }
        return new XMLPath(nodes);
    }

    public XMLPath getCurrentAttrPath(String attrName) {
        IXMLPathNode[] nodes = new IXMLPathNode[this.elementBlocks.size()];
        int i = 1;
        while (i < this.elementBlocks.size()) {
            nodes[i - 1] = ((XMLElementBlock)this.elementBlocks.get(i)).getElement();
            ++i;
        }
        nodes[nodes.length - 1] = new XMLAttr(attrName);
        return new XMLPath(nodes);
    }

    private static class XMLElementBlock {
        private XMLElement element;
        private Map childCounts = new HashMap();

        public XMLElementBlock(XMLElement element) {
            assert (element != null);
            this.element = element;
        }

        public XMLElement addSubElement(String elementName) {
            assert (elementName != null);
            int index = 0;
            if (this.childCounts.get(elementName) != null) {
                index = (Integer)this.childCounts.get(elementName);
            }
            this.childCounts.put(elementName, new Integer(++index));
            return new XMLElement(elementName, index);
        }

        public XMLElement getElement() {
            return this.element;
        }
    }
}

