/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.datatools.sqltools.sqlbuilder.actions;

import org.eclipse.datatools.modelbase.sql.query.QueryCombined;
import org.eclipse.datatools.modelbase.sql.query.QueryExpressionBody;
import org.eclipse.datatools.modelbase.sql.query.QueryExpressionRoot;
import org.eclipse.datatools.modelbase.sql.query.QueryStatement;
import org.eclipse.datatools.modelbase.sql.query.QueryValues;
import org.eclipse.datatools.modelbase.sql.query.SQLQueryObject;
import org.eclipse.datatools.modelbase.sql.query.TableExpression;
import org.eclipse.datatools.modelbase.sql.query.ValuesRow;
import org.eclipse.datatools.modelbase.sql.query.WithTableSpecification;
import org.eclipse.datatools.modelbase.sql.query.helper.StatementHelper;
import org.eclipse.datatools.sqltools.sqlbuilder.Messages;
import org.eclipse.datatools.sqltools.sqlbuilder.model.SQLDomainModel;
import org.eclipse.datatools.sqltools.sqlbuilder.model.SelectHelper;
import org.eclipse.emf.common.util.EList;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.ui.views.contentoutline.ContentOutlinePage;

public class DeleteStatementAction
extends Action {
    Object object;
    SQLDomainModel domainModel;
    ContentOutlinePage outline;

    public DeleteStatementAction(SQLDomainModel domainModel, ContentOutlinePage outline) {
        super(Messages._UI_ACTION_DELETE_STATEMENT);
        this.domainModel = domainModel;
        this.outline = outline;
    }

    public void setElement(Object obj) {
        this.object = obj;
    }

    public void run() {
        QueryStatement newObjectToSelect = null;
        if (this.object instanceof QueryExpressionBody) {
            QueryExpressionBody queryExprBody = (QueryExpressionBody)this.object;
            QueryCombined parent = queryExprBody.getCombinedRight();
            if (parent != null) {
                parent.setRightQuery(null);
            } else {
                parent = queryExprBody.getCombinedLeft();
                if (parent != null) {
                    QueryExpressionBody rightChild = parent.getRightQuery();
                    parent.setLeftQuery(rightChild);
                }
            }
        } else if (this.object instanceof ValuesRow) {
            ValuesRow row = (ValuesRow)this.object;
            QueryValues values = row.getQueryValues();
            EList rowList = values.getValuesRowList();
            rowList.remove(row);
        } else if (this.object instanceof WithTableSpecification) {
            WithTableSpecification withTable = (WithTableSpecification)this.object;
            QueryExpressionRoot qRoot = withTable.getQueryExpressionRoot();
            EList wTableList = withTable.getWithTableReferences();
            if (wTableList.size() > 0) {
                int i = 0;
                while (i < wTableList.size()) {
                    StatementHelper.removeTableExpressionFromQueryStatement((TableExpression)((TableExpression)wTableList.get(i)), (SQLQueryObject)this.domainModel.getSQLStatement());
                    ++i;
                }
            }
            qRoot.getWithClause().remove(this.object);
            newObjectToSelect = this.domainModel.getSQLStatement();
            SelectHelper.refresh((SQLQueryObject)this.domainModel.getSQLStatement());
        }
        if (newObjectToSelect != null) {
            this.outline.setSelection((ISelection)new StructuredSelection(newObjectToSelect));
        }
    }
}

