/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.datatools.enablement.msft.sqlserver.ui.drivers;

import com.ibm.icu.text.MessageFormat;
import java.util.ArrayList;
import java.util.List;
import java.util.Properties;
import org.eclipse.datatools.connectivity.internal.ui.ConnectivityUIPlugin;
import org.eclipse.datatools.connectivity.ui.wizards.IDriverUIContributor;
import org.eclipse.datatools.connectivity.ui.wizards.IDriverUIContributorInformation;
import org.eclipse.datatools.connectivity.ui.wizards.OptionalPropertiesPane;
import org.eclipse.datatools.enablement.msft.sqlserver.internal.ui.connection.drivers.Messages;
import org.eclipse.jface.dialogs.DialogPage;
import org.eclipse.swt.custom.ScrolledComposite;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.TabFolder;
import org.eclipse.swt.widgets.TabItem;
import org.eclipse.swt.widgets.Text;

public class SQLServer2000DriverUIContributorBase
implements IDriverUIContributor,
Listener {
    private static final String CUI_NEWCW_DATABASE_LBL_UI_ = Messages.getString("CUI_NEWCW_DATABASE_LBL_UI_");
    private static final String CUI_NEWCW_HOST_LBL_UI_ = Messages.getString("CUI_NEWCW_HOST_LBL_UI_");
    private static final String CUI_NEWCW_PORT_LBL_UI_ = Messages.getString("CUI_NEWCW_PORT_LBL_UI_");
    private static final String CUI_NEWCW_USERNAME_LBL_UI_ = Messages.getString("CUI_NEWCW_USERNAME_LBL_UI_");
    private static final String CUI_NEWCW_PASSWORD_LBL_UI_ = Messages.getString("CUI_NEWCW_PASSWORD_LBL_UI_");
    private static final String CUI_NEWCW_SAVE_PASSWORD_LBL_UI_ = Messages.getString("CUI_NEWCW_SAVE_PASSWORD_LBL_UI_");
    private static final String CUI_NEWCW_CONNECTIONURL_LBL_UI_ = Messages.getString("CUI_NEWCW_CONNECTIONURL_LBL_UI_");
    private static final String CUI_NEWCW_DEFDBNAME_VAL_UI_ = Messages.getString("CUI_NEWCW_DEFDBNAME_VAL_UI_");
    private static final String CUI_NEWCW_DATABASE_SUMMARY_DATA_TEXT_ = Messages.getString("CUI_NEWCW_DATABASE_SUMMARY_DATA_TEXT_");
    private static final String CUI_NEWCW_HOST_SUMMARY_DATA_TEXT_ = Messages.getString("CUI_NEWCW_HOST_SUMMARY_DATA_TEXT_");
    private static final String CUI_NEWCW_PORT_SUMMARY_DATA_TEXT_ = Messages.getString("CUI_NEWCW_PORT_SUMMARY_DATA_TEXT_");
    private static final String CUI_NEWCW_USERNAME_SUMMARY_DATA_TEXT_ = Messages.getString("CUI_NEWCW_USERNAME_SUMMARY_DATA_TEXT_");
    private static final String CUI_NEWCW_SAVE_PASSWORD_SUMMARY_DATA_TEXT_ = Messages.getString("CUI_NEWCW_SAVE_PASSWORD_SUMMARY_DATA_TEXT_");
    private static final String CUI_NEWCW_TRUE_SUMMARY_DATA_TEXT_ = Messages.getString("CUI_NEWCW_TRUE_SUMMARY_DATA_TEXT_");
    private static final String CUI_NEWCW_FALSE_SUMMARY_DATA_TEXT_ = Messages.getString("CUI_NEWCW_FALSE_SUMMARY_DATA_TEXT_");
    private static final String CUI_NEWCW_URL_SUMMARY_DATA_TEXT_ = Messages.getString("CUI_NEWCW_URL_SUMMARY_DATA_TEXT_");
    protected IDriverUIContributorInformation contributorInformation;
    private Label databaseLabel;
    protected Text databaseText;
    private Label hostLabel;
    protected Text hostText;
    private Label portLabel;
    protected Text portText;
    private Label usernameLabel;
    private Text usernameText;
    private Label passwordLabel;
    private Text passwordText;
    private Button savePasswordButton;
    private Label urlLabel;
    protected Text urlText;
    protected DialogPage parentPage;
    private ScrolledComposite parentComposite;
    protected OptionalPropertiesPane optionalPropsComposite;
    private Properties properties;
    protected boolean isReadOnly = false;

    public boolean determineContributorCompletion() {
        boolean isComplete = true;
        if (this.databaseText.getText().trim().length() < 1) {
            this.parentPage.setErrorMessage(MessageFormat.format((String)Messages.getString("CUI_NEWCW_VALIDATE_DATABASE_REQ_UI_"), (Object[])new String[]{CUI_NEWCW_DEFDBNAME_VAL_UI_}));
            isComplete = false;
        } else if (this.hostText.getText().length() < 1) {
            this.parentPage.setErrorMessage(Messages.getString("CUI_NEWCW_VALIDATE_HOST_REQ_UI_"));
            isComplete = false;
        } else if (this.portText.getText().length() < 1) {
            this.parentPage.setErrorMessage(Messages.getString("CUI_NEWCW_VALIDATE_PORT_REQ_UI_"));
            isComplete = false;
        } else if (this.usernameText.getText().trim().length() < 1) {
            this.parentPage.setErrorMessage(Messages.getString("CUI_NEWCW_VALIDATE_USERID_REQ_UI_"));
            isComplete = false;
        } else if (this.urlText.getText().trim().length() < 1) {
            this.parentPage.setErrorMessage(Messages.getString("CUI_NEWCW_VALIDATE_URL_REQ_UI_"));
            isComplete = false;
        } else if (!this.optionalPropsComposite.validateControl(this.parentPage)) {
            isComplete = false;
        }
        return isComplete;
    }

    public Composite getContributedDriverUI(Composite parent, boolean isReadOnly) {
        if (this.parentComposite == null || this.parentComposite.isDisposed() || this.isReadOnly != isReadOnly) {
            this.isReadOnly = isReadOnly;
            int additionalStyles = 0;
            if (isReadOnly) {
                additionalStyles = 8;
            }
            this.parentComposite = new ScrolledComposite(parent, 768);
            this.parentComposite.setExpandHorizontal(true);
            this.parentComposite.setExpandVertical(true);
            this.parentComposite.setLayout((Layout)new GridLayout());
            TabFolder tabComposite = new TabFolder((Composite)this.parentComposite, 128);
            TabItem generalTab = new TabItem(tabComposite, 0);
            generalTab.setText(ConnectivityUIPlugin.getDefault().getResourceString("CommonDriverUIContributor.generaltab"));
            Composite baseComposite = new Composite((Composite)tabComposite, 0);
            GridLayout layout = new GridLayout();
            layout.numColumns = 3;
            baseComposite.setLayout((Layout)layout);
            generalTab.setControl((Control)baseComposite);
            this.databaseLabel = new Label(baseComposite, 0);
            this.databaseLabel.setText(CUI_NEWCW_DATABASE_LBL_UI_);
            GridData gd = new GridData();
            gd.verticalAlignment = 1;
            this.databaseLabel.setLayoutData((Object)gd);
            this.databaseText = new Text(baseComposite, 0x804 | additionalStyles);
            gd = new GridData();
            gd.verticalAlignment = 1;
            gd.horizontalAlignment = 4;
            gd.horizontalSpan = 2;
            this.databaseText.setLayoutData((Object)gd);
            this.hostLabel = new Label(baseComposite, 0);
            this.hostLabel.setText(CUI_NEWCW_HOST_LBL_UI_);
            gd = new GridData();
            gd.verticalAlignment = 1;
            gd.horizontalSpan = 1;
            this.hostLabel.setLayoutData((Object)gd);
            this.hostText = new Text(baseComposite, 0x804 | additionalStyles);
            gd = new GridData();
            gd.horizontalAlignment = 4;
            gd.verticalAlignment = 1;
            gd.horizontalSpan = 2;
            gd.grabExcessHorizontalSpace = true;
            this.hostText.setLayoutData((Object)gd);
            this.portLabel = new Label(baseComposite, 0);
            this.portLabel.setText(CUI_NEWCW_PORT_LBL_UI_);
            gd = new GridData();
            gd.verticalAlignment = 1;
            gd.horizontalSpan = 1;
            this.portLabel.setLayoutData((Object)gd);
            this.portText = new Text(baseComposite, 0x804 | additionalStyles);
            gd = new GridData();
            gd.horizontalAlignment = 4;
            gd.verticalAlignment = 1;
            gd.grabExcessHorizontalSpace = true;
            gd.horizontalSpan = 2;
            this.portText.setLayoutData((Object)gd);
            this.usernameLabel = new Label(baseComposite, 0);
            this.usernameLabel.setText(CUI_NEWCW_USERNAME_LBL_UI_);
            gd = new GridData();
            gd.verticalAlignment = 1;
            this.usernameLabel.setLayoutData((Object)gd);
            this.usernameText = new Text(baseComposite, 0x804 | additionalStyles);
            gd = new GridData();
            gd.horizontalAlignment = 4;
            gd.verticalAlignment = 1;
            gd.grabExcessHorizontalSpace = true;
            gd.horizontalSpan = 2;
            this.usernameText.setLayoutData((Object)gd);
            this.passwordLabel = new Label(baseComposite, 0);
            this.passwordLabel.setText(CUI_NEWCW_PASSWORD_LBL_UI_);
            gd = new GridData();
            gd.verticalAlignment = 1;
            this.passwordLabel.setLayoutData((Object)gd);
            this.passwordText = new Text(baseComposite, 0x400804 | additionalStyles);
            gd = new GridData();
            gd.horizontalAlignment = 4;
            gd.verticalAlignment = 1;
            gd.grabExcessHorizontalSpace = true;
            gd.horizontalSpan = 2;
            this.passwordText.setLayoutData((Object)gd);
            this.savePasswordButton = new Button(baseComposite, 32);
            this.savePasswordButton.setText(CUI_NEWCW_SAVE_PASSWORD_LBL_UI_);
            gd = new GridData();
            gd.horizontalAlignment = 4;
            gd.verticalAlignment = 1;
            gd.horizontalSpan = 3;
            gd.grabExcessHorizontalSpace = true;
            this.savePasswordButton.setLayoutData((Object)gd);
            this.urlLabel = new Label(baseComposite, 0);
            this.urlLabel.setText(CUI_NEWCW_CONNECTIONURL_LBL_UI_);
            gd = new GridData();
            gd.verticalAlignment = 1;
            gd.horizontalSpan = 1;
            this.urlLabel.setLayoutData((Object)gd);
            this.urlText = new Text(baseComposite, 2634);
            gd = new GridData();
            gd.horizontalAlignment = 4;
            gd.verticalAlignment = 1;
            gd.grabExcessHorizontalSpace = true;
            gd.horizontalSpan = 2;
            gd.widthHint = 190;
            gd.heightHint = 50;
            this.urlText.setLayoutData((Object)gd);
            TabItem optionalPropsTab = new TabItem(tabComposite, 0);
            optionalPropsTab.setText(ConnectivityUIPlugin.getDefault().getResourceString("CommonDriverUIContributor.optionaltab"));
            this.optionalPropsComposite = this.createOptionalPropertiesPane((Composite)tabComposite, 0, isReadOnly);
            optionalPropsTab.setControl((Control)this.optionalPropsComposite);
            this.parentComposite.setContent((Control)tabComposite);
            this.parentComposite.setMinSize(tabComposite.computeSize(-1, -1));
            this.initialize();
        }
        return this.parentComposite;
    }

    public List getSummaryData() {
        ArrayList<String[]> summaryData = new ArrayList<String[]>();
        summaryData.add(new String[]{CUI_NEWCW_DATABASE_SUMMARY_DATA_TEXT_, this.databaseText.getText().trim()});
        summaryData.add(new String[]{CUI_NEWCW_HOST_SUMMARY_DATA_TEXT_, this.hostText.getText().trim()});
        summaryData.add(new String[]{CUI_NEWCW_PORT_SUMMARY_DATA_TEXT_, this.portText.getText().trim()});
        summaryData.add(new String[]{CUI_NEWCW_USERNAME_SUMMARY_DATA_TEXT_, this.usernameText.getText().trim()});
        summaryData.add(new String[]{CUI_NEWCW_SAVE_PASSWORD_SUMMARY_DATA_TEXT_, this.savePasswordButton.getSelection() ? CUI_NEWCW_TRUE_SUMMARY_DATA_TEXT_ : CUI_NEWCW_FALSE_SUMMARY_DATA_TEXT_});
        summaryData.add(new String[]{CUI_NEWCW_URL_SUMMARY_DATA_TEXT_, this.urlText.getText().trim()});
        return summaryData;
    }

    public void loadProperties() {
        String savePassword;
        String password;
        this.removeListeners();
        SqlServerJDBCURL url = this.getURLHandle(this.properties.getProperty("org.eclipse.datatools.connectivity.db.URL"));
        this.hostText.setText(url.getNode());
        this.portText.setText(url.getPort());
        this.databaseText.setText(url.getDatabaseName());
        String username = this.properties.getProperty("org.eclipse.datatools.connectivity.db.username");
        if (username != null) {
            this.usernameText.setText(username);
        }
        if ((password = this.properties.getProperty("org.eclipse.datatools.connectivity.db.password")) != null) {
            this.passwordText.setText(password);
        }
        if ((savePassword = this.properties.getProperty("org.eclipse.datatools.connectivity.db.savePWD")) != null && Boolean.valueOf(savePassword) == Boolean.TRUE) {
            this.savePasswordButton.setSelection(true);
        }
        this.optionalPropsComposite.loadProperties();
        this.updateURL();
        this.addListeners();
        this.setConnectionInformation();
    }

    public void setDialogPage(DialogPage parentPage) {
        this.parentPage = parentPage;
    }

    public void setDriverUIContributorInformation(IDriverUIContributorInformation contributorInformation) {
        this.contributorInformation = contributorInformation;
        this.properties = contributorInformation.getProperties();
        this.optionalPropsComposite.setDriverUIContributorInformation(contributorInformation);
    }

    public void handleEvent(Event event) {
        if (this.isReadOnly) {
            if (event.widget == this.savePasswordButton) {
                this.savePasswordButton.setSelection(!this.savePasswordButton.getSelection());
            }
        } else {
            this.updateURL();
            this.setConnectionInformation();
        }
    }

    private void setConnectionInformation() {
        this.properties.setProperty("org.eclipse.datatools.connectivity.db.databaseName", this.databaseText.getText().trim());
        this.properties.setProperty("org.eclipse.datatools.connectivity.db.password", this.passwordText.getText());
        this.properties.setProperty("org.eclipse.datatools.connectivity.db.savePWD", String.valueOf(this.savePasswordButton.getSelection()));
        this.properties.setProperty("org.eclipse.datatools.connectivity.db.username", this.usernameText.getText());
        this.properties.setProperty("org.eclipse.datatools.connectivity.db.URL", this.urlText.getText().trim());
        this.optionalPropsComposite.setConnectionInformation();
        this.contributorInformation.setProperties(this.properties);
    }

    private void initialize() {
        this.updateURL();
        this.addListeners();
    }

    private void addListeners() {
        this.databaseText.addListener(24, (Listener)this);
        this.hostText.addListener(24, (Listener)this);
        this.portText.addListener(24, (Listener)this);
        this.usernameText.addListener(24, (Listener)this);
        this.passwordText.addListener(24, (Listener)this);
        this.savePasswordButton.addListener(13, (Listener)this);
    }

    private void removeListeners() {
        this.databaseText.removeListener(24, (Listener)this);
        this.hostText.removeListener(24, (Listener)this);
        this.portText.removeListener(24, (Listener)this);
        this.usernameText.removeListener(24, (Listener)this);
        this.passwordText.removeListener(24, (Listener)this);
        this.savePasswordButton.removeListener(13, (Listener)this);
    }

    protected void updateURL() {
        String url = this.getURLHandle(this.hostText.getText().trim(), this.portText.getText().trim(), this.databaseText.getText().trim()).formatURL();
        this.urlText.setText(url);
    }

    protected OptionalPropertiesPane createOptionalPropertiesPane(Composite parent, int style, boolean useReadOnlyControls) {
        return new OptionalPropertiesPane(parent, style, useReadOnlyControls);
    }

    protected SqlServerJDBCURL getURLHandle(String url) {
        return new SqlServerJDBCURL(url);
    }

    protected SqlServerJDBCURL getURLHandle(String node, String port, String databaseName) {
        return new SqlServerJDBCURL(node, port, databaseName);
    }

    protected class SqlServerJDBCURL {
        protected String subprotocol = "";
        protected String node = "";
        protected String port = "";
        protected String databaseName = "";
        protected String urlProperties = "";

        public SqlServerJDBCURL(String url) {
            this.parseURL(url);
        }

        public SqlServerJDBCURL(String node, String port, String databaseName) {
            this.node = node;
            this.port = port;
            this.databaseName = databaseName;
        }

        public String getDatabaseName() {
            return this.databaseName;
        }

        public String getNode() {
            return this.node;
        }

        public String getSubprotocol() {
            return this.subprotocol;
        }

        public String getPort() {
            return this.port;
        }

        public String getProperties() {
            return this.urlProperties;
        }

        protected String formatURL() {
            String url = "jdbc:microsoft:sqlserver://" + this.getNode() + ":" + this.getPort() + ";databaseName=" + this.getDatabaseName();
            return url;
        }

        protected void parseURL(String url) {
            try {
                String remainingURL = url.substring(url.indexOf(58) + 1);
                this.subprotocol = remainingURL.substring(0, remainingURL.indexOf(58));
                remainingURL = remainingURL.substring(remainingURL.indexOf(58) + 1);
                this.subprotocol = String.valueOf(this.subprotocol) + remainingURL.substring(0, remainingURL.indexOf(58));
                remainingURL = remainingURL.substring(remainingURL.indexOf(58) + 3);
                this.node = remainingURL.substring(0, remainingURL.indexOf(59));
                if (this.node.indexOf(58) > -1) {
                    this.port = this.node.substring(this.node.indexOf(58) + 1);
                    this.node = this.node.substring(0, this.node.indexOf(58));
                }
                if ((remainingURL = remainingURL.substring(remainingURL.indexOf(59) + 1)).indexOf(59) > -1) {
                    this.databaseName = remainingURL.substring(0, remainingURL.indexOf(59));
                    this.databaseName = this.databaseName.substring(new String("databaseName=").length());
                    this.urlProperties = remainingURL = remainingURL.substring(remainingURL.indexOf(59) + 1);
                } else {
                    this.databaseName = remainingURL.substring(new String("databaseName=").length());
                }
            }
            catch (Exception exception) {}
        }
    }
}

