/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.datatools.sqltools.debugger.model;

import org.eclipse.datatools.sqltools.debugger.core.internal.DebuggerMessages;
import org.eclipse.datatools.sqltools.debugger.model.SPDebugElement;
import org.eclipse.datatools.sqltools.debugger.model.SPDebugTarget;
import org.eclipse.datatools.sqltools.debugger.model.SPValue;
import org.eclipse.debug.core.DebugException;
import org.eclipse.debug.core.model.IValue;
import org.eclipse.debug.core.model.IVariable;

public abstract class SPVariable
extends SPDebugElement
implements IVariable {
    SPValue _spValue;
    String _variableName;
    int _lastChangeIndex = -1;

    public SPVariable(SPDebugTarget target, String name) {
        super(target);
        this._variableName = name;
    }

    public IValue getValue() throws DebugException {
        return this._spValue;
    }

    public String getName() throws DebugException {
        return this._variableName;
    }

    public String getReferenceTypeName() throws DebugException {
        SPValue v = (SPValue)this.getValue();
        if (v != null) {
            return v.getReferenceTypeName();
        }
        return DebuggerMessages.SPVariable_unknown;
    }

    public boolean hasValueChanged() throws DebugException {
        return this._lastChangeIndex == this.getSPDebugTarget().getSuspendCount();
    }

    public void internalSetValue(SPValue v) {
        if (!this.equals(this._spValue, v)) {
            this._lastChangeIndex = this.getSPDebugTarget().getSuspendCount();
        }
        this._spValue = v;
    }

    private boolean equals(SPValue v1, SPValue v2) {
        if (v1 == null) {
            return v2 == null;
        }
        return v1.equals((Object)v2);
    }

    public abstract boolean isGlobal();
}

