/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.datatools.connectivity.internal.ui.dialogs;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.eclipse.datatools.connectivity.drivers.DriverInstance;
import org.eclipse.datatools.connectivity.drivers.DriverManager;
import org.eclipse.datatools.connectivity.drivers.IPropertySet;
import org.eclipse.datatools.connectivity.drivers.models.CategoryDescriptor;
import org.eclipse.datatools.connectivity.drivers.models.TemplateDescriptor;
import org.eclipse.datatools.connectivity.internal.ui.dialogs.CategoryRoot;
import org.eclipse.jface.viewers.ITreeContentProvider;
import org.eclipse.jface.viewers.Viewer;

public class DriverTreeTableContentProvider
implements ITreeContentProvider {
    public Object[] getChildren(Object parentElement) {
        if (parentElement instanceof CategoryRoot) {
            return CategoryDescriptor.getRootCategories();
        }
        if (parentElement instanceof CategoryDescriptor) {
            CategoryDescriptor cd = (CategoryDescriptor)parentElement;
            ArrayList templateList = new ArrayList();
            this.gatherTemplates(cd, templateList);
            return templateList.toArray();
        }
        return new Object[0];
    }

    public Object getParent(Object element) {
        if (element instanceof CategoryDescriptor) {
            return ((CategoryDescriptor)element).getParent();
        }
        if (element instanceof TemplateDescriptor) {
            return ((TemplateDescriptor)element).getParent();
        }
        return null;
    }

    public boolean hasChildren(Object element) {
        return this.getChildren(element).length > 0;
    }

    public Object[] getElements(Object inputElement) {
        return this.getChildren(inputElement);
    }

    public void dispose() {
    }

    public void inputChanged(Viewer viewer, Object oldInput, Object newInput) {
    }

    private void gatherTemplates(CategoryDescriptor cd, List totalList) {
        if (cd.getAssociatedDriverTypes().size() > 0) {
            totalList.addAll(cd.getAssociatedDriverTypes());
        }
        if (cd.getChildCategories().size() > 0) {
            Iterator iter = cd.getChildCategories().iterator();
            while (iter.hasNext()) {
                this.gatherTemplates((CategoryDescriptor)iter.next(), totalList);
            }
        }
    }

    public List getDriverInstances() {
        DriverInstance[] dinstances = DriverManager.getInstance().getAllDriverInstances();
        ArrayList<IPropertySet> list = new ArrayList<IPropertySet>();
        int i = 0;
        while (i < dinstances.length) {
            list.add(dinstances[i].getPropertySet());
            ++i;
        }
        return list;
    }
}

