/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.datatools.connectivity.db.generic.ui;

import java.util.Properties;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import org.eclipse.datatools.connectivity.IConnectionProfile;
import org.eclipse.datatools.connectivity.db.generic.GenericDBPlugin;
import org.eclipse.datatools.connectivity.db.generic.ui.GenericDBUIPlugin;
import org.eclipse.datatools.connectivity.drivers.DriverInstance;
import org.eclipse.datatools.connectivity.internal.ui.DelimitedStringList;
import org.eclipse.datatools.connectivity.internal.ui.DriverListCombo;
import org.eclipse.datatools.connectivity.ui.wizards.ProfileDetailsPropertyPage;
import org.eclipse.datatools.help.ContextProviderDelegate;
import org.eclipse.datatools.help.HelpUtil;
import org.eclipse.help.IContext;
import org.eclipse.help.IContextProvider;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Text;

public class GenericDBProfilePropertyPage
extends ProfileDetailsPropertyPage
implements IContextProvider {
    private static final String EMPTY_STRING = new String();
    private Text mDatabaseNameText;
    private Text mDBUIDText;
    private Text mDBPWDText;
    private Text mURLText;
    private Button mSaveDBPWDCheckbox;
    final DriverListCombo combo = new DriverListCombo();
    private DelimitedStringList mDBConnProps;
    private DriverInstance mDriverInstance;
    private String mDriverCategory;
    private ContextProviderDelegate contextProviderDelegate = new ContextProviderDelegate(GenericDBUIPlugin.getDefault().getBundle().getSymbolicName());

    public GenericDBProfilePropertyPage() {
        this.noDefaultAndApplyButton();
        this.setDriverCategory("org.eclipse.datatools.connectivity.db.driverCategory");
    }

    protected void createCustomContents(Composite parent) {
        Composite content = new Composite(parent, 0);
        GridLayout layout = new GridLayout(2, false);
        content.setLayout((Layout)layout);
        this.combo.setLabelText(GenericDBPlugin.getDefault().getResourceString("GenericDBProfileDetailsWizardPage.driverCombo.label"));
        this.combo.setCategory(this.getDriverCategory());
        this.combo.setNullDriverIsValid(false);
        this.combo.createContents(content);
        this.mDatabaseNameText = (Text)this.createLabelTextPair(content, GenericDBPlugin.getDefault().getResourceString("GenericDBProfileDetailsWizardPage.databaseName.label"), (Control)this.mURLText, 2048, 768);
        this.mURLText = (Text)this.createLabelTextPair(content, GenericDBPlugin.getDefault().getResourceString("GenericDBProfileDetailsWizardPage.url.label"), (Control)this.mURLText, 2048, 768);
        this.mDBUIDText = (Text)this.createLabelTextPair(content, GenericDBPlugin.getDefault().getResourceString("GenericDBProfileDetailsWizardPage.userName.label"), (Control)this.mDBUIDText, 2048, 768);
        this.mDBPWDText = (Text)this.createLabelTextPair(content, GenericDBPlugin.getDefault().getResourceString("GenericDBProfileDetailsWizardPage.password.label"), (Control)this.mDBPWDText, 0x400800, 768);
        this.mSaveDBPWDCheckbox = new Button(content, 32);
        this.mSaveDBPWDCheckbox.setText(GenericDBPlugin.getDefault().getResourceString("GenericDBProfileDetailsWizardPage.persistpassword.label"));
        this.mSaveDBPWDCheckbox.setLayoutData((Object)new GridData(1, 2, true, false, 2, 1));
        Composite spacer = new Composite(content, 0);
        GridData gdata = new GridData(768);
        gdata.horizontalSpan = 2;
        gdata.heightHint = 20;
        spacer.setLayoutData((Object)gdata);
        Label label = new Label(content, 0);
        gdata = new GridData(768);
        gdata.horizontalSpan = 2;
        label.setLayoutData((Object)gdata);
        label.setText(GenericDBPlugin.getDefault().getResourceString("GenericDBProfileDetailsWizardPage.optionalProps.label"));
        this.mDBConnProps = new DelimitedStringList(content, 0);
        gdata = new GridData(768);
        gdata.horizontalSpan = 2;
        this.mDBConnProps.setLayoutData((Object)gdata);
        this.mDBConnProps.addChangeListener(new ChangeListener(){

            public void stateChanged(ChangeEvent arg0) {
                GenericDBProfilePropertyPage.this.setErrorMessage(null);
                if (GenericDBProfilePropertyPage.this.mDBConnProps.getWarning() != null) {
                    GenericDBProfilePropertyPage.this.setErrorMessage(GenericDBProfilePropertyPage.this.mDBConnProps.getWarning());
                }
            }
        });
        this.combo.addChangeListener(new ChangeListener(){

            public void stateChanged(ChangeEvent arg0) {
                String oldPassword;
                String password;
                String oldUsername;
                GenericDBProfilePropertyPage.this.mDriverInstance = GenericDBProfilePropertyPage.this.combo.getSelectedDriverInstance();
                GenericDBProfilePropertyPage.this.setErrorMessage(null);
                if (GenericDBProfilePropertyPage.this.combo.getErrorMessage() != null) {
                    GenericDBProfilePropertyPage.this.setErrorMessage(GenericDBProfilePropertyPage.this.combo.getErrorMessage());
                } else {
                    GenericDBProfilePropertyPage.this.mURLText.setText(GenericDBProfilePropertyPage.this.getDriverURL());
                }
                String username = GenericDBProfilePropertyPage.this.getPropertyFromDriverInstance("org.eclipse.datatools.connectivity.db.username");
                if (username == null || username.trim().length() == 0) {
                    username = new String();
                }
                if ((oldUsername = GenericDBProfilePropertyPage.this.mDBUIDText.getText()) == null || oldUsername.trim().length() == 0) {
                    oldUsername = new String();
                }
                if (oldUsername.length() == 0) {
                    GenericDBProfilePropertyPage.this.mDBUIDText.setText(username);
                }
                if ((password = GenericDBProfilePropertyPage.this.getPropertyFromDriverInstance("org.eclipse.datatools.connectivity.db.password")) == null || password.trim().length() == 0) {
                    password = new String();
                }
                if ((oldPassword = GenericDBProfilePropertyPage.this.mDBPWDText.getText()) == null || oldPassword.trim().length() == 0) {
                    oldPassword = new String();
                }
                if (oldPassword.length() == 0) {
                    GenericDBProfilePropertyPage.this.mDBPWDText.setText(password);
                }
            }
        });
        this.initControls();
    }

    protected Properties collectProperties() {
        Properties props = new Properties();
        String driverID = EMPTY_STRING;
        if (this.combo.getSelectedDriverInstance() != null) {
            DriverInstance instance = this.combo.getSelectedDriverInstance();
            driverID = instance.getId();
        }
        props.setProperty("org.eclipse.datatools.connectivity.driverDefinitionID", driverID);
        props.setProperty("org.eclipse.datatools.connectivity.db.connectionProperties", this.mDBConnProps.getSelection());
        props.setProperty("org.eclipse.datatools.connectivity.db.vendor", this.getPropertyFromDriverInstance("org.eclipse.datatools.connectivity.db.vendor"));
        props.setProperty("org.eclipse.datatools.connectivity.db.version", this.getPropertyFromDriverInstance("org.eclipse.datatools.connectivity.db.version"));
        props.setProperty("org.eclipse.datatools.connectivity.db.driverClass", this.getPropertyFromDriverInstance("org.eclipse.datatools.connectivity.db.driverClass"));
        props.setProperty("org.eclipse.datatools.connectivity.db.databaseName", this.mDatabaseNameText.getText());
        props.setProperty("org.eclipse.datatools.connectivity.db.password", this.mDBPWDText.getText());
        props.setProperty("org.eclipse.datatools.connectivity.db.username", this.mDBUIDText.getText());
        props.setProperty("org.eclipse.datatools.connectivity.db.URL", this.mURLText.getText());
        props.setProperty("org.eclipse.datatools.connectivity.db.savePWD", String.valueOf(this.mSaveDBPWDCheckbox.getSelection()));
        return props;
    }

    private void initControls() {
        String urlText;
        String databaseUid;
        String databasePwd;
        String databaseName;
        String connectionProps;
        IConnectionProfile profile = this.getConnectionProfile();
        String driverID = profile.getBaseProperties().getProperty("org.eclipse.datatools.connectivity.driverDefinitionID");
        if (driverID != null) {
            this.combo.setSelectionToID(driverID);
        }
        if ((connectionProps = profile.getBaseProperties().getProperty("org.eclipse.datatools.connectivity.db.connectionProperties")) != null) {
            this.mDBConnProps.setSelection(connectionProps);
        }
        if ((databaseName = profile.getBaseProperties().getProperty("org.eclipse.datatools.connectivity.db.databaseName")) != null) {
            this.mDatabaseNameText.setText(databaseName);
        }
        if ((databasePwd = profile.getBaseProperties().getProperty("org.eclipse.datatools.connectivity.db.password")) != null) {
            this.mDBPWDText.setText(databasePwd);
        }
        if ((databaseUid = profile.getBaseProperties().getProperty("org.eclipse.datatools.connectivity.db.username")) != null) {
            this.mDBUIDText.setText(databaseUid);
        }
        if ((urlText = profile.getBaseProperties().getProperty("org.eclipse.datatools.connectivity.db.URL")) != null) {
            this.mURLText.setText(urlText);
        }
        this.mSaveDBPWDCheckbox.setSelection(Boolean.valueOf(profile.getBaseProperties().getProperty("org.eclipse.datatools.connectivity.db.savePWD", Boolean.FALSE.toString())).booleanValue());
        this.setErrorMessage(null);
        if (this.combo.getErrorMessage() != null) {
            this.setErrorMessage(this.combo.getErrorMessage());
        }
    }

    private String getPropertyFromDriverInstance(String propertyID) {
        String returnStr = new String();
        if (this.mDriverInstance != null && this.mDriverInstance.getProperty(propertyID) != null) {
            returnStr = this.mDriverInstance.getProperty(propertyID);
        }
        return returnStr;
    }

    private Control createLabelTextPair(Composite parent, String labelText, Control ctl, int style, int gData) {
        Label label = new Label(parent, 0);
        label.setLayoutData((Object)new GridData());
        label.setText(labelText);
        ctl = new Text(parent, style);
        ctl.setLayoutData((Object)new GridData(gData));
        return ctl;
    }

    public String getDriverURL() {
        return this.mDriverInstance.getProperty("org.eclipse.datatools.connectivity.db.URL");
    }

    public boolean isValid() {
        if (this.getErrorMessage() != null) {
            return false;
        }
        return super.isValid();
    }

    public void setErrorMessage(String newMessage) {
        super.setErrorMessage(newMessage);
        this.isValid();
    }

    public String getDriverCategory() {
        return this.mDriverCategory;
    }

    public void setDriverCategory(String driverCategory) {
        this.mDriverCategory = driverCategory;
        if (this.combo != null) {
            this.combo.setCategory(this.mDriverCategory);
        }
    }

    public IContext getContext(Object target) {
        return this.contextProviderDelegate.getContext(target);
    }

    public int getContextChangeMask() {
        return this.contextProviderDelegate.getContextChangeMask();
    }

    public String getSearchExpression(Object target) {
        return this.contextProviderDelegate.getSearchExpression(target);
    }

    protected Control createContents(Composite parent) {
        Control contents = super.createContents(parent);
        this.getShell().setData(HelpUtil.CONTEXT_PROVIDER_KEY, (Object)this);
        HelpUtil.setHelp((Control)this.getControl(), (String)HelpUtil.getContextId((String)"GENERIC_DB_PROFILE_WIZARD_PAGE", (String)GenericDBUIPlugin.getDefault().getBundle().getSymbolicName()));
        return contents;
    }

    public void dispose() {
        this.combo.dispose();
        super.dispose();
    }
}

