/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.datatools.enablement.ingres.internal.loaders;

import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.Collection;
import java.util.List;
import org.eclipse.datatools.connectivity.sqm.core.rte.ICatalogObject;
import org.eclipse.datatools.connectivity.sqm.loader.IConnectionFilterProvider;
import org.eclipse.datatools.connectivity.sqm.loader.JDBCTableConstraintLoader;
import org.eclipse.datatools.enablement.ingres.internal.catalog.IngresCatalogCheckConstraint;
import org.eclipse.datatools.enablement.ingres.internal.loaders.LoaderHelper;
import org.eclipse.datatools.modelbase.sql.constraints.CheckConstraint;

public class IngresTableConstraintLoader
extends JDBCTableConstraintLoader {
    public IngresTableConstraintLoader() {
        super(null);
    }

    public IngresTableConstraintLoader(ICatalogObject catalogObject) {
        super(catalogObject);
    }

    public IngresTableConstraintLoader(ICatalogObject catalogObject, IConnectionFilterProvider connectionFilterProvider) {
        super(catalogObject, connectionFilterProvider);
    }

    protected ResultSet createUniqueConstraintResultSet() throws SQLException {
        try {
            Connection con = this.getCatalogObject().getConnection();
            PreparedStatement stmt = con.prepareStatement("SELECT DISTINCT trim(c.constraint_name) AS PK_NAME, trim(k.column_name) AS PKCOLUMN_NAME, k.key_position AS KEY_SEQ FROM iiconstraints c, iikeys k WHERE k.constraint_name = c.constraint_name AND c.schema_name = ? AND c.table_name = ? AND c.constraint_type = 'U' AND k.schema_name = ? AND k.table_name = ?");
            String schemaName = this.getTable().getSchema().getName();
            String tableName = this.getTable().getName();
            stmt.setString(1, schemaName);
            stmt.setString(2, tableName);
            stmt.setString(3, schemaName);
            stmt.setString(4, tableName);
            return stmt.executeQuery();
        }
        catch (RuntimeException e) {
            SQLException error = new SQLException("Error while retrieving catalog information (unique constraints)");
            error.initCause(e);
            throw error;
        }
    }

    public void loadCheckConstraints(List containmentList, Collection existingCCs) throws SQLException {
        PreparedStatement stmt = this.getCatalogObject().getConnection().prepareStatement("SELECT DISTINCT\ttrim(c.constraint_name) AS CC_NAME FROM\tiiconstraints c WHERE c.schema_name = ? AND\tc.table_name = ? AND c.constraint_type = 'C'");
        String schemaName = this.getTable().getSchema().getName();
        String tableName = this.getTable().getName();
        stmt.setString(1, schemaName);
        stmt.setString(2, tableName);
        ResultSet rst = stmt.executeQuery();
        while (rst.next()) {
            String ccName = rst.getString("CC_NAME");
            Object cc = (CheckConstraint)this.getAndRemoveSQLObject(existingCCs, ccName);
            if (cc == null) {
                cc = new IngresCatalogCheckConstraint();
                cc.setName(ccName);
            }
            containmentList.add(cc);
        }
        LoaderHelper.close(rst);
        LoaderHelper.close(stmt);
    }

    protected void closeResultSet(ResultSet rs) {
        LoaderHelper.close(rs);
        try {
            LoaderHelper.close(rs.getStatement());
        }
        catch (SQLException sQLException) {}
    }
}

