/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.datatools.enablement.oda.ecore.impl;

import java.math.BigDecimal;
import java.sql.Date;
import java.sql.Time;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.NoSuchElementException;
import java.util.Set;
import org.eclipse.datatools.connectivity.oda.IBlob;
import org.eclipse.datatools.connectivity.oda.IClob;
import org.eclipse.datatools.connectivity.oda.IResultSet;
import org.eclipse.datatools.connectivity.oda.IResultSetMetaData;
import org.eclipse.datatools.connectivity.oda.OdaException;
import org.eclipse.datatools.connectivity.oda.design.ColumnDefinition;
import org.eclipse.datatools.enablement.oda.ecore.i18n.Messages;
import org.eclipse.datatools.enablement.oda.ecore.impl.ColumnDefinitionUtil;
import org.eclipse.datatools.enablement.oda.ecore.impl.Query;
import org.eclipse.datatools.enablement.oda.ecore.util.StringUtil;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EStructuralFeature;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ResultSet
implements IResultSet {
    private static final String AGGREGATION_SEPARATOR = "\n";
    private int maxRows;
    private int currentRowId;
    private EObject eObject;
    private final ColumnDefinition[] columns;
    private boolean wasNull;
    private boolean isClosed;
    private final Iterator<EObject> queryResultIterator;
    private final Query query;

    public ResultSet(Query query, ColumnDefinition[] columns, int maxRows) {
        this.query = query;
        this.columns = columns;
        this.maxRows = maxRows;
        this.queryResultIterator = query.getQueryResult().iterator();
    }

    public IResultSetMetaData getMetaData() throws OdaException {
        this.verifyNotClosed();
        return this.query.getMetaData();
    }

    public void setMaxRows(int maxRows) throws OdaException {
        this.maxRows = maxRows;
    }

    protected int getMaxRows() {
        return this.maxRows;
    }

    public boolean next() throws OdaException {
        this.verifyNotClosed();
        boolean isSuccessful = false;
        if (this.maxRows > 0 && this.currentRowId <= this.maxRows || this.maxRows == 0) {
            try {
                this.eObject = this.queryResultIterator.next();
                ++this.currentRowId;
                isSuccessful = true;
            }
            catch (NoSuchElementException noSuchElementException) {
                isSuccessful = false;
            }
        }
        return isSuccessful;
    }

    private void verifyInScope() throws OdaException {
        if (this.eObject == null) {
            throw new OdaException("No row is in scope. Try calling next()?");
        }
    }

    private void verifyNotClosed() throws OdaException {
        if (this.isClosed) {
            throw new OdaException(Messages.resultSet_alreadyClosed);
        }
    }

    private void validateColumn(int index) throws OdaException {
        try {
            ColumnDefinition cfr_ignored_0 = this.columns[index - 1];
        }
        catch (IndexOutOfBoundsException indexOutOfBoundsException) {
            this.wasNull = true;
            throw new OdaException("No corresponding column for index");
        }
    }

    public void close() throws OdaException {
        this.query.close();
        this.isClosed = true;
    }

    public int getRow() throws OdaException {
        return this.currentRowId;
    }

    public String getString(int index) throws OdaException {
        this.validateColumn(index);
        return this.getFeatureValues(Collections.singleton(this.eObject), ColumnDefinitionUtil.featuresForColumn(this.eObject, this.columns[index - 1]));
    }

    private String getFeatureValues(Collection<EObject> eObjects, EStructuralFeature[] path) {
        if (path.length == 0) {
            return "";
        }
        EStructuralFeature feature = path[0];
        ArrayList<String> values = new ArrayList<String>();
        for (EObject eObject : eObjects) {
            Object value = eObject.eGet(feature);
            if (value == null) continue;
            if (path.length == 1) {
                values.add(value.toString());
                continue;
            }
            EStructuralFeature[] nextPath = new EStructuralFeature[path.length - 1];
            System.arraycopy(path, 1, nextPath, 0, nextPath.length);
            String featureValues = this.getFeatureValues(feature.isMany() ? (Set<EObject>)value : Collections.singleton((EObject)value), nextPath);
            if (featureValues.length() <= 0) continue;
            values.add(featureValues);
        }
        return StringUtil.join(values.toArray(new String[values.size()]), AGGREGATION_SEPARATOR);
    }

    public String getString(String columnName) throws OdaException {
        return this.getString(this.findColumn(columnName));
    }

    public int getInt(int index) throws OdaException {
        this.validateColumn(index);
        return Integer.parseInt(this.getFeatureValues(Collections.singleton(this.eObject), ColumnDefinitionUtil.featuresForColumn(this.eObject, this.columns[index - 1])));
    }

    public int getInt(String columnName) throws OdaException {
        return this.getInt(this.findColumn(columnName));
    }

    public double getDouble(int index) throws OdaException {
        this.validateColumn(index);
        return Double.parseDouble(this.getFeatureValues(Collections.singleton(this.eObject), ColumnDefinitionUtil.featuresForColumn(this.eObject, this.columns[index - 1])));
    }

    public double getDouble(String columnName) throws OdaException {
        return this.getDouble(this.findColumn(columnName));
    }

    public BigDecimal getBigDecimal(int index) throws OdaException {
        throw new UnsupportedOperationException();
    }

    public BigDecimal getBigDecimal(String columnName) throws OdaException {
        return this.getBigDecimal(this.findColumn(columnName));
    }

    public Date getDate(int index) throws OdaException {
        throw new UnsupportedOperationException();
    }

    public Date getDate(String columnName) throws OdaException {
        return this.getDate(this.findColumn(columnName));
    }

    public Time getTime(int index) throws OdaException {
        throw new UnsupportedOperationException();
    }

    public Time getTime(String columnName) throws OdaException {
        return this.getTime(this.findColumn(columnName));
    }

    public Timestamp getTimestamp(int index) throws OdaException {
        throw new UnsupportedOperationException();
    }

    public Timestamp getTimestamp(String columnName) throws OdaException {
        return this.getTimestamp(this.findColumn(columnName));
    }

    public IBlob getBlob(int index) throws OdaException {
        throw new UnsupportedOperationException();
    }

    public IBlob getBlob(String columnName) throws OdaException {
        return this.getBlob(this.findColumn(columnName));
    }

    public IClob getClob(int index) throws OdaException {
        throw new UnsupportedOperationException();
    }

    public IClob getClob(String columnName) throws OdaException {
        return this.getClob(this.findColumn(columnName));
    }

    public boolean getBoolean(int index) throws OdaException {
        this.validateColumn(index);
        return Boolean.parseBoolean(this.getFeatureValues(Collections.singleton(this.eObject), ColumnDefinitionUtil.featuresForColumn(this.eObject, this.columns[index - 1])));
    }

    public boolean getBoolean(String columnName) throws OdaException {
        return this.getBoolean(this.findColumn(columnName));
    }

    public Object getObject(int index) throws OdaException {
        throw new UnsupportedOperationException();
    }

    public Object getObject(String columnName) throws OdaException {
        throw new UnsupportedOperationException();
    }

    public boolean wasNull() throws OdaException {
        return this.wasNull;
    }

    public int findColumn(String columnName) throws OdaException {
        this.verifyInScope();
        int i = 0;
        while (i < this.columns.length) {
            ColumnDefinition column = this.columns[i];
            if (column.getAttributes().getName().equals(columnName)) {
                return i + 1;
            }
            ++i;
        }
        throw new OdaException("No column matches name");
    }
}

