/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.datatools.enablement.ase.catalog;

import java.sql.Connection;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.core.runtime.Platform;
import org.eclipse.datatools.connectivity.sqm.core.rte.ICatalogObject;
import org.eclipse.datatools.connectivity.sqm.core.rte.RefreshManager;
import org.eclipse.datatools.enablement.ase.catalog.SybaseASECatalog;
import org.eclipse.datatools.enablement.ase.catalog.SybaseASECatalogUtils;
import org.eclipse.datatools.enablement.ase.ddl.SybaseASEDdlParser;
import org.eclipse.datatools.enablement.sybase.ase.models.sybaseasesqlmodel.impl.SybaseASEDefaultImpl;
import org.eclipse.datatools.modelbase.sql.schema.Database;
import org.eclipse.datatools.modelbase.sql.schema.SQLObject;
import org.eclipse.emf.ecore.EStructuralFeature;

public class SybaseASECatalogDefault
extends SybaseASEDefaultImpl
implements ICatalogObject,
IAdaptable {
    private static final long serialVersionUID = -5390495800838342279L;
    private Boolean isStatementLoaded = Boolean.FALSE;

    public Database getCatalogDatabase() {
        return this.getSchema().getCatalog().getDatabase();
    }

    public Connection getConnection() {
        SybaseASECatalog catalog = (SybaseASECatalog)this.getSchema().getCatalog();
        return catalog.getConnection();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void refresh() {
        if (this.isNeedRefresh()) {
            Boolean bl = this.isStatementLoaded;
            synchronized (bl) {
                this.isStatementLoaded = Boolean.FALSE;
            }
            RefreshManager.getInstance().referesh((ICatalogObject)this);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String getStatement() {
        Boolean bl = this.isStatementLoaded;
        synchronized (bl) {
            if (!this.isStatementLoaded.booleanValue()) {
                this.loadDefaultStatement();
            }
        }
        return super.getStatement();
    }

    public boolean eIsSet(EStructuralFeature eFeature) {
        int id = this.eDerivedStructuralFeatureID(eFeature);
        if (id == 9) {
            this.getStatement();
        }
        return super.eIsSet(eFeature);
    }

    private void loadDefaultStatement() {
        if (this.isStatementLoaded.booleanValue()) {
            return;
        }
        Connection connection = this.getConnection();
        boolean deliver = this.eDeliver();
        this.eSetDeliver(false);
        String text = SybaseASECatalogUtils.getCompiledObjectText((SQLObject)this, connection, this.getCatalogName());
        this.setStatement(new SybaseASEDdlParser().parseDefaultRuleStatement(text));
        this.eSetDeliver(deliver);
        this.isStatementLoaded = Boolean.TRUE;
    }

    private String getCatalogName() {
        return this.getSchema().getCatalog().getName();
    }

    public Object getAdapter(Class adapter) {
        Object adapterObject = Platform.getAdapterManager().getAdapter((Object)this, adapter);
        if (adapterObject == null) {
            adapterObject = Platform.getAdapterManager().loadAdapter((Object)this, adapter.getName());
        }
        return adapterObject;
    }

    private boolean isNeedRefresh() {
        return this.isStatementLoaded;
    }
}

