/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.datatools.connectivity.oda.util.manifest;

import java.io.IOException;
import java.net.MalformedURLException;
import java.net.URI;
import java.net.URL;
import java.security.ProtectionDomain;
import java.util.Enumeration;
import java.util.Map;
import java.util.logging.Level;
import org.eclipse.core.runtime.FileLocator;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.Platform;
import org.eclipse.datatools.connectivity.oda.nls.Messages;
import org.eclipse.datatools.connectivity.oda.util.ResourceIdentifiers;
import org.eclipse.datatools.connectivity.oda.util.manifest.ManifestExplorer;
import org.eclipse.datatools.connectivity.oda.util.manifest.RuntimeInterface;
import org.osgi.framework.Bundle;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class JavaRuntimeInterface
extends RuntimeInterface {
    private String m_driverClass;
    private boolean m_needSetThreadContextClassLoader;
    private String m_namespace;
    private IPath m_loadedBundlePath;
    private static final String sm_className = JavaRuntimeInterface.class.getName();
    private static final String PLUGIN_ROOT_PATH = "/";
    private static final String PLUGIN_VERSION_SEPARATOR = "_";
    private static final String BUNDLE_MANIFEST_RELATIVE_PATH = "META-INF/MANIFEST.MF";
    private static final String UPPER_RELATIVE_PATH = "..";

    JavaRuntimeInterface(String driverClass, boolean needSetThreadContextClassLoader, String namespace) {
        this.m_driverClass = driverClass;
        this.m_needSetThreadContextClassLoader = needSetThreadContextClassLoader;
        this.m_namespace = namespace;
    }

    @Override
    public int getInterfaceType() {
        return 1;
    }

    public String getDriverClass() {
        return this.m_driverClass;
    }

    public boolean needSetThreadContextClassLoader() {
        return this.m_needSetThreadContextClassLoader;
    }

    @Override
    public URL getLibraryLocation() throws IOException {
        return this.getLocation(PLUGIN_ROOT_PATH);
    }

    @Override
    public URL getDriverFileLocation(String filename) throws IOException {
        return this.getLocation(filename);
    }

    private URL getLocation(String entry) throws IOException {
        Bundle bundle = Platform.getBundle((String)this.m_namespace);
        if (bundle != null) {
            URL url = bundle.getEntry(entry);
            return FileLocator.toFileURL((URL)url);
        }
        if (this.m_loadedBundlePath == null) {
            throw new IOException(Messages.bind((String)Messages.manifest_UNKNOWN_BUNDLE_LOCATION, (Object)this.m_namespace));
        }
        IPath entryPath = entry.equals(PLUGIN_ROOT_PATH) ? this.m_loadedBundlePath : this.m_loadedBundlePath.append(entry);
        return entryPath.toFile().toURI().toURL();
    }

    @Override
    public String[] getLibraries() {
        throw new UnsupportedOperationException();
    }

    public void setLoadedClassLocation(Class<?> driverClass, Object appContext) {
        ResourceIdentifiers resourceIdentifiers;
        this.m_loadedBundlePath = null;
        if (appContext instanceof Map && (resourceIdentifiers = ResourceIdentifiers.get(appContext)) != null) {
            URI driverPathUri = resourceIdentifiers.resolveResourceLocation(this.m_namespace);
            this.m_loadedBundlePath = JavaRuntimeInterface.convertToExistingFilePath(driverPathUri);
        }
        if (this.m_loadedBundlePath == null) {
            this.m_loadedBundlePath = JavaRuntimeInterface.getLoadedBundlePath(this.m_namespace, driverClass.getClassLoader());
        }
        if (this.m_loadedBundlePath == null) {
            this.m_loadedBundlePath = JavaRuntimeInterface.getDomainBundlePath(this.m_namespace, driverClass);
        }
    }

    private static IPath convertToExistingFilePath(URI pathUri) {
        if (pathUri == null) {
            return null;
        }
        try {
            URL pathURL = pathUri.toURL();
            Path filePath = new Path(pathURL.getPath());
            if (filePath.toFile().exists()) {
                return filePath;
            }
        }
        catch (Exception ex) {
            ManifestExplorer.getLogger().logp(Level.FINE, sm_className, "convertToExistingFilePath(URI)", Messages.bind((String)"The specified URI ({0}) is not a valid file path.", (Object)pathUri), ex);
        }
        return null;
    }

    private static IPath getLoadedBundlePath(String bundleName, ClassLoader cl) {
        Enumeration<URL> foundURLs;
        try {
            foundURLs = cl.getResources(BUNDLE_MANIFEST_RELATIVE_PATH);
        }
        catch (IOException ex) {
            ManifestExplorer.getLogger().logp(Level.FINE, sm_className, "getLoadedBundlePath(String,ClassLoader)", Messages.bind((String)"Unable to locate the installation path of the specified bundle ({0}).", (Object)bundleName), ex);
            return null;
        }
        String pluginNameFragment = String.valueOf(bundleName) + PLUGIN_VERSION_SEPARATOR;
        while (foundURLs.hasMoreElements()) {
            URL manifestURL = foundURLs.nextElement();
            if (!manifestURL.getPath().contains(pluginNameFragment)) continue;
            try {
                URL pluginLocURL = new URL(manifestURL, UPPER_RELATIVE_PATH);
                return new Path(pluginLocURL.getPath());
            }
            catch (MalformedURLException ex) {
                ManifestExplorer.getLogger().logp(Level.FINE, sm_className, "getLoadedBundlePath(String,ClassLoader)", Messages.bind((String)"Unable to resolve the installation path ({0}/{1}) of the specified bundle ({2}).", (Object[])new Object[]{manifestURL, UPPER_RELATIVE_PATH, bundleName}), ex);
                return null;
            }
        }
        return null;
    }

    private static IPath getDomainBundlePath(String bundleName, Class<?> clazz) {
        URL classFileLocation;
        block7: {
            if (clazz == null) {
                return null;
            }
            ProtectionDomain protectionDomain = clazz.getProtectionDomain();
            classFileLocation = protectionDomain.getCodeSource().getLocation();
            if (classFileLocation != null) break block7;
            return null;
        }
        try {
            IPath bundleRoot;
            Path classPath = new Path(classFileLocation.getPath());
            int bundleSegmentIndex = -1;
            String[] classPathSegments = classPath.segments();
            int i = 0;
            while (i < classPathSegments.length) {
                if (bundleName.equals(classPathSegments[i])) {
                    bundleSegmentIndex = i;
                    break;
                }
                ++i;
            }
            if (bundleSegmentIndex >= 0 && (bundleRoot = classPath.uptoSegment(bundleSegmentIndex + 1)).toFile().exists()) {
                return bundleRoot;
            }
        }
        catch (Throwable ex) {
            ManifestExplorer.getLogger().logp(Level.FINE, sm_className, "getDomainBundlePath(Class,String)", "Unable to obtain bundle installation path from ProtectionDomain.", ex);
        }
        return null;
    }
}

