/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.diffmerge.ui.log;

import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStreamWriter;
import java.io.Writer;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.Status;
import org.eclipse.emf.common.util.Logger;
import org.eclipse.emf.diffmerge.ui.EMFDiffMergeUIPlugin;
import org.eclipse.emf.diffmerge.ui.log.AbstractLogEvent;

public class DiffMergeLogger
implements Logger {
    public static final String LINE_SEP = System.getProperty("line.separator");
    private static final String LOG_FILE_NAME = "ModelComparisonLog.txt";
    private static final String INDENT = "  ";
    private final IPath _logFile = Platform.getLogFileLocation().removeLastSegments(1).append("ModelComparisonLog.txt");
    private Writer _writer = null;

    public static void appendAtLevel(StringBuilder builder_p, int level_p, String addition_p) {
        int i = 0;
        while (i < level_p) {
            builder_p.append(INDENT);
            ++i;
        }
        builder_p.append(addition_p);
        builder_p.append(LINE_SEP);
    }

    public void close() {
        if (this._writer != null) {
            try {
                this._writer.close();
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
    }

    protected String getHeader() {
        return "****** Diff/Merge Report ******" + LINE_SEP;
    }

    public IPath getLogFile() {
        return this._logFile;
    }

    protected Writer getWriter() {
        if (this._writer == null) {
            String file = this._logFile.toOSString();
            try {
                FileOutputStream os = new FileOutputStream(file, false);
                this._writer = new OutputStreamWriter(os);
                this._writer.append(this.getHeader());
            }
            catch (IOException e) {
                EMFDiffMergeUIPlugin.getDefault().getLog().log((IStatus)new Status(2, EMFDiffMergeUIPlugin.getDefault().getPluginId(), "Cannot log Diff/Merge events", (Throwable)e));
            }
        }
        return this._writer;
    }

    public void log(Object logEntry_p) {
        Writer writer;
        if (logEntry_p instanceof AbstractLogEvent && (writer = this.getWriter()) != null) {
            AbstractLogEvent logEvent = (AbstractLogEvent)logEntry_p;
            try {
                writer.write(logEvent.getRepresentation());
                writer.flush();
            }
            catch (IOException e) {
                EMFDiffMergeUIPlugin.getDefault().getLog().log((IStatus)new Status(2, EMFDiffMergeUIPlugin.getDefault().getPluginId(), "Cannot log Diff/Merge event: " + logEntry_p, (Throwable)e));
            }
        }
    }
}

