/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.diffmerge.connector.core.ext;

import java.io.InputStream;
import org.eclipse.emf.diffmerge.api.scopes.IEditableModelScope;
import org.eclipse.emf.diffmerge.api.scopes.IPersistentModelScope;
import org.eclipse.emf.diffmerge.impl.scopes.AbstractModelScope;
import org.eclipse.emf.diffmerge.ui.specification.IModelScopeDefinition;
import org.eclipse.emf.diffmerge.ui.specification.ITimestampProvider;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.ecore.resource.ResourceSet;
import org.eclipse.emf.ecore.resource.URIConverter;

public class URIConvertingScopeDefinition
implements IModelScopeDefinition,
ITimestampProvider {
    protected final IModelScopeDefinition _wrapped;
    private boolean _editable;
    protected final URIConverter _uriConverter;
    protected InputStream _loadingStream;

    public URIConvertingScopeDefinition(IModelScopeDefinition wrapped_p, URIConverter uriConverter_p, boolean isEditable_p) {
        this._wrapped = wrapped_p;
        this._uriConverter = uriConverter_p;
        this._editable = isEditable_p;
    }

    public IEditableModelScope createScope(Object context_p) {
        IEditableModelScope result = this._editable ? this._wrapped.createScope(context_p) : this._wrapped.createScope(null);
        if (result instanceof AbstractModelScope) {
            ((AbstractModelScope)result).setOriginator((Object)this._wrapped.getLabel());
        }
        if (result instanceof IPersistentModelScope) {
            ResourceSet rs;
            Resource holdingResource;
            IPersistentModelScope casted = (IPersistentModelScope)result;
            if (this._loadingStream != null && casted instanceof IPersistentModelScope.Editable) {
                ((IPersistentModelScope.Editable)casted).setStream(this._loadingStream);
            }
            if ((holdingResource = casted.getHoldingResource()) != null && (rs = holdingResource.getResourceSet()) != null) {
                rs.setURIConverter(this._uriConverter);
            }
        }
        return result;
    }

    public Object getEntrypoint() {
        return this._wrapped.getEntrypoint();
    }

    public String getLabel() {
        return this._wrapped.getLabel();
    }

    public String getShortLabel() {
        return this._wrapped.getShortLabel();
    }

    public long getTimestamp() {
        long result = -1L;
        if (this._uriConverter instanceof ITimestampProvider) {
            result = ((ITimestampProvider)this._uriConverter).getTimestamp();
        }
        return result;
    }

    public boolean isEditable() {
        return this._editable;
    }

    public boolean isEditableSettable() {
        return false;
    }

    public void setEditable(boolean editable_p) {
        this._editable = editable_p;
    }

    public void setStream(InputStream stream_p) {
        this._loadingStream = stream_p;
    }
}

