/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.diffmerge.ui.viewers.categories;

import org.eclipse.emf.diffmerge.api.Role;
import org.eclipse.emf.diffmerge.api.diff.IDifference;
import org.eclipse.emf.diffmerge.api.diff.IElementPresence;
import org.eclipse.emf.diffmerge.api.diff.IPresenceDifference;
import org.eclipse.emf.diffmerge.api.diff.IReferenceValuePresence;
import org.eclipse.emf.diffmerge.diffdata.EComparison;
import org.eclipse.emf.diffmerge.ui.EMFDiffMergeUIPlugin;
import org.eclipse.emf.diffmerge.ui.Messages;
import org.eclipse.emf.diffmerge.ui.viewers.EMFDiffNode;
import org.eclipse.emf.diffmerge.ui.viewers.categories.AbstractSideRelatedDifferenceCategory;
import org.eclipse.swt.graphics.Image;

public class UnmatchedElementCategory
extends AbstractSideRelatedDifferenceCategory {
    public static final String ID_LEFT = "Technical.Unmatched.Left";
    public static final String ID_RIGHT = "Technical.Unmatched.Right";

    public UnmatchedElementCategory(boolean sideIsLeft_p) {
        super(sideIsLeft_p);
    }

    @Override
    public boolean covers(IDifference difference_p, EMFDiffNode node_p) {
        boolean result = false;
        Role sideRole = node_p.getRoleForSide(this.isLeftSide());
        EComparison comparison = node_p.getActualComparison();
        result = difference_p instanceof IPresenceDifference && ((IPresenceDifference)difference_p).getPresenceRole() == sideRole && (difference_p instanceof IElementPresence || difference_p instanceof IReferenceValuePresence && ((IReferenceValuePresence)difference_p).isContainment() && comparison.getLastMergePolicy().bindPresenceToOwnership(comparison.getScope(sideRole)));
        return result;
    }

    @Override
    public String getDescription(EMFDiffNode node_p) {
        String result = this.isLeftSide() ? Messages.UnmatchedElementCategory_DescriptionLeft : Messages.UnmatchedElementCategory_DescriptionRight;
        return result;
    }

    @Override
    public String getID() {
        return this.isLeftSide() ? ID_LEFT : ID_RIGHT;
    }

    @Override
    public Image getImage(EMFDiffNode node_p) {
        Role referenceRole = node_p.getReferenceRole();
        Role leftRole = node_p.getRoleForSide(true);
        EMFDiffMergeUIPlugin.ImageID imageID = this.isLeftSide() ? (referenceRole == leftRole ? EMFDiffMergeUIPlugin.ImageID.INC_REM_STAT : EMFDiffMergeUIPlugin.ImageID.OUT_ADD_STAT) : (referenceRole == leftRole.opposite() ? EMFDiffMergeUIPlugin.ImageID.OUT_REM_STAT : EMFDiffMergeUIPlugin.ImageID.INC_ADD_STAT);
        return node_p.getResourceManager().getStandaloneOverlay(imageID);
    }

    @Override
    public String getText(EMFDiffNode node_p) {
        String result = this.isLeftSide() ? Messages.UnmatchedElementCategory_TextLeft : Messages.UnmatchedElementCategory_TextRight;
        return result;
    }
}

