/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.diffmerge.patterns.templates.engine.specifications;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import org.eclipse.emf.common.util.ECollections;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.diffmerge.api.IDiffPolicy;
import org.eclipse.emf.diffmerge.api.IMatch;
import org.eclipse.emf.diffmerge.api.IMatchPolicy;
import org.eclipse.emf.diffmerge.api.IMergePolicy;
import org.eclipse.emf.diffmerge.api.Role;
import org.eclipse.emf.diffmerge.api.scopes.IEditableModelScope;
import org.eclipse.emf.diffmerge.impl.scopes.FilteredModelScope;
import org.eclipse.emf.diffmerge.patterns.core.api.IPattern;
import org.eclipse.emf.diffmerge.patterns.core.api.IPatternApplication;
import org.eclipse.emf.diffmerge.patterns.core.api.IPatternRole;
import org.eclipse.emf.diffmerge.patterns.core.api.locations.ILocation;
import org.eclipse.emf.diffmerge.patterns.core.api.locations.IReferenceLocation;
import org.eclipse.emf.diffmerge.patterns.core.util.BasicPatternApplication;
import org.eclipse.emf.diffmerge.patterns.core.util.locations.BasicElementLocation;
import org.eclipse.emf.diffmerge.patterns.core.util.locations.BasicReferenceLocation;
import org.eclipse.emf.diffmerge.patterns.templates.engine.diffmerge.TemplatePatternApplicationScope;
import org.eclipse.emf.diffmerge.patterns.templates.engine.diffmerge.TemplatePatternComparison;
import org.eclipse.emf.diffmerge.patterns.templates.engine.diffmerge.TemplatePatternContentScope;
import org.eclipse.emf.diffmerge.patterns.templates.engine.diffmerge.TemplatePatternDiffPolicy;
import org.eclipse.emf.diffmerge.patterns.templates.engine.diffmerge.TemplatePatternMatchPolicy;
import org.eclipse.emf.diffmerge.patterns.templates.engine.diffmerge.TemplatePatternMergePolicy;
import org.eclipse.emf.diffmerge.patterns.templates.engine.ext.ISemanticRuleProvider;
import org.eclipse.emf.diffmerge.patterns.templates.engine.specifications.AbstractModifiableTemplatePatternSpecification;
import org.eclipse.emf.diffmerge.patterns.templates.gen.templatepatterns.TemplatePattern;
import org.eclipse.emf.diffmerge.patterns.templates.gen.templatepatterns.TemplatePatternRole;
import org.eclipse.emf.diffmerge.patterns.templates.gen.templatepatterns.TemplatepatternsFactory;
import org.eclipse.emf.diffmerge.util.ModelsUtil;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EReference;

public class TemplatePatternCreationSpecification
extends AbstractModifiableTemplatePatternSpecification {
    private static final String INITIAL_VERSION = "1.0";
    private final boolean _isTemplate;
    private final List<String> _currentEnvironments;
    private boolean _hasInitializedRoles;

    public TemplatePatternCreationSpecification(boolean isTemplate_p, List<? extends Object> sources_p, List<String> currentEnvironments_p) {
        super(true, !isTemplate_p, sources_p.isEmpty() ? null : (sources_p.get(0) instanceof EObject ? null : (EObject)sources_p.get(0)));
        this.setPattern(TemplatepatternsFactory.eINSTANCE.createTemplatePattern());
        this._isTemplate = isTemplate_p;
        this._currentEnvironments = currentEnvironments_p;
        this.initializePattern(sources_p);
        this.initializeComparison(sources_p);
        this._hasInitializedRoles = false;
    }

    public EReference getCommonContainment(TemplatePatternRole role_p) {
        EReference result = null;
        for (EObject templateElement : role_p.getTemplateElements()) {
            EObject sourceElement = this.getCounterpart(templateElement, true);
            if (sourceElement == null || sourceElement.eContainmentFeature() == null) continue;
            EReference containment = sourceElement.eContainmentFeature();
            if (result == null) {
                result = containment;
                continue;
            }
            if (result == containment) continue;
            return null;
        }
        return result;
    }

    public boolean hasInitializedRoles() {
        return this._hasInitializedRoles;
    }

    private void initializeComparison(List<? extends Object> sources_p) {
        ArrayList<EObject> casted = new ArrayList<EObject>();
        for (Object object : sources_p) {
            if (!(object instanceof EObject)) continue;
            casted.add((EObject)object);
        }
        FilteredModelScope filteredModelScope = new FilteredModelScope(casted);
        filteredModelScope.build((ModelsUtil.IElementFilter)new TemplatePatternApplicationScope.PatternInstanceMarkerFilter());
        this.newComparison(new TemplatePatternComparison(this.getPattern(), (IEditableModelScope)new TemplatePatternContentScope(this.getPattern()), (IEditableModelScope)filteredModelScope));
    }

    private void initializePattern(List<? extends Object> sources_p) {
        TemplatePattern pattern = this.getPattern();
        String defaultName = null;
        if (!sources_p.isEmpty() && sources_p.get(0) instanceof EObject) {
            defaultName = this.getText((EObject)sources_p.get(0));
        }
        pattern.setName(defaultName == null ? "" : defaultName);
        pattern.setTemplate(this._isTemplate);
        pattern.setVersion(INITIAL_VERSION);
        pattern.getExecutionEnvironments().addAll(this._currentEnvironments);
        String userName = System.getenv("USERNAME");
        if (userName != null) {
            pattern.getAuthors().add((Object)userName);
        }
    }

    public void initializeRoles() {
        this.getComparison().compute((IMatchPolicy)new TemplatePatternMatchPolicy(null, null, null), (IDiffPolicy)new TemplatePatternDiffPolicy(), (IMergePolicy)new TemplatePatternMergePolicy(), null);
        this.mergeDifferences();
        Collection completedMatches = this.getComparison().getMapping().getCompletedMatches(Role.REFERENCE);
        for (IMatch match : completedMatches) {
            EObject ref = match.get(Role.REFERENCE);
            if (ref == null) continue;
            this._noIdsMap.put(ref, match.get(Role.TARGET));
        }
        HashMap<ComparableReferenceLocation, LinkedList<EObject>> origins = new HashMap<ComparableReferenceLocation, LinkedList<EObject>>();
        ISemanticRuleProvider ruleProvider = this.getSemanticRuleProvider();
        List contents = this.getModelScope().getContents();
        for (EObject eObject : contents) {
            if (ruleProvider.getOwnershipDerivationLevel(eObject) != 0 && contents.size() != 1) continue;
            if (eObject.eContainer() != null) {
                ComparableReferenceLocation location = new ComparableReferenceLocation(eObject.eContainer(), eObject.eContainmentFeature());
                LinkedList<EObject> peerRoots = (LinkedList<EObject>)origins.get((Object)location);
                if (peerRoots == null) {
                    peerRoots = new LinkedList<EObject>();
                    origins.put(location, peerRoots);
                }
                peerRoots.add(eObject);
                continue;
            }
            this.addRoleFor(eObject);
        }
        for (Map.Entry entry : origins.entrySet()) {
            this.addRoleFor((Collection)entry.getValue(), (IReferenceLocation)entry.getKey());
        }
        ECollections.sort((EList)this.getPattern().getRoles(), (Comparator)new Comparator<TemplatePatternRole>(){

            @Override
            public int compare(TemplatePatternRole o1_p, TemplatePatternRole o2_p) {
                return o1_p.getName().compareTo(o2_p.getName());
            }
        });
        this._hasInitializedRoles = true;
    }

    @Override
    public boolean isComplete() {
        boolean result;
        boolean bl = result = super.isComplete() && this.getRepository() != null;
        if (result && this.isTemplate()) {
            boolean first = true;
            for (TemplatePatternRole role : this.getPattern().getRoles()) {
                if (first) {
                    first = false;
                    result = role.getMergeDerivationRule() == null && role.getTemplateElements().size() == 1;
                } else {
                    boolean bl2 = result = role.getMergeDerivationRule() != null;
                }
                if (!result) break;
            }
        }
        return result;
    }

    public IPatternApplication toPatternApplication() {
        BasicPatternApplication result = new BasicPatternApplication((IPattern)this.getPattern());
        for (TemplatePatternRole role : this.getPattern().getRoles()) {
            for (EObject templateElement : role.getTemplateElements()) {
                EObject modelElement = this.getCounterpart(templateElement, true);
                if (modelElement == null) continue;
                Object location = modelElement.eContainer() != null ? new BasicReferenceLocation(modelElement.eContainer(), modelElement.eContainmentFeature()) : new BasicElementLocation(modelElement);
                result.addLocation((IPatternRole)role, (ILocation)location);
            }
        }
        return result;
    }

    protected static class ComparableReferenceLocation
    extends BasicReferenceLocation {
        public ComparableReferenceLocation(EObject element_p, EReference reference_p) {
            super(element_p, reference_p);
        }

        public boolean equals(Object object_p) {
            boolean result = false;
            if (object_p instanceof ComparableReferenceLocation) {
                ComparableReferenceLocation peer = (ComparableReferenceLocation)((Object)object_p);
                result = peer.getReference() == this.getReference() && peer.getElement() == this.getElement();
            }
            return result;
        }

        public int hashCode() {
            return this.getReference().hashCode() + this.getElement().hashCode();
        }
    }
}

