/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.diffmerge.impl.policies;

import java.util.Arrays;
import java.util.Collection;
import java.util.HashSet;
import org.eclipse.emf.diffmerge.api.IMatchPolicy;
import org.eclipse.emf.diffmerge.api.config.IComparisonConfiguration;
import org.eclipse.emf.diffmerge.api.config.IComparisonConfigurator;
import org.eclipse.emf.diffmerge.impl.policies.AbstractConfigurationElement;
import org.eclipse.emf.diffmerge.impl.policies.ConfigurableMatchPolicy;

public class ComparisonConfigurator
extends AbstractConfigurationElement
implements IComparisonConfigurator {
    protected final Collection<ConfigurableMatchPolicy.MatchCriterionKind> _selectedCriteria;
    protected final Collection<ConfigurableMatchPolicy.FineGrainedMatchCriterion> _selectedFineGrainedCriteria;

    public ComparisonConfigurator(String label_p, String description_p, Collection<ConfigurableMatchPolicy.MatchCriterionKind> selectedCriteria_p, Collection<ConfigurableMatchPolicy.FineGrainedMatchCriterion> selectedFineGrainedCriteria_p) {
        super(label_p, description_p);
        this._selectedCriteria = new HashSet<ConfigurableMatchPolicy.MatchCriterionKind>(selectedCriteria_p);
        this._selectedFineGrainedCriteria = new HashSet<ConfigurableMatchPolicy.FineGrainedMatchCriterion>(selectedFineGrainedCriteria_p);
    }

    @Override
    public boolean apply(IComparisonConfiguration configuration_p) {
        boolean result = true;
        IMatchPolicy matchPolicy = configuration_p.getMatchPolicy();
        if (matchPolicy instanceof ConfigurableMatchPolicy) {
            result = this.applyMatchCriteria((ConfigurableMatchPolicy)matchPolicy);
        }
        return result;
    }

    protected boolean applyMatchCriteria(ConfigurableMatchPolicy policy_p) {
        policy_p.setAllUsedCriteria(this._selectedCriteria);
        policy_p.setAllUsedFineGrainedCriteria(this._selectedFineGrainedCriteria);
        policy_p.setUseCache(this.mustUseCache());
        return true;
    }

    protected boolean checkMatchCriteria(ConfigurableMatchPolicy policy_p) {
        ConfigurableMatchPolicy.MatchCriterionKind[] matchCriterionKindArray = ConfigurableMatchPolicy.MatchCriterionKind.values();
        int n = matchCriterionKindArray.length;
        int n2 = 0;
        while (n2 < n) {
            ConfigurableMatchPolicy.MatchCriterionKind matchCriterionKind = matchCriterionKindArray[n2];
            boolean mustBeSelected = this._selectedCriteria.contains((Object)matchCriterionKind);
            if (policy_p.useCriterion(matchCriterionKind) != mustBeSelected) {
                return false;
            }
            ++n2;
        }
        for (ConfigurableMatchPolicy.FineGrainedMatchCriterion fineGrainedMatchCriterion : policy_p.getAvailableFineGrainedCriteria()) {
            boolean mustBeSelected = this._selectedFineGrainedCriteria.contains(fineGrainedMatchCriterion);
            if (!this._selectedCriteria.contains((Object)fineGrainedMatchCriterion.getParentCriterion()) || policy_p.useFineGrainedCriterion(fineGrainedMatchCriterion) == mustBeSelected) continue;
            return false;
        }
        return this.mustUseCache() == policy_p.useCache();
    }

    @Override
    public boolean isCompliant(IComparisonConfiguration configuration_p) {
        IMatchPolicy rawMatchPolicy = configuration_p.getMatchPolicy();
        if (!(rawMatchPolicy instanceof ConfigurableMatchPolicy)) {
            return false;
        }
        ConfigurableMatchPolicy matchPolicy = (ConfigurableMatchPolicy)rawMatchPolicy;
        return this.checkMatchCriteria(matchPolicy);
    }

    protected boolean mustUseCache() {
        return !Arrays.asList(ConfigurableMatchPolicy.MatchCriterionKind.EXTRINSIC_ID, ConfigurableMatchPolicy.MatchCriterionKind.INTRINSIC_ID).containsAll(this._selectedCriteria);
    }
}

