/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.diffmerge.generic.impl.helpers;

import java.util.Collection;
import java.util.Collections;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.emf.diffmerge.generic.Messages;
import org.eclipse.emf.diffmerge.generic.api.IComparison;
import org.eclipse.emf.diffmerge.generic.api.IMapping;
import org.eclipse.emf.diffmerge.generic.api.IMatch;
import org.eclipse.emf.diffmerge.generic.api.IMergeSelector;
import org.eclipse.emf.diffmerge.generic.api.Role;
import org.eclipse.emf.diffmerge.generic.api.diff.IDifference;
import org.eclipse.emf.diffmerge.generic.api.diff.IMergeableDifference;
import org.eclipse.emf.diffmerge.generic.impl.helpers.AbstractExpensiveOperation;
import org.eclipse.emf.diffmerge.structures.common.FArrayList;

public class MergeOperation<E>
extends AbstractExpensiveOperation {
    protected final IComparison<E> _comparison;
    protected final IMergeSelector<E> _merger;
    protected final Collection<? extends IDifference<E>> _toMerge;
    protected final Role _destinationRole;
    protected final boolean _updateReferences;
    protected final Collection<IDifference<E>> _actuallyMerged;

    public MergeOperation(IComparison<E> comparison_p, Collection<? extends IDifference<E>> differences_p, Role destination_p, boolean updateReferences_p) {
        this._comparison = comparison_p;
        this._toMerge = differences_p;
        this._destinationRole = destination_p;
        this._merger = null;
        this._updateReferences = updateReferences_p;
        this._actuallyMerged = new FArrayList();
    }

    public MergeOperation(IComparison<E> comparison_p, IMergeSelector<E> merger_p, boolean updateReferences_p) {
        this._comparison = comparison_p;
        this._toMerge = Collections.emptySet();
        this._destinationRole = null;
        this._merger = merger_p;
        this._updateReferences = updateReferences_p;
        this._actuallyMerged = new FArrayList();
    }

    public Collection<IDifference<E>> getOutput() {
        return Collections.unmodifiableCollection(this._actuallyMerged);
    }

    @Override
    public String getOperationName() {
        return Messages.MergeOperation_Name;
    }

    @Override
    protected int getWorkAmount() {
        int nbDiffs = this.isGlobal() ? this._comparison.getMapping().size() : this._toMerge.size();
        return 1 + nbDiffs + (this._updateReferences ? 1 : 0);
    }

    protected boolean isGlobal() {
        return this._merger != null;
    }

    @Override
    public IStatus run() {
        this.getMonitor().worked(1);
        IStatus result = this.isGlobal() ? this.runOnComparison() : this.runOnSet();
        if (this._updateReferences && result != null && result.isOK()) {
            this.checkProgress();
            IMapping.Editable mapping = (IMapping.Editable)this._comparison.getMapping();
            if (this._destinationRole != null) {
                mapping.completeReferences(this._destinationRole);
            } else {
                mapping.completeReferences(Role.TARGET);
                mapping.completeReferences(Role.REFERENCE);
            }
            this.getMonitor().worked(1);
        }
        return result;
    }

    protected IStatus runOnComparison() {
        for (IMatch<E> match : this._comparison.getMapping().getContents()) {
            for (IDifference<E> difference : match.getAllDifferences()) {
                this.checkProgress();
                Role mergeDirection = this._merger.getMergeDirection(difference);
                if (mergeDirection == null || !difference.canMergeTo(mergeDirection)) continue;
                try {
                    Collection merged = ((IMergeableDifference)difference).mergeTo(mergeDirection);
                    this._actuallyMerged.addAll(merged);
                }
                catch (UnsupportedOperationException unsupportedOperationException) {
                    // empty catch block
                }
            }
            this.getMonitor().worked(1);
        }
        return Status.OK_STATUS;
    }

    protected IStatus runOnSet() {
        for (IDifference<E> difference : this._toMerge) {
            this.checkProgress();
            try {
                if (difference instanceof IMergeableDifference) {
                    Collection merged = ((IMergeableDifference)difference).mergeTo(this._destinationRole);
                    this._actuallyMerged.addAll(merged);
                }
            }
            catch (UnsupportedOperationException unsupportedOperationException) {
                // empty catch block
            }
            this.getMonitor().worked(1);
        }
        return Status.OK_STATUS;
    }
}

