/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.diffmerge.ui.log;

import java.util.Collection;
import java.util.Collections;
import java.util.List;
import org.eclipse.emf.diffmerge.generic.api.IMatch;
import org.eclipse.emf.diffmerge.generic.api.Role;
import org.eclipse.emf.diffmerge.generic.api.diff.IDifference;
import org.eclipse.emf.diffmerge.generic.api.diff.IElementRelativeDifference;
import org.eclipse.emf.diffmerge.generic.api.diff.IReferenceValuePresence;
import org.eclipse.emf.diffmerge.generic.api.scopes.IEditableTreeDataScope;
import org.eclipse.emf.diffmerge.structures.common.FArrayList;
import org.eclipse.emf.diffmerge.ui.log.AbstractLogEvent;
import org.eclipse.emf.diffmerge.ui.log.DiffMergeLogger;
import org.eclipse.emf.diffmerge.ui.viewers.EMFDiffNode;

public class MergeLogEvent
extends AbstractLogEvent {
    private final List<IDifference<?>> _diffs;
    private final boolean _mergeToLeft;

    public MergeLogEvent(EMFDiffNode node_p, IDifference<?> diff_p, boolean mergeToLeft_p) {
        this(node_p, Collections.singletonList(diff_p), mergeToLeft_p);
    }

    public MergeLogEvent(EMFDiffNode node_p, Collection<? extends IDifference<?>> diffs_p, boolean mergeToLeft_p) {
        super(node_p);
        this._mergeToLeft = mergeToLeft_p;
        this._diffs = new FArrayList(diffs_p, null);
    }

    public List<IDifference<?>> getDifferences() {
        return Collections.unmodifiableList(this._diffs);
    }

    @Override
    public String getRepresentation() {
        StringBuilder builder = new StringBuilder();
        EMFDiffNode node = this.getDiffNode();
        Role destination = node.getRoleForSide(this.isToLeft());
        String destinationName = this.isToLeft() ? "Left" : "Right";
        for (IDifference<?> difference : this.getDifferences()) {
            IMatch match;
            builder.append(DiffMergeLogger.LINE_SEP);
            if (difference instanceof IElementRelativeDifference && (match = difference instanceof IReferenceValuePresence && ((IReferenceValuePresence)difference).isOwnership() ? ((IReferenceValuePresence)difference).getValueMatch() : ((IElementRelativeDifference)difference).getElementMatch()) != null) {
                Object location = this.getNonNull(match, destination);
                IEditableTreeDataScope sourceScope = this.getDiffNode().getActualComparison().getScope(destination.opposite());
                Object type = sourceScope.mGetType(location);
                String typeName = this.getLabelProvider().getText(type);
                String name = this.getLabelProvider().getMatchText(match, destination, node.getEditingDomain());
                Object id = this.getID(location, destination.opposite());
                builder.append('[');
                builder.append(destinationName);
                builder.append(']');
                builder.append(' ');
                builder.append(typeName);
                builder.append(' ');
                builder.append('\'');
                builder.append(name);
                builder.append('\'');
                builder.append("  (ID:");
                builder.append(id);
                builder.append(')');
                builder.append(DiffMergeLogger.LINE_SEP);
            }
            String msg = this.getLabelProvider().getDifferenceText(difference, destination, node.getEditingDomain());
            DiffMergeLogger.appendAtLevel(builder, 1, msg);
        }
        return builder.toString();
    }

    public boolean isToLeft() {
        return this._mergeToLeft;
    }
}

