/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.diffmerge.patterns.ui.util;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.Reader;
import java.io.StringReader;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import org.apache.batik.transcoder.TranscoderInput;
import org.apache.batik.transcoder.TranscoderOutput;
import org.apache.batik.transcoder.image.PNGTranscoder;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.IPath;
import org.eclipse.emf.common.ui.dialogs.WorkspaceResourceDialog;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.diffmerge.patterns.core.CorePatternsPlugin;
import org.eclipse.emf.diffmerge.patterns.core.api.INamedElement;
import org.eclipse.emf.diffmerge.patterns.core.api.IPatternInstance;
import org.eclipse.emf.diffmerge.patterns.core.api.ext.IModelOperation;
import org.eclipse.emf.diffmerge.patterns.core.api.status.IEvaluationStatus;
import org.eclipse.emf.diffmerge.patterns.core.util.ResourcesUtil;
import org.eclipse.emf.diffmerge.patterns.diagrams.util.PatternsDiagramsUtil;
import org.eclipse.emf.diffmerge.patterns.repositories.catalogs.PatternCatalogResourceHelper;
import org.eclipse.emf.diffmerge.patterns.repositories.catalogs.operations.OpenCatalogOperation;
import org.eclipse.emf.diffmerge.patterns.templates.engine.specifications.AbstractTemplatePatternSelection;
import org.eclipse.emf.diffmerge.patterns.templates.gen.templatepatterns.TemplatePatternRole;
import org.eclipse.emf.diffmerge.patterns.ui.Messages;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.ecore.resource.ResourceSet;
import org.eclipse.emf.transaction.TransactionalEditingDomain;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.resource.FontRegistry;
import org.eclipse.jface.resource.JFaceResources;
import org.eclipse.jface.viewers.ILabelProvider;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.jface.viewers.ViewerFilter;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.graphics.FontData;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.ImageData;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.PlatformUI;

public final class UIUtil {
    private static final String NOT_LOADED_SUFFIX = Messages.UIUtil_NotLoaded;
    private static boolean __fontInitialized = false;
    public static final ViewerFilter INSTANCE_VIEWER_FILTER = new ViewerFilter(){

        public boolean select(Viewer viewer_p, Object parentElement_p, Object element_p) {
            boolean result = true;
            if (parentElement_p instanceof EObject) {
                result = AbstractTemplatePatternSelection.INSTANCE_FILTER.accepts((EObject)parentElement_p);
            }
            return result;
        }
    };

    private UIUtil() {
    }

    public static String buildStringWith(Iterable<? extends INamedElement> elements_p, String separator_p, String leftEncapsulator_p, String rightEncapsulator_p) {
        StringBuilder builder = new StringBuilder();
        Iterator<? extends INamedElement> it = elements_p.iterator();
        while (it.hasNext()) {
            INamedElement element = it.next();
            if (leftEncapsulator_p != null) {
                builder.append(leftEncapsulator_p);
            }
            builder.append(element.getName());
            if (rightEncapsulator_p != null) {
                builder.append(rightEncapsulator_p);
            }
            if (separator_p == null || !it.hasNext()) continue;
            builder.append(separator_p);
        }
        return builder.toString();
    }

    public static void centerShell(Shell shell_p) {
        Rectangle pbounds = shell_p.getDisplay().getBounds();
        Rectangle bounds = shell_p.getBounds();
        shell_p.setBounds(pbounds.x + (pbounds.width - bounds.width) / 2, pbounds.y + (pbounds.height - bounds.height) / 2, bounds.width, bounds.height);
    }

    public static Point getBoundedImageSize(ImageData imageData_p, int maxWidth_p, int maxHeight_p) {
        Point result;
        if (maxWidth_p > 0 || maxHeight_p > 0) {
            float widthFactor = (float)maxWidth_p / (float)imageData_p.width;
            float heightFactor = (float)maxHeight_p / (float)imageData_p.height;
            float minFactor = widthFactor <= 0.0f ? heightFactor : (heightFactor <= 0.0f ? widthFactor : Math.min(widthFactor, heightFactor));
            int newWidth = (int)((float)imageData_p.width * minFactor);
            int newHeight = (int)((float)imageData_p.height * minFactor);
            result = new Point(newWidth, newHeight);
        } else {
            result = new Point(imageData_p.width, imageData_p.height);
        }
        return result;
    }

    public static Font getBold(Font font_p) {
        FontData data = font_p.getFontData()[0];
        Font result = JFaceResources.getFontRegistry().getBold(data.getName());
        return result;
    }

    public static Font getBoldItalic(Font font_p) {
        String ITALIC_BOLD_FONT = "patterns-italic-bold";
        FontRegistry registry = JFaceResources.getFontRegistry();
        if (!__fontInitialized) {
            FontData data = font_p.getFontData()[0];
            FontData newData = new FontData(data.toString());
            newData.setStyle(3);
            registry.put("patterns-italic-bold", new FontData[]{newData});
            __fontInitialized = true;
        }
        Font result = registry.get("patterns-italic-bold");
        return result;
    }

    public static Font getBoundElementFont(Font font_p) {
        return UIUtil.getBoldItalic(font_p);
    }

    public static final Color getColor(int code_p) {
        return Display.getDefault().getSystemColor(code_p);
    }

    public static void informRepositoryOpeningError(Shell shell_p, Map<URI, Throwable> errors_p) {
        StringBuilder builder = new StringBuilder();
        builder.append(Messages.UIUtil_OpeningFailure);
        for (URI uri : errors_p.keySet()) {
            builder.append("\n- ");
            builder.append(uri.lastSegment());
        }
        builder.append('\n');
        builder.append(Messages.UIUtil_OpeningRequiresMigration);
        MessageDialog.openError((Shell)shell_p, (String)CorePatternsPlugin.getDefault().getLabel(), (String)builder.toString());
    }

    public static void informError(Shell shell_p) {
        Shell shell = shell_p;
        if (shell == null) {
            shell = PlatformUI.getWorkbench().getActiveWorkbenchWindow().getShell();
        }
        MessageDialog.openError((Shell)shell_p, (String)CorePatternsPlugin.getDefault().getLabel(), (String)Messages.UIUtil_OperationError);
    }

    public static void informFromStatus(IEvaluationStatus status_p, Shell shell_p) {
        Shell shell = shell_p;
        if (shell == null) {
            shell = PlatformUI.getWorkbench().getActiveWorkbenchWindow().getShell();
        }
        if (status_p == null || status_p.getDescription().length() == 0 && !status_p.isOk()) {
            UIUtil.informError(shell);
        } else {
            String message = status_p.getDescription();
            String title = CorePatternsPlugin.getDefault().getLabel();
            if (status_p.isOk()) {
                if (status_p.hasWarnings()) {
                    MessageDialog.openWarning((Shell)shell, (String)title, (String)message);
                } else {
                    MessageDialog.openInformation((Shell)shell, (String)title, (String)message);
                }
            } else {
                MessageDialog.openError((Shell)shell, (String)title, (String)message);
            }
        }
    }

    public static void informSuccess(Shell shell_p) {
        Shell shell = shell_p;
        if (shell == null) {
            shell = PlatformUI.getWorkbench().getActiveWorkbenchWindow().getShell();
        }
        MessageDialog.openInformation((Shell)shell_p, (String)CorePatternsPlugin.getDefault().getLabel(), (String)Messages.UIUtil_SuccessfulOperation);
    }

    public static boolean isSignificant(String ... strings_p) {
        String[] stringArray = strings_p;
        int n = strings_p.length;
        int n2 = 0;
        while (n2 < n) {
            String string = stringArray[n2];
            if (!UIUtil.isSignificantHelper(string)) {
                return false;
            }
            ++n2;
        }
        return true;
    }

    private static boolean isSignificantHelper(String string_p) {
        return string_p != null && string_p.length() > 0;
    }

    private static IPath makePathUnique(IPath original_p) {
        IPath result = original_p;
        int i = 1;
        while (ResourcesUtil.getFileForPath((IPath)result).exists() && i < 20) {
            result = original_p.removeLastSegments(1).append(String.valueOf(original_p.removeFileExtension().lastSegment()) + "(" + i + ")." + original_p.getFileExtension());
            ++i;
        }
        return result;
    }

    public static String markAsBoundElement(String label_p, Collection<? extends TemplatePatternRole> roles_p, Collection<? extends TemplatePatternRole> additionRoles_p) {
        StringBuilder result = new StringBuilder(label_p);
        ArrayList<? extends TemplatePatternRole> mergeRoles = new ArrayList<TemplatePatternRole>(roles_p);
        mergeRoles.removeAll(additionRoles_p);
        if (!mergeRoles.isEmpty()) {
            if (mergeRoles.size() > 1) {
                result.append("  (" + Messages.UIUtil_MergedRoles);
            } else {
                result.append("  (" + Messages.UIUtil_MergedRole);
            }
            result.append(UIUtil.buildStringWith(mergeRoles, ", ", null, null));
            result.append(')');
        }
        if (!additionRoles_p.isEmpty()) {
            if (additionRoles_p.size() > 1) {
                result.append("  (" + Messages.UIUtil_ContainerRoles);
            } else {
                result.append("  (" + Messages.UIUtil_ContainerRole);
            }
            result.append(UIUtil.buildStringWith(additionRoles_p, ", ", null, null));
            result.append(')');
        }
        return result.toString();
    }

    public static String markAsMultipleElement(String label_p) {
        return String.valueOf(label_p) + " [*]";
    }

    public static String markAsDerivableRole(String roleLabel_p) {
        return "(" + roleLabel_p + ")";
    }

    public static String markAsDependentElement(String label_p) {
        return "~" + label_p;
    }

    public static String markAsFreeRole(String roleLabel_p) {
        return "> " + roleLabel_p;
    }

    public static String markAsNotLoaded(String name_p) {
        String result = name_p != null ? String.valueOf(name_p) + " " + NOT_LOADED_SUFFIX : NOT_LOADED_SUFFIX;
        return result;
    }

    public static IFile promptForNewCatalogFile(Shell shell_p, Resource resource_p, ResourceSet rset_p) {
        IFile result = null;
        IPath suggestedFile = PatternsDiagramsUtil.getDefaultCatalogPathFor((Resource)resource_p);
        if (suggestedFile != null) {
            suggestedFile = UIUtil.makePathUnique(suggestedFile);
        }
        boolean confirmed = false;
        while (!confirmed) {
            result = WorkspaceResourceDialog.openNewFile((Shell)shell_p, (String)CorePatternsPlugin.getDefault().getLabel(), (String)Messages.UIUtil_NewCatalogPrompt, (IPath)suggestedFile, null);
            if (result == null) {
                confirmed = true;
                continue;
            }
            String catalogExtension = PatternCatalogResourceHelper.getPatternCatalogFileExtension();
            if (!catalogExtension.equals(result.getFileExtension())) {
                result = ResourcesPlugin.getWorkspace().getRoot().getFile(result.getFullPath().removeFileExtension().addFileExtension(catalogExtension));
            }
            confirmed = result.exists() ? MessageDialog.openQuestion((Shell)shell_p, (String)CorePatternsPlugin.getDefault().getLabel(), (String)Messages.UIUtil_FileExists) : true;
        }
        return result;
    }

    public static List<String> parseCommaSeparatedString(String string_p) {
        LinkedList<String> rawResult = new LinkedList<String>();
        List<String> lines = UIUtil.parseMultilineString(string_p);
        for (String line : lines) {
            String[] elements = line.split("(,|;)");
            rawResult.addAll(Arrays.asList(elements));
        }
        LinkedList<String> result = new LinkedList<String>();
        for (String element : rawResult) {
            String newElement = element.trim();
            if (newElement.length() <= 0) continue;
            result.add(newElement);
        }
        return Collections.unmodifiableList(result);
    }

    public static List<String> parseMultilineString(String string_p) {
        List<String> result = Collections.emptyList();
        if (string_p != null) {
            String text = string_p.replace("\r", "");
            String[] lines = text.split("\n");
            result = Arrays.asList(lines);
        }
        return result;
    }

    public static List<IFile> promptForExistingCatalogs(Shell shell_p, Resource resource_p, ResourceSet rset_p) {
        Object[] objectArray;
        IPath path;
        IFile defaultSelection = null;
        if (rset_p != null && (path = PatternsDiagramsUtil.getDefaultCatalogPathFor((Resource)resource_p)) != null) {
            IFile suggestion = ResourcesPlugin.getWorkspace().getRoot().getFile(path);
            defaultSelection = suggestion.exists() ? suggestion : suggestion.getParent();
        }
        LinkedList<CatalogFileFilter> filters = new LinkedList<CatalogFileFilter>();
        filters.add(new CatalogFileFilter());
        String string = CorePatternsPlugin.getDefault().getLabel();
        if (defaultSelection == null) {
            objectArray = new Object[]{};
        } else {
            Object[] objectArray2 = new Object[1];
            objectArray = objectArray2;
            objectArray2[0] = defaultSelection;
        }
        IFile[] selected = WorkspaceResourceDialog.openFileSelection((Shell)shell_p, (String)string, (String)Messages.UIUtil_CatalogPrompt, (boolean)true, (Object[])objectArray, filters);
        return Arrays.asList(selected);
    }

    public static Image renderSVG(String svgData_p) {
        Image result = null;
        PNGTranscoder transcoder = new PNGTranscoder();
        StringReader reader = new StringReader(svgData_p);
        TranscoderInput input = new TranscoderInput((Reader)reader);
        ByteArrayOutputStream outStream = new ByteArrayOutputStream();
        TranscoderOutput output = new TranscoderOutput((OutputStream)outStream);
        try {
            transcoder.transcode(input, output);
            ByteArrayInputStream inStream = new ByteArrayInputStream(outStream.toByteArray());
            ImageData imageData = new ImageData((InputStream)inStream);
            inStream.close();
            outStream.close();
            result = new Image((Device)PlatformUI.getWorkbench().getDisplay(), imageData);
        }
        catch (Exception exception) {
            // empty catch block
        }
        return result;
    }

    public static boolean resolvePatternWithUser(Shell shell_p, Collection<? extends IPatternInstance> instances_p) {
        ResourceSet rs;
        boolean result = false;
        assert (!instances_p.isEmpty());
        IPatternInstance defaultInstance = instances_p.iterator().next();
        Resource resource = defaultInstance instanceof EObject ? ((EObject)defaultInstance).eResource() : null;
        TransactionalEditingDomain catalogDomain = CorePatternsPlugin.getDefault().getModelEnvironment().getCommonCatalogEditingDomain();
        if (catalogDomain != null && (rs = catalogDomain.getResourceSet()) != null) {
            for (IPatternInstance iPatternInstance : instances_p) {
                if (iPatternInstance.getPattern() != null) continue;
                OpenCatalogOperation operation = new OpenCatalogOperation(iPatternInstance, catalogDomain);
                Collection loaded = (Collection)CorePatternsPlugin.getDefault().getModelEnvironment().execute((IModelOperation)operation);
                if (loaded == null) {
                    System.out.println("Couldn't load pattern catalog.");
                    continue;
                }
                if (!operation.getErrors().isEmpty()) {
                    UIUtil.informRepositoryOpeningError(shell_p, operation.getErrors());
                }
                boolean bl = result = !loaded.isEmpty() && iPatternInstance.getPattern() != null;
                if (result) continue;
                List<IFile> userSelected = UIUtil.promptForExistingCatalogs(shell_p, resource, rs);
                if (userSelected.isEmpty()) {
                    return true;
                }
                for (IFile selectedFile : userSelected) {
                    operation = new OpenCatalogOperation((Object)selectedFile, catalogDomain, instances_p);
                    loaded = (Collection)CorePatternsPlugin.getDefault().getModelEnvironment().execute((IModelOperation)operation);
                    boolean bl2 = result = result || !loaded.isEmpty();
                }
            }
        }
        return result;
    }

    public static class CatalogFileFilter
    extends ViewerFilter {
        public boolean select(Viewer viewer_p, Object parentElement_p, Object element_p) {
            if (!(element_p instanceof IFile)) {
                return true;
            }
            return PatternCatalogResourceHelper.isPatternCatalogResource((IResource)((IFile)element_p));
        }
    }

    public static class LabelBasedComparator
    implements Comparator<Object> {
        private final ILabelProvider _labelProvider;

        public LabelBasedComparator(ILabelProvider labelProvider_p) {
            this._labelProvider = labelProvider_p;
        }

        @Override
        public int compare(Object o1_p, Object o2_p) {
            String label2;
            String label1 = this._labelProvider.getText(o1_p);
            if (label1 == null) {
                label1 = o1_p.toString();
            }
            if ((label2 = this._labelProvider.getText(o2_p)) == null) {
                label2 = o2_p.toString();
            }
            return label1.compareTo(label2);
        }
    }
}

