/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.diffmerge.patterns.ui.dialogs;

import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.eclipse.emf.common.util.ECollections;
import org.eclipse.emf.common.util.EMap;
import org.eclipse.emf.diffmerge.patterns.core.api.locations.IElementMappingLocation;
import org.eclipse.emf.diffmerge.patterns.core.util.locations.BasicElementMappingLocation;
import org.eclipse.emf.diffmerge.patterns.templates.gen.templatepatterns.TemplatePatternRole;
import org.eclipse.emf.diffmerge.patterns.ui.Messages;
import org.eclipse.emf.diffmerge.patterns.ui.viewers.ModelSubsetViewer;
import org.eclipse.emf.diffmerge.util.structures.FArrayList;
import org.eclipse.emf.diffmerge.util.structures.FHashMap;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.jface.dialogs.IDialogConstants;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.util.IPropertyChangeListener;
import org.eclipse.jface.util.PropertyChangeEvent;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.jface.viewers.ViewerSorter;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ElementMappingDialog
extends MessageDialog {
    protected final ElementMappingSpecification _data;

    public ElementMappingDialog(Shell parentShell_p, TemplatePatternRole role_p, Collection<? extends EObject> modelElements_p) {
        super(parentShell_p, Messages.ElementMappingDialog_Title, null, ElementMappingDialog.getDialogMessage(role_p), 0, new String[]{IDialogConstants.OK_LABEL, IDialogConstants.CANCEL_LABEL}, 0);
        this._data = new ElementMappingSpecification((Collection<? extends EObject>)role_p.getTemplateElements(), modelElements_p);
        this.setShellStyle(this.getShellStyle() | 0x10);
    }

    private static String getDialogMessage(TemplatePatternRole role_p) {
        return String.format(Messages.ElementMappingDialog_Message, role_p.getName());
    }

    protected Control createCustomArea(Composite parent_p) {
        Composite result = new Composite(parent_p, 0);
        GridData resultLayoutData = new GridData(4, 4, true, true);
        resultLayoutData.heightHint = 300;
        resultLayoutData.widthHint = 700;
        result.setLayoutData((Object)resultLayoutData);
        result.setLayout((Layout)new GridLayout(3, false));
        Group leftGroup = new Group(result, 0);
        leftGroup.setText(Messages.ElementMappingDialog_PatternElements);
        leftGroup.setLayoutData((Object)new GridData(4, 4, true, true));
        leftGroup.setLayout((Layout)new GridLayout());
        ModelSubsetViewer leftViewer = this.createPatternViewer((Composite)leftGroup);
        Composite buttonComposite = new Composite(result, 0);
        buttonComposite.setLayoutData((Object)new GridData(4, 0x1000000, false, true));
        GridLayout buttonCompositeLayout = new GridLayout();
        buttonCompositeLayout.marginHeight = 0;
        buttonCompositeLayout.marginWidth = 0;
        buttonComposite.setLayout((Layout)buttonCompositeLayout);
        Button mapButton = this.createMapButton(buttonComposite);
        mapButton.setLayoutData((Object)new GridData(4, 0x1000000, false, false));
        Button unmapButton = this.createUnmapButton(buttonComposite);
        unmapButton.setLayoutData((Object)new GridData(4, 0x1000000, false, false));
        Group rightGroup = new Group(result, 0);
        rightGroup.setText(Messages.ElementMappingDialog_ModelElements);
        rightGroup.setLayoutData((Object)new GridData(4, 4, true, true));
        rightGroup.setLayout((Layout)new GridLayout());
        this.createModelViewer((Composite)rightGroup);
        if (this._data.getModelElements().size() == 1 && this._data.getPatternElements().size() == 1) {
            this._data.map(this._data.getPatternElements().get(0), this._data.getModelElements().get(0));
        }
        leftViewer.getControl().setFocus();
        return result;
    }

    protected ModelSubsetViewer createModelViewer(Composite parent_p) {
        final ModelSubsetViewer result = new ModelSubsetViewer(parent_p, true, false){

            protected ViewerSorter getSorter() {
                return new ViewerSorter(){
                    private static final int MAPPED_CATEGORY = 0;
                    private static final int UNMAPPED_CATEGORY = 1;

                    public int category(Object element_p) {
                        int localResult;
                        if (element_p instanceof EObject) {
                            boolean isMapped = (this).ElementMappingDialog.this._data.isMapped((EObject)element_p, false) || (this).ElementMappingDialog.this._data.isMapped((EObject)element_p, true);
                            localResult = isMapped ? 0 : 1;
                        } else {
                            localResult = super.category(element_p);
                        }
                        return localResult;
                    }

                    public int compare(Viewer viewer_p, Object e1_p, Object e2_p) {
                        int localResult;
                        if (this.category(e1_p) == 0 && this.category(e2_p) == 0) {
                            EObject modelElement1 = (EObject)e1_p;
                            EObject modelElement2 = (EObject)e2_p;
                            EObject patternElement1 = (EObject)(this).ElementMappingDialog.this._data.getModelToPatternMap().get((Object)modelElement1);
                            EObject patternElement2 = (EObject)(this).ElementMappingDialog.this._data.getModelToPatternMap().get((Object)modelElement2);
                            localResult = super.compare(viewer_p, (Object)patternElement1, (Object)patternElement2);
                        } else {
                            localResult = super.compare(viewer_p, e1_p, e2_p);
                        }
                        return localResult;
                    }
                };
            }

            protected String getText(EObject element_p, String defaultText_p) {
                String localResult = defaultText_p;
                if (ElementMappingDialog.this._data.getModelElements().contains(element_p) && !ElementMappingDialog.this._data.isMapped(element_p, false)) {
                    localResult = ElementMappingDialog.this.getUnmappedLabel(localResult);
                }
                return localResult;
            }

            protected int getControlWidgetConfiguration() {
                return ModelSubsetViewer.SHOW_PARENTS | ModelSubsetViewer.EXPAND | ModelSubsetViewer.COLLAPSE;
            }
        };
        result.setInput(this._data.getModelElements());
        result.addSelectionListener(new ISelectionChangedListener(){

            public void selectionChanged(SelectionChangedEvent event_p) {
                ElementMappingDialog.this._data.updateModelSelection((IStructuredSelection)event_p.getSelection());
            }
        });
        this._data.addPropertyChangeListener(new IPropertyChangeListener(){

            public void propertyChange(PropertyChangeEvent event) {
                if ("mapping_property".equals(event.getProperty())) {
                    result.refresh();
                }
            }
        });
        return result;
    }

    protected String getUnmappedLabel(String defaultLabel_p) {
        return "> " + defaultLabel_p;
    }

    protected ModelSubsetViewer createPatternViewer(Composite parent_p) {
        final ModelSubsetViewer result = new ModelSubsetViewer(parent_p, true, false){

            protected ViewerSorter getSorter() {
                return new ViewerSorter(){

                    public int category(Object element_p) {
                        boolean isMapped;
                        int localResult = element_p instanceof EObject ? ((isMapped = (this).ElementMappingDialog.this._data.isMapped((EObject)element_p, true)) ? 0 : 1) : super.category(element_p);
                        return localResult;
                    }
                };
            }

            protected String getText(EObject element_p, String defaultText_p) {
                String localResult = defaultText_p;
                if (ElementMappingDialog.this._data.getPatternElements().contains(element_p) && !ElementMappingDialog.this._data.isMapped(element_p, true)) {
                    localResult = ElementMappingDialog.this.getUnmappedLabel(localResult);
                }
                return localResult;
            }

            protected int getControlWidgetConfiguration() {
                return ModelSubsetViewer.SHOW_PARENTS | ModelSubsetViewer.EXPAND | ModelSubsetViewer.COLLAPSE;
            }
        };
        result.setInput(this._data.getPatternElements());
        result.addSelectionListener(new ISelectionChangedListener(){

            public void selectionChanged(SelectionChangedEvent event_p) {
                ElementMappingDialog.this._data.updatePatternSelection((IStructuredSelection)event_p.getSelection());
            }
        });
        this._data.addPropertyChangeListener(new IPropertyChangeListener(){

            public void propertyChange(PropertyChangeEvent event) {
                if ("mapping_property".equals(event.getProperty())) {
                    result.refresh();
                }
            }
        });
        return result;
    }

    protected Button createMapButton(Composite parent_p) {
        final Button result = new Button(parent_p, 8);
        result.setText(Messages.ElementMappingDialog_Map);
        result.setEnabled(false);
        this._data.addPropertyChangeListener(new IPropertyChangeListener(){

            public void propertyChange(PropertyChangeEvent event_p) {
                if ("model_selection_property".equals(event_p.getProperty()) || "pattern_selection_property".equals(event_p.getProperty())) {
                    boolean enable = ElementMappingDialog.this._data.getPatternSelection().size() == 1 && ElementMappingDialog.this._data.getModelSelection().size() == 1 && ElementMappingDialog.this._data.getPatternSelection().get(0).eClass() == ElementMappingDialog.this._data.getModelSelection().get(0).eClass();
                    result.setEnabled(enable);
                }
            }
        });
        result.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent event_p) {
                if (ElementMappingDialog.this._data.getPatternSelection().size() == 1 && ElementMappingDialog.this._data.getModelSelection().size() == 1) {
                    ElementMappingDialog.this._data.map(ElementMappingDialog.this._data.getPatternSelection().get(0), ElementMappingDialog.this._data.getModelSelection().get(0));
                }
            }
        });
        return result;
    }

    protected Button createUnmapButton(Composite parent_p) {
        final Button result = new Button(parent_p, 8);
        result.setText(Messages.ElementMappingDialog_Unmap);
        result.setEnabled(false);
        this._data.addPropertyChangeListener(new IPropertyChangeListener(){

            public void propertyChange(PropertyChangeEvent event_p) {
                boolean enable = false;
                if ("pattern_selection_property".equals(event_p.getProperty()) || "mapping_property".equals(event_p.getProperty())) {
                    boolean bl = enable = enable || !ElementMappingDialog.this._data.getPatternSelection().isEmpty() && this.oneIsMapped(ElementMappingDialog.this._data.getPatternSelection(), true);
                }
                if ("model_selection_property".equals(event_p.getProperty()) || "mapping_property".equals(event_p.getProperty())) {
                    enable = enable || !ElementMappingDialog.this._data.getModelSelection().isEmpty() && this.oneIsMapped(ElementMappingDialog.this._data.getModelSelection(), false);
                }
                result.setEnabled(enable);
            }

            private boolean oneIsMapped(List<EObject> elements_p, boolean fromPattern_p) {
                for (EObject element : elements_p) {
                    if (!ElementMappingDialog.this._data.isMapped(element, fromPattern_p)) continue;
                    return true;
                }
                return false;
            }
        });
        result.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent event_p) {
                List<EObject> toUnmap = ElementMappingDialog.this._data.isActiveSelectionInPattern() ? ElementMappingDialog.this._data.getPatternSelection() : ElementMappingDialog.this._data.getModelSelection();
                ElementMappingDialog.this._data.unmap(toUnmap);
            }
        });
        return result;
    }

    public IElementMappingLocation getResult() {
        BasicElementMappingLocation result = new BasicElementMappingLocation();
        EMap<EObject, EObject> map = this._data.getPatternToModelMap();
        for (Map.Entry entry : map.entrySet()) {
            EObject templateElement = (EObject)entry.getKey();
            EObject modelElement = (EObject)entry.getValue();
            result.map(templateElement, modelElement);
        }
        return result;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    protected static class ElementMappingSpecification {
        private static final String PROPERTY_MAPPING = "mapping_property";
        private static final String PROPERTY_PATTERN_SELECTION = "pattern_selection_property";
        private static final String PROPERTY_MODEL_SELECTION = "model_selection_property";
        private final List<EObject> _modelElements;
        private final List<EObject> _patternElements;
        private final EMap<EObject, EObject> _patternToModel;
        private final EMap<EObject, EObject> _modelToPattern;
        private List<EObject> _patternSelection;
        private List<EObject> _modelSelection;
        private boolean _activeSelectionInPattern;
        private final Set<IPropertyChangeListener> _listeners;

        public ElementMappingSpecification(Collection<? extends EObject> patternElements_p, Collection<? extends EObject> modelElements_p) {
            this._patternElements = Collections.unmodifiableList(new FArrayList(patternElements_p, null));
            this._modelElements = Collections.unmodifiableList(new FArrayList(modelElements_p, null));
            this._patternToModel = new FHashMap();
            this._modelToPattern = new FHashMap();
            this._listeners = new HashSet<IPropertyChangeListener>();
            this._patternSelection = new FArrayList();
            this._modelSelection = new FArrayList();
            this._patternSelection = Collections.emptyList();
            this._modelSelection = Collections.emptyList();
            this._activeSelectionInPattern = true;
        }

        public void addPropertyChangeListener(IPropertyChangeListener listener_p) {
            this._listeners.add(listener_p);
        }

        protected boolean doUnmap(EObject element_p) {
            EObject removedModel;
            EObject removedPattern = (EObject)this._modelToPattern.removeKey((Object)element_p);
            if (removedPattern != null) {
                this._patternToModel.removeKey((Object)removedPattern);
            }
            if ((removedModel = (EObject)this._patternToModel.removeKey((Object)element_p)) != null) {
                this._modelToPattern.removeKey((Object)removedModel);
            }
            return removedModel != null || removedPattern != null;
        }

        public List<EObject> getModelElements() {
            return this._modelElements;
        }

        public List<EObject> getModelSelection() {
            return Collections.unmodifiableList(this._modelSelection);
        }

        public EMap<EObject, EObject> getModelToPatternMap() {
            return ECollections.unmodifiableEMap(this._modelToPattern);
        }

        public List<EObject> getPatternElements() {
            return this._patternElements;
        }

        public List<EObject> getPatternSelection() {
            return Collections.unmodifiableList(this._patternSelection);
        }

        public EMap<EObject, EObject> getPatternToModelMap() {
            return ECollections.unmodifiableEMap(this._patternToModel);
        }

        public boolean isActiveSelectionInPattern() {
            return this._activeSelectionInPattern;
        }

        public boolean isMapped(EObject element_p, boolean fromPattern_p) {
            boolean result = fromPattern_p ? this._patternToModel.get((Object)element_p) != null : this._modelToPattern.get((Object)element_p) != null;
            return result;
        }

        public void map(EObject patternElement_p, EObject modelElement_p) {
            this.doUnmap(patternElement_p);
            this.doUnmap(modelElement_p);
            this._patternToModel.put((Object)patternElement_p, (Object)modelElement_p);
            this._modelToPattern.put((Object)modelElement_p, (Object)patternElement_p);
            this.notify(PROPERTY_MAPPING);
        }

        protected void notify(String property_p) {
            PropertyChangeEvent event = new PropertyChangeEvent((Object)this, property_p, null, null);
            for (IPropertyChangeListener listener : this._listeners) {
                listener.propertyChange(event);
            }
        }

        public void unmap(Collection<EObject> elements_p) {
            boolean modified = false;
            for (EObject element : elements_p) {
                boolean bl = modified = modified || this.doUnmap(element);
            }
            if (modified) {
                this.notify(PROPERTY_MAPPING);
            }
        }

        public void updateModelSelection(IStructuredSelection selection_p) {
            this._modelSelection = selection_p == null ? Collections.emptyList() : selection_p.toList();
            this._activeSelectionInPattern = false;
            this.notify(PROPERTY_MODEL_SELECTION);
        }

        public void updatePatternSelection(IStructuredSelection selection_p) {
            this._patternSelection = selection_p == null ? Collections.emptyList() : selection_p.toList();
            this._activeSelectionInPattern = true;
            this.notify(PROPERTY_PATTERN_SELECTION);
        }
    }
}

