/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.diffmerge.patterns.ui.viewers;

import java.util.Collection;
import org.eclipse.emf.common.util.TreeIterator;
import org.eclipse.emf.diffmerge.api.IComparison;
import org.eclipse.emf.diffmerge.api.IMatch;
import org.eclipse.emf.diffmerge.api.Role;
import org.eclipse.emf.diffmerge.api.diff.IAttributeValuePresence;
import org.eclipse.emf.diffmerge.api.diff.IDifference;
import org.eclipse.emf.diffmerge.api.diff.IReferenceValuePresence;
import org.eclipse.emf.diffmerge.patterns.templates.engine.diffmerge.TemplatePatternApplicationComparison;
import org.eclipse.emf.diffmerge.patterns.templates.engine.diffmerge.TemplatePatternComparison;
import org.eclipse.emf.diffmerge.patterns.ui.util.UIUtil;
import org.eclipse.emf.diffmerge.patterns.ui.viewers.ModelSubsetViewer;
import org.eclipse.emf.diffmerge.util.structures.FOrderedSet;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EReference;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.widgets.Composite;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ComparisonViewer
extends ModelSubsetViewer {
    private IComparison _comparison;

    public ComparisonViewer(Composite parent_p, boolean multipleSelection_p, boolean showParents_p) {
        super(parent_p, multipleSelection_p, showParents_p);
    }

    protected IComparison getComparison() {
        return this._comparison;
    }

    @Override
    protected Color getForegroundColor(EObject element_p, Color defaultColor_p) {
        Color result = this.hasBeenAdded(element_p) ? UIUtil.getColor(9) : (this.hasBeenRemoved(element_p) ? UIUtil.getColor(3) : (this.hasBeenModified(element_p) ? UIUtil.getColor(12) : super.getForegroundColor(element_p, defaultColor_p)));
        return result;
    }

    @Override
    protected Object getParent(Object element_p) {
        Object result = null;
        if (element_p instanceof EObject) {
            IMatch containerMatch;
            EObject element = (EObject)element_p;
            IMatch match = this._comparison.getMapping().getMatchFor(element, Role.REFERENCE);
            if (match != null && match.isPartial() && (containerMatch = this._comparison.getContainerOf(match, Role.REFERENCE)) != null && !containerMatch.isPartial()) {
                result = containerMatch.get(Role.TARGET);
            }
        }
        if (result == null) {
            result = super.getParent(element_p);
        }
        return result;
    }

    @Override
    protected String getText(EObject element_p, String defaultText_p) {
        String result = defaultText_p;
        if (result != null) {
            if (this.hasBeenAdded(element_p)) {
                result = "+ " + defaultText_p;
            } else if (this.hasBeenRemoved(element_p)) {
                result = "- " + defaultText_p;
            } else if (this.hasBeenModified(element_p)) {
                result = "> " + defaultText_p;
            }
        }
        return result;
    }

    protected Collection<EObject> getValidElements(IComparison comparison_p) {
        FOrderedSet result = new FOrderedSet();
        result.addAll(comparison_p.getScope(Role.TARGET).getAllContentsAsSet());
        TreeIterator it = comparison_p.getAllContents(Role.REFERENCE);
        while (it.hasNext()) {
            IMatch match = (IMatch)it.next();
            if (!match.isPartial()) continue;
            result.add(match.get(Role.REFERENCE));
        }
        return result;
    }

    protected boolean hasBeenAdded(EObject element_p) {
        boolean result = false;
        IMatch match = this._comparison.getMapping().getMatchFor(element_p, TemplatePatternApplicationComparison.getApplicationRole());
        if (match != null) {
            result = match.isPartial();
        }
        return result;
    }

    protected boolean hasBeenModified(EObject element_p) {
        boolean result = false;
        IMatch match = this._comparison.getMapping().getMatchFor(element_p, TemplatePatternApplicationComparison.getApplicationRole());
        if (match != null) {
            result = !match.isPartial() && this.hasModificationDifference(match);
        }
        return result;
    }

    protected boolean hasBeenRemoved(EObject element_p) {
        boolean result = false;
        IMatch match = this._comparison.getMapping().getMatchFor(element_p, TemplatePatternComparison.getPatternRole());
        if (match != null) {
            result = match.isPartial();
        }
        return result;
    }

    protected boolean hasModificationDifference(IMatch match_p) {
        if (match_p.getOwnershipDifference(Role.TARGET) != null) {
            return true;
        }
        for (IDifference diff : match_p.getRelatedDifferences()) {
            if (!this.isModificationDifference(diff)) continue;
            return true;
        }
        return false;
    }

    protected boolean isModificationDifference(IDifference diff_p) {
        EReference ref;
        if (diff_p instanceof IAttributeValuePresence) {
            return true;
        }
        return diff_p instanceof IReferenceValuePresence && !(ref = ((IReferenceValuePresence)diff_p).getFeature()).isContainment();
    }

    @Override
    public void setInput(Object input_p) {
        if (input_p instanceof IComparison) {
            this._comparison = (IComparison)input_p;
            super.setInput(this.getValidElements(this._comparison));
        } else {
            super.setInput(input_p);
        }
    }
}

