/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.diffmerge.patterns.ui.viewers;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import org.eclipse.emf.common.util.EMap;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.common.util.UniqueEList;
import org.eclipse.emf.diffmerge.patterns.core.CorePatternsPlugin;
import org.eclipse.emf.diffmerge.patterns.core.api.IPattern;
import org.eclipse.emf.diffmerge.patterns.core.api.IPatternInstance;
import org.eclipse.emf.diffmerge.patterns.core.api.IPatternRepository;
import org.eclipse.emf.diffmerge.patterns.core.api.IPatternSymbol;
import org.eclipse.emf.diffmerge.patterns.core.api.ext.IPatternSupport;
import org.eclipse.emf.diffmerge.patterns.diagrams.PatternCoreDiagramPlugin;
import org.eclipse.emf.diffmerge.patterns.diagrams.misc.UnresolvedElement;
import org.eclipse.emf.diffmerge.patterns.diagrams.misc.UnresolvedPattern;
import org.eclipse.emf.diffmerge.patterns.diagrams.misc.UnresolvedRepository;
import org.eclipse.emf.diffmerge.patterns.diagrams.util.AbstractDiagramUtil;
import org.eclipse.emf.diffmerge.patterns.templates.gen.templatepatterns.TemplatePattern;
import org.eclipse.emf.diffmerge.patterns.ui.Messages;
import org.eclipse.emf.diffmerge.patterns.ui.PatternsUIPlugin;
import org.eclipse.emf.diffmerge.patterns.ui.factories.IPatternDialogAndWizardFactory;
import org.eclipse.emf.diffmerge.patterns.ui.providers.DiscriminatingLabelProvider;
import org.eclipse.emf.diffmerge.patterns.ui.providers.NameBasedLabelProvider;
import org.eclipse.emf.diffmerge.patterns.ui.util.UIUtil;
import org.eclipse.emf.diffmerge.patterns.ui.wizards.PatternWizardDialog;
import org.eclipse.emf.diffmerge.patterns.ui.wizards.browsing.AbstractPatternBrowsingWizard;
import org.eclipse.emf.diffmerge.structures.common.FArrayList;
import org.eclipse.emf.diffmerge.structures.common.FHashMap;
import org.eclipse.emf.diffmerge.structures.common.FOrderedSet;
import org.eclipse.emf.diffmerge.util.ModelsUtil;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IToolBarManager;
import org.eclipse.jface.action.MenuManager;
import org.eclipse.jface.resource.JFaceResources;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ILabelProvider;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.ISelectionProvider;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.ITreeContentProvider;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.swt.custom.CLabel;
import org.eclipse.swt.events.MouseEvent;
import org.eclipse.swt.events.MouseListener;
import org.eclipse.swt.events.PaintEvent;
import org.eclipse.swt.events.PaintListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.graphics.FontData;
import org.eclipse.swt.graphics.GC;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.layout.FormAttachment;
import org.eclipse.swt.layout.FormData;
import org.eclipse.swt.layout.FormLayout;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Menu;
import org.eclipse.swt.widgets.MenuItem;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Tree;
import org.eclipse.ui.IActionBars;
import org.eclipse.ui.part.ViewPart;
import org.eclipse.ui.views.properties.tabbed.TabbedPropertySheetWidgetFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class AbstractInstanceExplorerView
extends ViewPart {
    protected TreeViewer _viewer;
    protected TabbedPropertyTitle _header;
    private static final String DEFAULT_TITLE = Messages.InstanceExplorerView_NotAvailable;
    protected List<IPatternInstance> _instanceList;
    protected List<IPatternInstance> _initialSelection;
    protected EObject _referenceElement = null;
    protected EObject _contextElement = null;
    protected IPatternDialogAndWizardFactory _dialogAndWizardFactory = PatternsUIPlugin.getDefault().getDialogAndWizardFactory();
    protected AbstractDiagramUtil _diagramUtil = PatternCoreDiagramPlugin.getDefault().getDiagramUtilityClass();

    public AbstractInstanceExplorerView() {
        this._instanceList = new FOrderedSet();
        this._initialSelection = new FOrderedSet();
    }

    public void createPartControl(Composite parent_p) {
        GridLayout layout = new GridLayout(1, false);
        layout.marginHeight = 0;
        layout.marginWidth = 0;
        layout.verticalSpacing = 0;
        layout.horizontalSpacing = 0;
        parent_p.setLayout((Layout)layout);
        this._header = new TabbedPropertyTitle(parent_p, new TabbedPropertySheetWidgetFactory());
        GridData titleLayoutData = new GridData(768);
        titleLayoutData.grabExcessVerticalSpace = false;
        this._header.setLayoutData(titleLayoutData);
        this._header.setTitle(DEFAULT_TITLE, null);
        this._viewer = new TreeViewer(parent_p);
        this._viewer.getTree().setLayoutData((Object)new GridData(4, 4, true, true));
        this._viewer.setLabelProvider((IBaseLabelProvider)this.getLabelProvider());
        this._viewer.setContentProvider((IContentProvider)new InstanceExplorerContentProvider());
        this.createContextMenu(this._viewer);
        this.createMouseActions(this._viewer.getTree());
        this.createToolbarActions();
        this.getViewSite().setSelectionProvider((ISelectionProvider)this._viewer);
    }

    public abstract void setInput(ISelection var1);

    private void createToolbarActions() {
        IActionBars actionBars = this.getViewSite().getActionBars();
        IToolBarManager toolbarManager = actionBars.getToolBarManager();
        toolbarManager.add((IAction)new Action(Messages.InstanceExplorerView_Refresh, PatternsUIPlugin.getDefault().getImageDescriptor(PatternsUIPlugin.ImageID.REFRESH)){

            public void run() {
                AbstractInstanceExplorerView.this.refreshCurrent();
            }
        });
    }

    public void refreshCurrent() {
        if (this._contextElement != null) {
            Collection<IPatternInstance> instances = AbstractInstanceExplorerView.getAllInstances(this._contextElement);
            this._instanceList.clear();
            this._instanceList.addAll(instances);
            this._viewer.setInput(this._instanceList);
        } else {
            this._viewer.setInput(this._viewer.getInput());
        }
    }

    private void createContextMenu(TreeViewer viewer_p) {
        Menu treeMenu = new Menu((Control)this.getShell());
        this.createMenuItems(treeMenu);
        final MenuManager menuManager = new MenuManager(Messages.InstanceExplorerView_General, null);
        viewer_p.addSelectionChangedListener(new ISelectionChangedListener(){

            public void selectionChanged(SelectionChangedEvent event_p) {
                boolean enable = true;
                List<Object> selection = AbstractInstanceExplorerView.this.getSelection();
                for (Object selected : selection) {
                    if (selected instanceof EObject) continue;
                    enable = false;
                    break;
                }
                menuManager.getMenu().getParentItem().setEnabled(enable);
            }
        });
        this.getSite().registerContextMenu(menuManager, (ISelectionProvider)viewer_p);
        menuManager.fill(treeMenu, -1);
        viewer_p.getTree().setMenu(treeMenu);
    }

    private void createMenuItems(Menu menu_p) {
        this.createOpenBrowseMenuItem(menu_p);
        this.createManageInstancesMenuItem(menu_p);
    }

    private MenuItem createOpenBrowseMenuItem(Menu menu_p) {
        final MenuItem result = new MenuItem(menu_p, 0);
        result.setText(Messages.InstanceExplorerView_OpenBrowse);
        this._viewer.addSelectionChangedListener(new ISelectionChangedListener(){

            public void selectionChanged(SelectionChangedEvent event_p) {
                if (AbstractInstanceExplorerView.this.selectionContainsUnresolved()) {
                    result.setEnabled(true);
                } else {
                    boolean enable = false;
                    List<Object> selection = AbstractInstanceExplorerView.this.getSelection();
                    if (selection.size() == 1) {
                        Object selected = selection.get(0);
                        enable = selected instanceof TemplatePattern || selected instanceof IPatternRepository;
                    }
                    result.setEnabled(enable);
                }
            }
        });
        result.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e_p) {
                List<Object> selection = AbstractInstanceExplorerView.this.getSelection();
                if (!selection.isEmpty()) {
                    Object selected = selection.get(0);
                    if (AbstractInstanceExplorerView.this.selectionContainsUnresolved()) {
                        AbstractInstanceExplorerView.this.resolveSelection();
                    } else if (selected instanceof IPatternRepository) {
                        AbstractInstanceExplorerView.this.browseRepository((IPatternRepository)selected);
                    } else if (selected instanceof TemplatePattern) {
                        AbstractInstanceExplorerView.this.browsePattern((TemplatePattern)selected);
                    }
                }
            }
        });
        return result;
    }

    protected void browsePattern(TemplatePattern pattern_p) {
        IPatternInstance first = this._instanceList.isEmpty() ? null : this._instanceList.get(0);
        EObject context = first instanceof EObject ? (EObject)first : null;
        AbstractPatternBrowsingWizard wizard = this.instantiatePatternBrowsingWizard(context, pattern_p);
        PatternWizardDialog dialog = new PatternWizardDialog(this.getShell(), wizard, true, null);
        dialog.open();
        if (wizard.repositoryRegistryChanged()) {
            this.refreshCurrent();
        }
    }

    protected void browseRepository(IPatternRepository repository_p) {
        IPatternInstance first = this._instanceList.isEmpty() ? null : this._instanceList.get(0);
        EObject context = first instanceof EObject ? (EObject)first : null;
        AbstractPatternBrowsingWizard wizard = this.instantiatePatternBrowsingWizard(context, repository_p);
        PatternWizardDialog dialog = new PatternWizardDialog(this.getShell(), wizard, true, null);
        dialog.open();
        if (wizard.repositoryRegistryChanged()) {
            this.refreshCurrent();
        }
    }

    protected AbstractPatternBrowsingWizard instantiatePatternBrowsingWizard(EObject context_p, TemplatePattern pattern_p) {
        return this._dialogAndWizardFactory.instantiatePatternBrowsingWizard(context_p, pattern_p);
    }

    protected AbstractPatternBrowsingWizard instantiatePatternBrowsingWizard(EObject context_p, IPatternRepository repository_p) {
        return this._dialogAndWizardFactory.instantiatePatternBrowsingWizard(context_p, repository_p);
    }

    protected boolean selectionContainsUnresolved() {
        List<Object> selection = this.getSelection();
        for (Object e : selection) {
            if (!(e instanceof UnresolvedElement)) continue;
            return true;
        }
        return false;
    }

    protected void resolveSelection() {
        boolean ok;
        List<IPatternInstance> instances = this.getSelectionAsInstances();
        if (!instances.isEmpty() && (ok = UIUtil.resolvePatternWithUser(this.getShell(), instances))) {
            this.refreshCurrent();
        }
    }

    protected List<IPatternInstance> getSelectionAsInstances() {
        FOrderedSet result = new FOrderedSet();
        InstanceExplorerContentProvider provider = this.getContentProvider();
        for (Object selected : this.getSelection()) {
            if (selected instanceof IPatternRepository || selected instanceof UnresolvedRepository) {
                Object[] patterns;
                Object[] objectArray = patterns = provider.getChildren(selected);
                int n = patterns.length;
                int n2 = 0;
                while (n2 < n) {
                    Object pattern = objectArray[n2];
                    List<Object> instances = Arrays.asList(provider.getChildren(pattern));
                    result.addAll(instances);
                    ++n2;
                }
                continue;
            }
            if (selected instanceof IPattern || selected instanceof UnresolvedPattern) {
                List<Object> instances = Arrays.asList(provider.getChildren(selected));
                result.addAll(instances);
                continue;
            }
            if (!(selected instanceof IPatternInstance)) continue;
            result.add((IPatternInstance)selected);
        }
        return Collections.unmodifiableList(result);
    }

    protected InstanceExplorerContentProvider getContentProvider() {
        return (InstanceExplorerContentProvider)this._viewer.getContentProvider();
    }

    private MenuItem createManageInstancesMenuItem(Menu menu_p) {
        final MenuItem result = new MenuItem(menu_p, 0);
        result.setText(Messages.InstanceExplorerView_ManageInstances);
        this._viewer.addSelectionChangedListener(new ISelectionChangedListener(){

            public void selectionChanged(SelectionChangedEvent event_p) {
                boolean enable;
                List<Object> selection = AbstractInstanceExplorerView.this.getSelection();
                boolean bl = enable = !selection.isEmpty();
                if (enable) {
                    enable = false;
                    for (Object selected : selection) {
                        if (!(selected instanceof UnresolvedElement) && !(selected instanceof IPatternRepository) && !(selected instanceof IPattern) && !(selected instanceof IPatternInstance)) continue;
                        enable = true;
                        break;
                    }
                }
                result.setEnabled(enable);
            }
        });
        result.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e_p) {
                AbstractInstanceExplorerView.this.manageSelectedInstances();
            }
        });
        return result;
    }

    protected abstract void manageSelectedInstances();

    private void createMouseActions(Tree tree_p) {
        tree_p.addMouseListener(new MouseListener(){

            public void mouseUp(MouseEvent e_p) {
            }

            public void mouseDown(MouseEvent e_p) {
            }

            public void mouseDoubleClick(MouseEvent e_p) {
                List<Object> selection = AbstractInstanceExplorerView.this.getSelection();
                if (selection.size() == 1) {
                    Object selected = selection.get(0);
                    if (selected instanceof UnresolvedElement) {
                        AbstractInstanceExplorerView.this.resolveSelection();
                    } else if (selected instanceof IPatternRepository) {
                        AbstractInstanceExplorerView.this.browseRepository((IPatternRepository)selected);
                    } else if (selected instanceof TemplatePattern) {
                        AbstractInstanceExplorerView.this.browsePattern((TemplatePattern)selected);
                    } else if (selected instanceof IPatternInstance) {
                        AbstractInstanceExplorerView.this.manageSelectedInstances();
                    }
                }
            }
        });
    }

    protected static Collection<IPatternInstance> getAllInstances(EObject context_p) {
        IPatternSupport support = CorePatternsPlugin.getDefault().getPatternSupportFor(context_p);
        Collection<Object> result = support == null ? Collections.emptySet() : support.getAllInstances((Object)context_p);
        return result;
    }

    protected static Collection<IPatternInstance> getAllRelatedInstances(EObject context_p) {
        IPatternSupport support = CorePatternsPlugin.getDefault().getPatternSupportFor(context_p);
        Collection<Object> result = support == null ? Collections.emptySet() : support.getRelatedInstances(context_p);
        return result;
    }

    protected Shell getShell() {
        return this.getSite().getShell();
    }

    public void setFocus() {
        this._viewer.getControl().setFocus();
    }

    protected ILabelProvider getLabelProvider() {
        return DiscriminatingLabelProvider.getInstance();
    }

    protected List<Object> getSelection() {
        return ((IStructuredSelection)this._viewer.getSelection()).toList();
    }

    protected void updateHeader() {
        URI uri;
        String newHeader = DEFAULT_TITLE;
        if (this._contextElement != null && this._contextElement.eResource() != null && (uri = this._contextElement.eResource().getURI()) != null) {
            newHeader = String.valueOf(Messages.InstanceExplorerView_Instances) + uri.lastSegment();
        }
        this._header.setTitle(newHeader, null);
    }

    public TreeViewer getViewer() {
        return this._viewer;
    }

    protected Collection<?> toActualSelection(Object selected_p) {
        return this._diagramUtil.toActualSelection(selected_p);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    protected class InstanceExplorerContentProvider
    implements ITreeContentProvider {
        private final EMap<IPatternRepository, List<IPattern>> _repositoriesToPatterns = new FHashMap();
        private final EMap<IPattern, List<IPatternInstance>> _patternsToInstances = new FHashMap();
        private final EMap<IPatternInstance, UnresolvedPattern> _instancesToUnresolvedPatterns;
        private final UniqueEList<UnresolvedRepository> _unresolvedRepositories = new UniqueEList();

        public InstanceExplorerContentProvider() {
            this._instancesToUnresolvedPatterns = new FHashMap();
        }

        private void clear() {
            this._repositoriesToPatterns.clear();
            this._patternsToInstances.clear();
            this._instancesToUnresolvedPatterns.clear();
            this._unresolvedRepositories.clear();
        }

        public void dispose() {
            this.clear();
        }

        public Object[] getChildren(Object parentElement_p) {
            List result = null;
            if (parentElement_p instanceof IPatternRepository) {
                result = (List)this._repositoriesToPatterns.get(parentElement_p);
            } else if (parentElement_p instanceof IPattern) {
                result = (List)this._patternsToInstances.get(parentElement_p);
            } else if (parentElement_p instanceof UnresolvedRepository) {
                result = ((UnresolvedRepository)parentElement_p).getUnresolvedPatterns();
            } else if (parentElement_p instanceof UnresolvedPattern) {
                result = ((UnresolvedPattern)parentElement_p).getReferringInstances();
            } else if (parentElement_p instanceof IPatternInstance) {
                List allInstanceElements = ((IPatternInstance)parentElement_p).getElements();
                result = ModelsUtil.getRoots((Collection)allInstanceElements);
            }
            if (result != null) {
                UIUtil.LabelBasedComparator comparator = new UIUtil.LabelBasedComparator(AbstractInstanceExplorerView.this.getLabelProvider());
                result = new FArrayList((Collection)result, null);
                Collections.sort(result, comparator);
            }
            return result != null ? result.toArray() : new Object[]{};
        }

        public Object[] getElements(Object inputElement_p) {
            FArrayList result = new FArrayList();
            result.addAll(this._repositoriesToPatterns.keySet());
            result.addAll(this._unresolvedRepositories);
            UIUtil.LabelBasedComparator comparator = new UIUtil.LabelBasedComparator((ILabelProvider)NameBasedLabelProvider.getInstance());
            Collections.sort(result, comparator);
            return result.toArray();
        }

        public Object getParent(Object element_p) {
            Object result;
            if (element_p instanceof IPatternRepository || element_p instanceof UnresolvedRepository) {
                result = null;
            } else if (element_p instanceof IPattern) {
                result = ((IPattern)element_p).getRepository();
            } else if (element_p instanceof UnresolvedPattern) {
                result = ((UnresolvedPattern)element_p).getUnresolvedRepository();
            } else if (element_p instanceof IPatternInstance) {
                result = ((IPatternInstance)element_p).getPattern();
                if (result == null) {
                    result = this._instancesToUnresolvedPatterns.get(element_p);
                }
            } else {
                result = null;
            }
            return result;
        }

        public boolean hasChildren(Object element_p) {
            boolean result = element_p instanceof UnresolvedRepository || element_p instanceof UnresolvedPattern || element_p instanceof IPatternRepository || element_p instanceof IPattern || element_p instanceof IPatternInstance;
            return result;
        }

        private void initializeData(Collection<?> input_p) {
            for (Object inputElement : input_p) {
                if (!(inputElement instanceof IPatternInstance)) continue;
                this.initializeDataFromInstance((IPatternInstance)inputElement);
            }
        }

        private void initializeDataFromInstance(IPatternInstance instance_p) {
            IPattern pattern = instance_p.getPattern();
            if (pattern != null) {
                List instances = (List)this._patternsToInstances.get((Object)pattern);
                if (instances == null) {
                    instances = new FOrderedSet();
                    this._patternsToInstances.put((Object)pattern, (Object)instances);
                }
                instances.add(instance_p);
                IPatternRepository repository = pattern.getRepository();
                assert (repository != null);
                List patterns = (List)this._repositoriesToPatterns.get((Object)repository);
                if (patterns == null) {
                    patterns = new FOrderedSet();
                    this._repositoriesToPatterns.put((Object)repository, (Object)patterns);
                }
                patterns.add(pattern);
            } else {
                IPatternSymbol symbol = instance_p.getPatternVersion().getPatternSymbol();
                UnresolvedRepository uRepository = new UnresolvedRepository(symbol.getLastPath(), symbol.getRepositoryId());
                int pos = this._unresolvedRepositories.indexOf((Object)uRepository);
                if (pos >= 0) {
                    uRepository = (UnresolvedRepository)this._unresolvedRepositories.get(pos);
                } else {
                    this._unresolvedRepositories.add((Object)uRepository);
                }
                UnresolvedPattern uPattern = new UnresolvedPattern(symbol.getName(), symbol.getPatternId(), uRepository);
                pos = uRepository.getUnresolvedPatterns().indexOf(uPattern);
                if (pos >= 0) {
                    uPattern = (UnresolvedPattern)uRepository.getUnresolvedPatterns().get(pos);
                } else {
                    uRepository.getUnresolvedPatterns().add(uPattern);
                }
                uPattern.getReferringInstances().add(instance_p);
                this._instancesToUnresolvedPatterns.put((Object)instance_p, (Object)uPattern);
            }
        }

        public void inputChanged(Viewer viewer_p, Object oldInput_p, Object newInput_p) {
            this.clear();
            if (newInput_p instanceof Collection) {
                this.initializeData((Collection)newInput_p);
            }
        }
    }

    public class TabbedPropertyTitle
    extends Composite {
        protected CLabel label;
        protected Image image;
        protected String text;
        private static final String BLANK = "";
        private static final String TITLE_FONT = "org.eclipse.ui.internal.views.properties.tabbed.view.TabbedPropertyTitle";
        private TabbedPropertySheetWidgetFactory factory;

        public TabbedPropertyTitle(Composite parent_p, TabbedPropertySheetWidgetFactory factory_p) {
            super(parent_p, 524288);
            this.image = null;
            this.text = null;
            this.factory = factory_p;
            this.addPaintListener(new PaintListener(){

                public void paintControl(PaintEvent e) {
                    if (TabbedPropertyTitle.this.image == null && (TabbedPropertyTitle.this.text == null || TabbedPropertyTitle.this.text.equals(TabbedPropertyTitle.BLANK))) {
                        TabbedPropertyTitle.this.label.setVisible(false);
                    } else {
                        TabbedPropertyTitle.this.label.setVisible(true);
                        TabbedPropertyTitle.this.drawTitleBackground(e);
                    }
                }
            });
            factory_p.getColors().initializeSectionToolBarColors();
            this.setBackground(factory_p.getColors().getBackground());
            this.setForeground(factory_p.getColors().getForeground());
            FormLayout layout = new FormLayout();
            layout.marginWidth = 1;
            layout.marginHeight = 2;
            this.setLayout((Layout)layout);
            if (!JFaceResources.getFontRegistry().hasValueFor(TITLE_FONT)) {
                FontData[] fontData = JFaceResources.getHeaderFont().getFontData();
                fontData[0].setHeight(10);
                JFaceResources.getFontRegistry().put(TITLE_FONT, fontData);
            }
            Font font = JFaceResources.getFont((String)TITLE_FONT);
            this.label = factory_p.createCLabel((Composite)this, BLANK);
            this.label.setBackground(new Color[]{factory_p.getColors().getColor("org.eclipse.ui.forms.H_GRADIENT_END"), factory_p.getColors().getColor("org.eclipse.ui.forms.H_GRADIENT_START")}, new int[]{100}, true);
            this.label.setFont(font);
            this.label.setForeground(factory_p.getColors().getColor("org.eclipse.ui.forms.TITLE"));
            FormData data = new FormData();
            data.left = new FormAttachment(0, 0);
            data.top = new FormAttachment(0, 0);
            data.right = new FormAttachment(100, 0);
            data.bottom = new FormAttachment(100, 0);
            this.label.setLayoutData((Object)data);
        }

        protected void drawTitleBackground(PaintEvent e) {
            Rectangle bounds = this.getClientArea();
            this.label.setBackground(new Color[]{this.factory.getColors().getColor("org.eclipse.ui.forms.H_GRADIENT_END"), this.factory.getColors().getColor("org.eclipse.ui.forms.H_GRADIENT_START")}, new int[]{100}, true);
            Color bg = this.factory.getColors().getColor("org.eclipse.ui.forms.H_GRADIENT_END");
            Color gbg = this.factory.getColors().getColor("org.eclipse.ui.forms.H_GRADIENT_START");
            GC gc = e.gc;
            gc.setForeground(bg);
            gc.setBackground(gbg);
            gc.fillGradientRectangle(bounds.x, bounds.y, bounds.width, bounds.height, true);
            gc.setForeground(this.factory.getColors().getColor("org.eclipse.ui.forms.H_BOTTOM_KEYLINE1"));
            gc.drawLine(bounds.x, bounds.height - 2, bounds.x + bounds.width - 1, bounds.height - 2);
            gc.setForeground(this.factory.getColors().getColor("org.eclipse.ui.forms.H_BOTTOM_KEYLINE2"));
            gc.drawLine(bounds.x, bounds.height - 1, bounds.x + bounds.width - 1, bounds.height - 1);
        }

        public void setTitle(String text_p, Image image_p) {
            this.text = text_p;
            this.image = image_p;
            if (text_p != null) {
                this.label.setText(text_p);
            } else {
                this.label.setText(BLANK);
            }
            this.label.setImage(image_p);
            this.redraw();
        }
    }
}

