/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.diffmerge.ui.util;

import java.util.Collection;
import org.eclipse.emf.diffmerge.api.IComparison;
import org.eclipse.emf.diffmerge.api.Role;
import org.eclipse.emf.diffmerge.ui.EMFDiffMergeUIPlugin;
import org.eclipse.emf.diffmerge.ui.Messages;
import org.eclipse.jface.dialogs.IDialogConstants;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.viewers.ArrayContentProvider;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ILabelProvider;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.ListViewer;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.StructuredViewer;
import org.eclipse.jface.viewers.ViewerComparator;
import org.eclipse.swt.dnd.Clipboard;
import org.eclipse.swt.dnd.TextTransfer;
import org.eclipse.swt.dnd.Transfer;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Menu;
import org.eclipse.swt.widgets.MenuItem;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.PlatformUI;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class InconsistencyDialog
extends MessageDialog {
    protected final IComparison _comparison;

    public InconsistencyDialog(Shell shell_p, IComparison comparison_p) {
        super(shell_p, EMFDiffMergeUIPlugin.LABEL, null, Messages.InconsistencyDialog_DuplicateIDs, 4, new String[]{IDialogConstants.OK_LABEL}, 0);
        this._comparison = comparison_p;
        this.setShellStyle(this.getShellStyle() | 0x10);
    }

    protected void copySelectionAsText(StructuredViewer viewer_p) {
        IBaseLabelProvider blp;
        ISelection selection = viewer_p.getSelection();
        if (selection != null && selection instanceof IStructuredSelection && !selection.isEmpty() && (blp = viewer_p.getLabelProvider()) instanceof ILabelProvider) {
            ILabelProvider lp = (ILabelProvider)blp;
            StringBuilder builder = new StringBuilder();
            boolean first = true;
            for (Object selected : ((IStructuredSelection)selection).toList()) {
                String label;
                if (selected == null || (label = lp.getText(selected)) == null) continue;
                if (first) {
                    first = false;
                } else {
                    builder.append('\n');
                }
                builder.append(label);
            }
            this.copyTextToClipboard(builder.toString(), viewer_p.getControl().getDisplay());
        }
    }

    protected void copyTextToClipboard(String text_p, Display display_p) {
        Clipboard clipboard = new Clipboard(display_p);
        Transfer[] transfers = new Transfer[]{TextTransfer.getInstance()};
        Object[] data = new Object[]{text_p};
        clipboard.setContents(data, transfers);
        clipboard.dispose();
    }

    protected Control createCustomArea(Composite parent_p) {
        Composite result = new Composite(parent_p, 0);
        result.setLayoutData((Object)new GridData(4, 4, true, true));
        result.setLayout((Layout)new GridLayout(1, false));
        Role[] roleArray = Role.values();
        int n = roleArray.length;
        int n2 = 0;
        while (n2 < n) {
            Role role = roleArray[n2];
            Collection duplicates = this._comparison.getDuplicateMatchIDs(role);
            if (!duplicates.isEmpty()) {
                this.createDuplicateArea(result, role, duplicates);
            }
            ++n2;
        }
        return result;
    }

    protected MenuItem createCopyMenuItem(final StructuredViewer viewer_p) {
        Menu menu = new Menu(viewer_p.getControl());
        final MenuItem result = new MenuItem(menu, 8);
        result.setText(Messages.InconsistencyDialog_CopyID);
        result.setImage(PlatformUI.getWorkbench().getSharedImages().getImage("IMG_TOOL_COPY"));
        viewer_p.addSelectionChangedListener(new ISelectionChangedListener(){

            public void selectionChanged(SelectionChangedEvent event_p) {
                ISelection selection = event_p.getSelection();
                boolean enable = selection instanceof IStructuredSelection && !selection.isEmpty();
                result.setEnabled(enable);
            }
        });
        result.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e_p) {
                InconsistencyDialog.this.copySelectionAsText(viewer_p);
            }
        });
        viewer_p.getControl().setMenu(menu);
        return result;
    }

    protected Control createDuplicateArea(Composite parent_p, Role role_p, Collection<Object> duplicates_p) {
        Group group = new Group(parent_p, 0);
        group.setLayoutData((Object)new GridData(4, 4, true, true));
        group.setLayout((Layout)new GridLayout(1, false));
        String scopeName = role_p == Role.ANCESTOR ? Messages.InconsistencyDialog_AncestorScope : (role_p == Role.REFERENCE ? Messages.InconsistencyDialog_ReferenceScope : Messages.InconsistencyDialog_TargetScope);
        group.setText(scopeName);
        ListViewer viewer = new ListViewer((Composite)group, 2818);
        viewer.getControl().setLayoutData((Object)new GridData(4, 4, true, true));
        viewer.setContentProvider((IContentProvider)new ArrayContentProvider());
        viewer.setComparator(new ViewerComparator());
        this.createCopyMenuItem((StructuredViewer)viewer);
        viewer.setInput((Object)duplicates_p.toArray());
        return group;
    }
}

