/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.dirigible.ide.ui.publish;

import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IFolder;
import org.eclipse.core.resources.IProject;
import org.eclipse.dirigible.ide.common.CommonParameters;
import org.eclipse.dirigible.ide.publish.AbstractPublisher;
import org.eclipse.dirigible.ide.publish.IPublisher;
import org.eclipse.dirigible.ide.publish.PublishException;
import org.eclipse.dirigible.repository.api.ICollection;

public class WikiPublisher
extends AbstractPublisher
implements IPublisher {
    public void publish(IProject project) throws PublishException {
        try {
            ICollection targetContainer = this.getTargetProjectContainer(project, this.getRegistryLocation());
            IFolder sourceFolder = this.getSourceFolder(project, "WikiContent");
            this.copyAllFromTo((IContainer)sourceFolder, targetContainer);
        }
        catch (Exception ex) {
            throw new PublishException(ex.getMessage(), (Throwable)ex);
        }
    }

    public void activate(IProject project) throws PublishException {
        try {
            ICollection targetContainer = this.getTargetProjectContainer(project, CommonParameters.getWikiContentSandbox());
            IFolder sourceFolder = this.getSourceFolder(project, "WikiContent");
            this.copyAllFromTo((IContainer)sourceFolder, targetContainer);
        }
        catch (Exception ex) {
            throw new PublishException(ex.getMessage(), (Throwable)ex);
        }
    }

    protected String getSandboxLocation() {
        return CommonParameters.getWikiContentSandbox();
    }

    public String getFolderType() {
        return "WikiContent";
    }

    public boolean recognizedFile(IFile file) {
        return this.checkFolderType(file);
    }

    public String getPublishedContainerMapping(IFile file) {
        return "/wiki";
    }

    public String getActivatedContainerMapping(IFile file) {
        return "/wiki-sandbox";
    }

    public boolean isAutoActivationAllowed() {
        return true;
    }

    protected String getRegistryLocation() {
        return "/db/dirigible/registry/public/WikiContent";
    }
}

