/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.dirigible.ide.jgit.command.ui;

import org.eclipse.dirigible.ide.jgit.command.ui.Messages;
import org.eclipse.dirigible.ide.jgit.command.ui.PushCommandDialog;
import org.eclipse.jgit.util.StringUtils;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;

public class ShareCommandDialog
extends PushCommandDialog {
    private static final long serialVersionUID = -5124345102495879231L;
    private static final String SHARE_TO_REMOTE_GIT_REPOSITORY = Messages.ShareCommandDialog_SHARE_TO_REMOTE_GIT_REPOSITORY;
    private static final String REPOSITORY_URI = Messages.CommandDialog_REPOSITORY_URI;
    private static final String REPOSITORY_URI_IS_EMPTY = Messages.ShareCommandDialog_REPOSITORY_URI_IS_EMPTY;
    private Text textRepositoryURI;
    private String repositoryURI;

    public ShareCommandDialog(Shell parentShell) {
        super(parentShell);
    }

    @Override
    public void create() {
        super.create();
        this.setTitle(SHARE_TO_REMOTE_GIT_REPOSITORY);
    }

    @Override
    protected void addWidgets(Composite container) {
        this.createRepositoryURIField(container);
        super.addWidgets(container);
    }

    private void createRepositoryURIField(Composite container) {
        Label labelRepositoryURI = new Label(container, 0);
        labelRepositoryURI.setText(REPOSITORY_URI);
        GridData dataGitRepositoryURI = new GridData();
        dataGitRepositoryURI.grabExcessHorizontalSpace = true;
        dataGitRepositoryURI.horizontalAlignment = 4;
        this.textRepositoryURI = new Text(container, 2048);
        this.textRepositoryURI.setLayoutData((Object)dataGitRepositoryURI);
    }

    @Override
    protected boolean validateInput() {
        boolean valid = false;
        if (super.validateInput()) {
            if (StringUtils.isEmptyOrNull((String)this.textRepositoryURI.getText())) {
                this.errorMessage = REPOSITORY_URI_IS_EMPTY;
            } else {
                valid = true;
            }
        }
        return valid;
    }

    @Override
    protected void saveInput() {
        super.saveInput();
        this.repositoryURI = this.textRepositoryURI.getText();
    }

    public String getRepositoryURI() {
        return this.repositoryURI;
    }
}

