/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.dirigible.runtime.chrome.debugger.communication;

import com.google.gson.Gson;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.websocket.Session;
import org.eclipse.dirigible.runtime.chrome.debugger.DebugConfiguration;
import org.eclipse.dirigible.runtime.chrome.debugger.communication.MessageRequest;
import org.eclipse.dirigible.runtime.chrome.debugger.models.Breakpoint;
import org.eclipse.dirigible.runtime.chrome.debugger.models.Location;
import org.eclipse.dirigible.runtime.chrome.debugger.processing.BreakpointRepository;
import org.eclipse.dirigible.runtime.chrome.debugger.processing.MessageDispatcher;
import org.eclipse.dirigible.runtime.chrome.debugger.processing.ScriptRepository;
import org.eclipse.dirigible.runtime.chrome.debugger.utils.ScriptUtils;

public class DebuggerPausedRequest
extends MessageRequest {
    private static Integer currentObjectId = 1;

    public DebuggerPausedRequest() {
        this.id = null;
        this.method = "Debugger.paused";
    }

    public static synchronized void sendRequest(Session session) {
        Location location = DebugConfiguration.getCurrentExecutionLocation(session.getUserPrincipal().getName());
        String scriptId = location.getScriptId();
        int breakpointLine = location.getLineNumber().intValue();
        DebuggerPausedRequest.sendRequest(scriptId, session, breakpointLine);
    }

    public static void sendRequest(String scriptId, Session session, Integer breakpointLine) {
        DebuggerPausedRequest debuggerPausedRequest = new DebuggerPausedRequest();
        HashMap<String, Object> params = new HashMap<String, Object>();
        Location startLocation = ScriptUtils.getStartLocation(scriptId, breakpointLine);
        ArrayList<CallFrame> callFrames = new ArrayList<CallFrame>();
        CallFrame callFrame = new CallFrame();
        callFrame.setFunctionLocation(startLocation);
        String userId = session.getUserPrincipal().getName();
        callFrame.setLocation(DebugConfiguration.getCurrentExecutionLocation(userId));
        int ordinal = 0;
        ArrayList<Scope> scopeChain = new ArrayList<Scope>();
        Scope scope = new Scope();
        scope.setEndLocation(ScriptUtils.getEndLocation(scriptId, breakpointLine));
        scope.setStartLocation(startLocation);
        scope.setEndLocation(ScriptUtils.getEndLocation(scriptId, breakpointLine));
        HashMap<String, String> object = new HashMap<String, String>();
        object.put("className", "Object");
        object.put("description", "Object");
        Object[] objectArray = new Object[2];
        objectArray[0] = 0;
        Integer n = currentObjectId;
        currentObjectId = n + 1;
        objectArray[1] = n;
        object.put("objectId", String.format("{\"injectedScriptId\":%d,\"id\":%d", objectArray));
        object.put("type", "object");
        scope.setObject(object);
        scope.setType("local");
        scopeChain.add(scope);
        callFrame.setCallFrameId(String.format("{\"ordinal\":%d,\"injectedScriptId\":%d}", ordinal, 0));
        callFrame.setScopeChain(scopeChain);
        callFrame.setFunctionName(ScriptUtils.getEnclosingFunctionName(scriptId, breakpointLine));
        callFrames.add(callFrame);
        params.put("callFrames", callFrames);
        DebuggerPausedRequest.persistFrames(callFrames);
        BreakpointRepository breakpointRepo = BreakpointRepository.getInstance();
        Set<Breakpoint> breakpoints = breakpointRepo.getSortedBreakpointsForScript(userId, scriptId);
        Breakpoint firstBreakpoint = breakpoints.toArray(new Breakpoint[breakpoints.size()])[0];
        ArrayList<String> hitBreakpoints = new ArrayList<String>();
        hitBreakpoints.add(firstBreakpoint.getId());
        params.put("hitBreakpoints", hitBreakpoints);
        params.put("reason", "other");
        debuggerPausedRequest.setParams(params);
        MessageDispatcher.sendMessage(new Gson().toJson((Object)debuggerPausedRequest), session);
    }

    private static void persistFrames(List<CallFrame> callFrames) {
        ScriptRepository scriptRepo = ScriptRepository.getInstance();
        for (CallFrame frame : callFrames) {
            scriptRepo.addFrame(frame);
        }
    }

    public static class CallFrame {
        private String callFrameId;
        private Location functionLocation;
        private String functionName;
        private Location location;
        private List<Scope> scopeChain;

        public String getCallFrameId() {
            return this.callFrameId;
        }

        public void setCallFrameId(String callFrameId) {
            this.callFrameId = callFrameId;
        }

        public Location getFunctionLocation() {
            return this.functionLocation;
        }

        public void setFunctionLocation(Location functionLocation) {
            this.functionLocation = functionLocation;
        }

        public String getFunctionName() {
            return this.functionName;
        }

        public void setFunctionName(String functionName) {
            this.functionName = functionName;
        }

        public Location getLocation() {
            return this.location;
        }

        public void setLocation(Location location) {
            this.location = location;
        }

        public List<Scope> getScopeChain() {
            return this.scopeChain;
        }

        public void setScopeChain(List<Scope> scopeChain) {
            this.scopeChain = scopeChain;
        }
    }

    public static class Scope {
        private String type;
        private Map<String, String> object;
        private Location startLocation;
        private Location endLocation;

        public String getType() {
            return this.type;
        }

        public void setType(String type) {
            this.type = type;
        }

        public Map<String, String> getObject() {
            return this.object;
        }

        public void setObject(Map<String, String> object) {
            this.object = object;
        }

        public Location getStartLocation() {
            return this.startLocation;
        }

        public void setStartLocation(Location startLocation) {
            this.startLocation = startLocation;
        }

        public Location getEndLocation() {
            return this.endLocation;
        }

        public void setEndLocation(Location endLocation) {
            this.endLocation = endLocation;
        }
    }
}

