/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ease.lang.javascript.rhino;

import java.io.IOException;
import java.io.InputStreamReader;
import java.io.Reader;
import java.net.URL;
import java.security.AccessController;
import java.security.PrivilegedAction;
import java.util.AbstractMap;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.eclipse.ease.AbstractScriptEngine;
import org.eclipse.ease.FileTrace;
import org.eclipse.ease.IScriptEngine;
import org.eclipse.ease.Script;
import org.eclipse.ease.lang.javascript.JavaScriptHelper;
import org.eclipse.ease.lang.javascript.rhino.ObservingContextFactory;
import org.eclipse.ease.lang.javascript.rhino.RhinoClassLoader;
import org.eclipse.ease.lang.javascript.rhino.debugger.LineNumberDebugger;
import org.eclipse.ease.tools.RunnableWithResult;
import org.eclipse.swt.widgets.Display;
import org.mozilla.javascript.Context;
import org.mozilla.javascript.ContextFactory;
import org.mozilla.javascript.NativeFunction;
import org.mozilla.javascript.NativeJavaObject;
import org.mozilla.javascript.ScriptRuntime;
import org.mozilla.javascript.Scriptable;
import org.mozilla.javascript.ScriptableObject;
import org.mozilla.javascript.Undefined;
import org.mozilla.javascript.WrappedException;
import org.mozilla.javascript.debug.Debugger;

public class RhinoScriptEngine
extends AbstractScriptEngine {
    protected ScriptableObject mScope;
    private Context mContext;
    private Debugger mDebugger = null;
    private int mOptimizationLevel = 9;
    private boolean mCreateLineNumberInformation = false;

    static {
        ContextFactory.initGlobal((ContextFactory)new ObservingContextFactory());
        AccessController.doPrivileged(new PrivilegedAction<Object>(){

            @Override
            public Object run() {
                ContextFactory.getGlobal().initApplicationClassLoader((ClassLoader)new RhinoClassLoader());
                return null;
            }
        });
    }

    public RhinoScriptEngine() {
        super("Rhino");
    }

    protected RhinoScriptEngine(String name) {
        super(name);
    }

    public void setOptimizationLevel(int level) {
        this.mOptimizationLevel = level;
    }

    protected synchronized boolean setupEngine() {
        this.mContext = this.getContext();
        if (this.mDebugger != null) {
            this.mContext.setOptimizationLevel(-1);
            this.mContext.setGeneratingDebug(true);
            this.mContext.setGeneratingSource(true);
            this.mContext.setDebugger(this.mDebugger, null);
        } else if (this.mCreateLineNumberInformation) {
            this.mContext.setOptimizationLevel(-1);
            this.mContext.setGeneratingDebug(true);
            this.mContext.setDebugger((Debugger)new LineNumberDebugger(), null);
        } else {
            this.mContext.setGeneratingDebug(false);
            this.mContext.setOptimizationLevel(this.mOptimizationLevel);
            this.mContext.setDebugger(null, null);
        }
        this.mScope = this.mContext.initStandardObjects();
        this.mContext.setGenerateObserverCount(true);
        this.mContext.setInstructionObserverThreshold(10);
        return true;
    }

    protected synchronized boolean teardownEngine() {
        Context.exit();
        RhinoClassLoader.unregisterEngine(this);
        return true;
    }

    protected Object execute(final Script script, final Object reference, final String fileName, boolean uiThread) throws Exception {
        if (uiThread) {
            RunnableWithResult<Map.Entry<Object, Exception>> runnable = new RunnableWithResult<Map.Entry<Object, Exception>>(){

                public void run() {
                    RhinoScriptEngine.this.getContext().initStandardObjects(RhinoScriptEngine.this.getScope());
                    try {
                        this.setResult(new AbstractMap.SimpleEntry<Object, Object>(RhinoScriptEngine.this.internalExecute(script, reference, fileName), null));
                    }
                    catch (Exception e) {
                        this.setResult(new AbstractMap.SimpleEntry<Object, Exception>(null, e));
                    }
                }
            };
            Display.getDefault().syncExec((Runnable)runnable);
            Map.Entry result = (Map.Entry)runnable.getResult();
            if (result.getValue() != null) {
                throw (Exception)result.getValue();
            }
            return result.getKey();
        }
        return this.internalExecute(script, reference, fileName);
    }

    /*
     * Loose catch block
     */
    private Object internalExecute(Script script, Object reference, String fileName) throws Exception {
        Object result;
        InputStreamReader codeReader;
        block22: {
            block21: {
                ((ObservingContextFactory)ContextFactory.getGlobal()).cancelTerminate(this.getContext());
                codeReader = new InputStreamReader(script.getCodeStream());
                result = script.getCommand() instanceof NativeFunction ? ((NativeFunction)script.getCommand()).call(this.getContext(), (Scriptable)this.getScope(), (Scriptable)this.getScope(), ScriptRuntime.emptyArgs) : (script.getCommand() instanceof org.mozilla.javascript.Script ? ((org.mozilla.javascript.Script)script.getCommand()).exec(this.getContext(), (Scriptable)this.getScope()) : this.getContext().evaluateReader((Scriptable)this.getScope(), (Reader)codeReader, fileName, 1, null));
                if (!(result instanceof Undefined)) break block21;
                try {
                    if (codeReader != null) {
                        codeReader.close();
                    }
                }
                catch (IOException iOException) {}
                return null;
            }
            if (!(result instanceof NativeJavaObject)) break block22;
            Object object = ((NativeJavaObject)result).unwrap();
            try {
                if (codeReader != null) {
                    codeReader.close();
                }
            }
            catch (IOException iOException) {}
            return object;
        }
        Object object = result;
        try {
            if (codeReader != null) {
                codeReader.close();
            }
        }
        catch (IOException iOException) {}
        return object;
        catch (WrappedException e) {
            block23: {
                try {
                    Throwable wrapped = e.getWrappedException();
                    if (!(wrapped instanceof Exception)) break block23;
                    throw (Exception)wrapped;
                }
                catch (Throwable throwable) {
                    try {
                        if (codeReader != null) {
                            codeReader.close();
                        }
                    }
                    catch (IOException iOException) {}
                    throw throwable;
                }
            }
            try {
                if (codeReader != null) {
                    codeReader.close();
                }
            }
            catch (IOException iOException) {}
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Context getContext() {
        Context context = Context.getCurrentContext();
        if (context == null) {
            ContextFactory contextFactory = ContextFactory.getGlobal();
            synchronized (contextFactory) {
                context = Context.enter();
            }
        }
        return context;
    }

    public void terminateCurrent() {
        ((ObservingContextFactory)ContextFactory.getGlobal()).terminate(this.mContext);
    }

    public void setDebugger(Debugger debugger) {
        this.mDebugger = debugger;
    }

    public ScriptableObject getScope() {
        return this.mScope;
    }

    public synchronized void registerJar(URL url) {
        RhinoClassLoader.registerURL((IScriptEngine)this, url);
    }

    public synchronized void reset() {
        RhinoClassLoader.unregisterEngine(this);
        super.reset();
        this.setupEngine();
    }

    protected Object internalGetVariable(String name) {
        Object value = this.getScope().get(name, (Scriptable)this.getScope());
        if (value instanceof NativeJavaObject) {
            return ((NativeJavaObject)value).unwrap();
        }
        return value;
    }

    protected Map<String, Object> internalGetVariables() {
        HashMap<String, Object> result = new HashMap<String, Object>();
        Object[] objectArray = this.getScope().getIds();
        int n = objectArray.length;
        int n2 = 0;
        while (n2 < n) {
            Object key = objectArray[n2];
            Object value = this.internalGetVariable(key.toString());
            if (!value.getClass().getName().startsWith("org.mozilla.javascript.gen")) {
                result.put(key.toString(), value);
            }
            ++n2;
        }
        return result;
    }

    protected boolean internalHasVariable(String name) {
        Object value = this.getScope().get(name, (Scriptable)this.getScope());
        return !Scriptable.NOT_FOUND.equals(value);
    }

    protected void internalSetVariable(String name, Object content) {
        if (!JavaScriptHelper.isSaveName((String)name)) {
            throw new RuntimeException("\"" + name + "\" is not a valid JavaScript variable name");
        }
        ScriptableObject scope = this.getScope();
        Object jsOut = this.internaljavaToJS(content, (Scriptable)scope);
        scope.put(name, (Scriptable)scope, jsOut);
    }

    protected Object internalRemoveVariable(String name) {
        Object result = this.getVariable(name);
        this.getScope().delete(name);
        return result;
    }

    private Object internaljavaToJS(Object value, Scriptable scope) {
        Object result = null;
        result = this.isPrimitiveType(value) || value instanceof Scriptable ? value : (value instanceof Character ? String.valueOf(((Character)value).charValue()) : this.getContext().getWrapFactory().wrap(this.getContext(), scope, value, null));
        return result;
    }

    private boolean isPrimitiveType(Object value) {
        return value instanceof String || value instanceof Number || value instanceof Boolean;
    }

    public void setCreateLineNumberInformation(boolean createLineNumberInformation) {
        this.mCreateLineNumberInformation = createLineNumberInformation;
    }

    public FileTrace getFileTrace() {
        Debugger debugger = this.mContext.getDebugger();
        if (debugger instanceof LineNumberDebugger) {
            FileTrace trace = new FileTrace();
            List<LineNumberDebugger.LineNumberDebugFrame> frames = ((LineNumberDebugger)debugger).getFrames();
            for (LineNumberDebugger.LineNumberDebugFrame frame : frames) {
                trace.push(frame.getScript().getSourceName(), frame.getLineNumber(), null);
            }
            return trace;
        }
        return super.getFileTrace();
    }

    public String getSaveVariableName(String name) {
        return JavaScriptHelper.getSaveName((String)name);
    }
}

