/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ease.ui.scripts;

import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.InputStream;
import org.eclipse.core.resources.IStorage;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;
import org.eclipse.ease.ui.scripts.repository.IScript;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.ui.IPersistableElement;
import org.eclipse.ui.IStorageEditorInput;
import org.eclipse.ui.plugin.AbstractUIPlugin;

public class ScriptEditorInput
implements IStorageEditorInput {
    private final String fName;
    private final InputStream fContent;
    private final IScript fScript;

    public ScriptEditorInput(IScript script) {
        this.fScript = script;
        this.fName = script.getName();
        this.fContent = null;
    }

    public ScriptEditorInput(String name, String content) {
        this.fName = name;
        this.fContent = new ByteArrayInputStream(content.getBytes());
        this.fScript = null;
    }

    public final boolean equals(Object other) {
        return other instanceof ScriptEditorInput && this.fName.equals(((ScriptEditorInput)other).fName);
    }

    public final Object getAdapter(Class adapter) {
        return null;
    }

    public final IPersistableElement getPersistable() {
        return null;
    }

    public final boolean exists() {
        return true;
    }

    public final IStorage getStorage() {
        return new IStorage(){

            public Object getAdapter(Class adapter) {
                return null;
            }

            public boolean isReadOnly() {
                return ScriptEditorInput.this.fScript.isRemote();
            }

            public String getName() {
                return ScriptEditorInput.this.fName;
            }

            public IPath getFullPath() {
                Object content;
                if (ScriptEditorInput.this.fScript != null && (content = ScriptEditorInput.this.fScript.getResource()) instanceof File) {
                    return new Path(((File)content).getPath());
                }
                return null;
            }

            public InputStream getContents() throws CoreException {
                if (ScriptEditorInput.this.fScript != null) {
                    return ScriptEditorInput.this.fScript.getInputStream();
                }
                return ScriptEditorInput.this.fContent;
            }
        };
    }

    public final ImageDescriptor getImageDescriptor() {
        return AbstractUIPlugin.imageDescriptorFromPlugin((String)"org.eclipse.ease.ui", (String)"/images/eobj16/script.gif");
    }

    public final String getName() {
        return "Script: " + this.fName;
    }

    public final String getToolTipText() {
        return "Script editor";
    }
}

