/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ease.ui.completion.provider;

import java.io.File;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.ease.tools.ResourceTools;

public class LocationResolver {
    private final String fLocation;
    private boolean fAbsolute = false;
    private Type fType = Type.UNKNOWN;
    private final Object fParent;
    private Object fResolvedFolder;
    private boolean fProcessed = false;

    private static final boolean isWindows() {
        return System.getProperty("os.name").toLowerCase().contains("win");
    }

    public LocationResolver(String location, Object parent) {
        this.fLocation = location;
        this.fParent = parent;
    }

    public boolean isAbsolute() {
        this.process();
        return this.fAbsolute;
    }

    public Type getType() {
        this.process();
        return this.fType;
    }

    public String getFilterPart() {
        int delimiter = this.fLocation.lastIndexOf(File.separatorChar);
        if (delimiter != -1) {
            return this.fLocation.substring(delimiter + 1);
        }
        delimiter = this.fLocation.lastIndexOf(47);
        if (delimiter != -1) {
            return this.fLocation.substring(delimiter + 1);
        }
        if (this.fLocation.endsWith("//")) {
            return "";
        }
        return this.fLocation;
    }

    public Object getResolvedFolder() {
        this.process();
        return this.fResolvedFolder;
    }

    public Collection<? extends Object> getChildren() {
        this.process();
        try {
            if (this.fResolvedFolder instanceof IContainer) {
                return Arrays.asList(((IContainer)this.fResolvedFolder).members());
            }
        }
        catch (CoreException e) {
            throw new RuntimeException(e);
        }
        if (this.fResolvedFolder instanceof File) {
            return Arrays.asList(((File)this.fResolvedFolder).listFiles());
        }
        if (this.fResolvedFolder == null) {
            if (this.fType == Type.WORKSPACE) {
                return Arrays.asList(ResourcesPlugin.getWorkspace().getRoot().getProjects());
            }
            if (this.fType == Type.FILE) {
                if (LocationResolver.isWindows()) {
                    return Arrays.asList(File.listRoots());
                }
                return Arrays.asList(new File("/").listFiles());
            }
        }
        return Collections.emptySet();
    }

    public String getParentString() {
        this.process();
        String resolvedFolderName = this.fLocation.substring(0, this.fLocation.length() - this.getFilterPart().length());
        if (this.isAbsolute()) {
            switch (this.fType) {
                case FILE: {
                    if (this.getResolvedFolder() instanceof File) {
                        return "file://" + ((File)this.getResolvedFolder()).toURI().toString().substring(5);
                    }
                    return "file:///";
                }
                case WORKSPACE: {
                    if (this.getResolvedFolder() instanceof IContainer) {
                        String suffix = ((IContainer)this.getResolvedFolder()).getFullPath().toString().equals("/") ? "" : "/";
                        return "workspace:/" + ((IContainer)this.getResolvedFolder()).getFullPath() + suffix;
                    }
                    return "workspace://";
                }
                case PROJECT: {
                    if (this.getResolvedFolder() instanceof IContainer) {
                        String suffix = ((IContainer)this.getResolvedFolder()).getProjectRelativePath().isEmpty() ? "" : "/";
                        return "project://" + ((IContainer)this.getResolvedFolder()).getProjectRelativePath() + suffix;
                    }
                    return "project://";
                }
            }
        }
        return resolvedFolderName;
    }

    private void process() {
        if (!this.fProcessed) {
            this.fProcessed = true;
            if (this.fLocation.contains("://")) {
                String scheme = this.fLocation.substring(0, this.fLocation.indexOf("://"));
                if ("workspace".equals(scheme)) {
                    this.fType = Type.WORKSPACE;
                    this.fAbsolute = true;
                } else if ("project".equals(scheme)) {
                    this.fType = Type.PROJECT;
                    this.fAbsolute = true;
                } else if ("file".equals(scheme)) {
                    this.fType = Type.FILE;
                    this.fAbsolute = true;
                } else if (scheme.startsWith("http")) {
                    this.fType = Type.HTTP;
                    this.fAbsolute = true;
                } else {
                    this.fType = Type.GENERIC_URI;
                    this.fAbsolute = true;
                }
            } else if (this.fLocation.startsWith("/")) {
                this.fType = Type.FILE;
                this.fAbsolute = true;
            } else if (this.fLocation.indexOf(":/") == 1 || this.fLocation.indexOf(":\\") == 1) {
                this.fType = Type.FILE;
                this.fAbsolute = true;
            } else {
                this.fAbsolute = false;
                if (this.fParent instanceof IResource) {
                    this.fType = Type.WORKSPACE;
                } else if (this.fParent instanceof File) {
                    this.fType = Type.FILE;
                }
            }
            String resolvedFolderName = this.fLocation.substring(0, this.fLocation.length() - this.getFilterPart().length());
            if (resolvedFolderName.startsWith("file://") && (resolvedFolderName = resolvedFolderName.substring(7)).startsWith("/") && LocationResolver.isWindows()) {
                resolvedFolderName = resolvedFolderName.substring(1);
            }
            switch (this.fType) {
                case UNKNOWN: {
                    if (this.fParent == null) {
                        this.fResolvedFolder = null;
                        return;
                    }
                    if (this.fParent instanceof IResource) {
                        IContainer parentFolder = ((IResource)this.fParent).getParent();
                        if (resolvedFolderName.trim().isEmpty()) {
                            this.fResolvedFolder = parentFolder;
                            break;
                        }
                        this.fResolvedFolder = ResourceTools.resolveFolder((Object)resolvedFolderName, (Object)parentFolder, (boolean)true);
                        break;
                    }
                    if (!(this.fParent instanceof File)) break;
                    File parentFolder = ((File)this.fParent).getParentFile();
                    if (resolvedFolderName.trim().isEmpty()) {
                        this.fResolvedFolder = parentFolder;
                        break;
                    }
                    this.fResolvedFolder = ResourceTools.resolveFolder((Object)resolvedFolderName, (Object)parentFolder, (boolean)true);
                    break;
                }
                case FILE: {
                    this.fResolvedFolder = ResourceTools.resolveFolder((Object)resolvedFolderName, (Object)(this.fAbsolute ? null : this.fParent), (boolean)true);
                    break;
                }
                case WORKSPACE: {
                    this.fResolvedFolder = ResourceTools.resolveFolder((Object)resolvedFolderName, (Object)(this.fAbsolute ? null : this.fParent), (boolean)true);
                    break;
                }
                case PROJECT: {
                    if (!(this.fParent instanceof IResource)) break;
                    try {
                        this.fResolvedFolder = ResourceTools.resolveFolder((Object)resolvedFolderName, (Object)this.fParent, (boolean)true);
                    }
                    catch (IllegalArgumentException illegalArgumentException) {
                        this.fResolvedFolder = ((IResource)this.fParent).getProject();
                    }
                    break;
                }
            }
            this.fResolvedFolder = ResourceTools.resolveFolder((Object)this.fResolvedFolder, null, (boolean)true);
        }
    }

    public static enum Type {
        FILE,
        WORKSPACE,
        PROJECT,
        HTTP,
        GENERIC_URI,
        UNKNOWN;

    }
}

