/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ease.lang.unittest.ui.handlers;

import org.eclipse.core.commands.AbstractHandler;
import org.eclipse.core.commands.ExecutionEvent;
import org.eclipse.core.commands.ExecutionException;
import org.eclipse.core.commands.IHandler;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;
import org.eclipse.ease.lang.unittest.definition.IDefinitionFactory;
import org.eclipse.ease.lang.unittest.definition.IDefinitionPackage;
import org.eclipse.ease.lang.unittest.definition.IVariable;
import org.eclipse.ease.lang.unittest.ui.editor.TestSuiteEditor;
import org.eclipse.ease.lang.unittest.ui.editor.VariablesPage;
import org.eclipse.emf.common.command.Command;
import org.eclipse.emf.edit.command.AddCommand;
import org.eclipse.emf.edit.domain.EditingDomain;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.forms.editor.IFormPage;
import org.eclipse.ui.handlers.HandlerUtil;

public class AddVariableHandler
extends AbstractHandler
implements IHandler {
    private static final String DEFAULT_VARIABLE_NAME = "myVariable";

    private static boolean isUniqueVariable(IPath path, VariablesPage variablesPage) {
        for (IVariable variable : variablesPage.getEditor().getTestSuite().getVariables()) {
            if (!path.equals((Object)variable.getFullName())) continue;
            return false;
        }
        return true;
    }

    public Object execute(ExecutionEvent event) throws ExecutionException {
        IFormPage variablesPage;
        IEditorPart editorWindow = HandlerUtil.getActiveEditor((ExecutionEvent)event);
        if (editorWindow instanceof TestSuiteEditor && (variablesPage = ((TestSuiteEditor)editorWindow).getActivePageInstance()) instanceof VariablesPage) {
            ISelection selection = HandlerUtil.getActiveMenuSelection((ExecutionEvent)event);
            Path rootPath = null;
            if (selection.isEmpty()) {
                rootPath = Path.ROOT;
            } else {
                Object firstElement = ((IStructuredSelection)selection).getFirstElement();
                if (firstElement instanceof IVariable) {
                    rootPath = ((IVariable)firstElement).getPath();
                } else if (firstElement instanceof IPath) {
                    rootPath = (IPath)firstElement;
                }
            }
            if (rootPath != null) {
                IPath candidate = rootPath.append(DEFAULT_VARIABLE_NAME);
                int index = 1;
                while (!AddVariableHandler.isUniqueVariable(candidate, (VariablesPage)variablesPage)) {
                    candidate = rootPath.append(DEFAULT_VARIABLE_NAME + index++);
                }
                IVariable variable = IDefinitionFactory.eINSTANCE.createVariable();
                variable.setFullName(candidate.makeAbsolute());
                Command command = AddCommand.create((EditingDomain)((TestSuiteEditor)editorWindow).getEditingDomain(), (Object)((TestSuiteEditor)editorWindow).getTestSuite(), (Object)IDefinitionPackage.Literals.TEST_SUITE_DEFINITION__VARIABLES, (Object)variable);
                ((TestSuiteEditor)editorWindow).executeCommand(command);
            }
        }
        return null;
    }
}

