/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ease.debugging;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.core.resources.IMarkerDelta;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.debug.core.DebugException;
import org.eclipse.debug.core.DebugPlugin;
import org.eclipse.debug.core.IBreakpointListener;
import org.eclipse.debug.core.ILaunch;
import org.eclipse.debug.core.model.IBreakpoint;
import org.eclipse.debug.core.model.IDebugTarget;
import org.eclipse.debug.core.model.IMemoryBlock;
import org.eclipse.debug.core.model.IProcess;
import org.eclipse.debug.core.model.IStackFrame;
import org.eclipse.ease.Script;
import org.eclipse.ease.debugging.EventDispatchJob;
import org.eclipse.ease.debugging.IEventProcessor;
import org.eclipse.ease.debugging.IScriptDebugFrame;
import org.eclipse.ease.debugging.ScriptDebugElement;
import org.eclipse.ease.debugging.ScriptDebugProcess;
import org.eclipse.ease.debugging.ScriptDebugStackFrame;
import org.eclipse.ease.debugging.ScriptDebugThread;
import org.eclipse.ease.debugging.events.BreakpointRequest;
import org.eclipse.ease.debugging.events.EngineStartedEvent;
import org.eclipse.ease.debugging.events.EngineTerminatedEvent;
import org.eclipse.ease.debugging.events.IDebugEvent;
import org.eclipse.ease.debugging.events.ResumeRequest;
import org.eclipse.ease.debugging.events.ResumedEvent;
import org.eclipse.ease.debugging.events.ScriptReadyEvent;
import org.eclipse.ease.debugging.events.StackFramesEvent;
import org.eclipse.ease.debugging.events.SuspendedEvent;
import org.eclipse.ease.debugging.events.TerminateRequest;

public abstract class ScriptDebugTarget
extends ScriptDebugElement
implements IDebugTarget,
IEventProcessor {
    private EventDispatchJob fDispatcher;
    private ScriptDebugProcess fProcess = null;
    private final List<ScriptDebugThread> fThreads = new ArrayList<ScriptDebugThread>();
    private final ILaunch fLaunch;
    private ScriptDebugElement.State fState = ScriptDebugElement.State.NOT_STARTED;
    private final boolean fSuspendOnStartup;
    private final boolean fSuspendOnScriptLoad;
    private final boolean fShowDynamicCode;

    public ScriptDebugTarget(ILaunch launch, boolean suspendOnStartup, boolean suspendOnScriptLoad, boolean showDynamicCode) {
        super(null);
        this.fLaunch = launch;
        this.fSuspendOnStartup = suspendOnStartup;
        this.fSuspendOnScriptLoad = suspendOnScriptLoad;
        this.fShowDynamicCode = showDynamicCode;
        DebugPlugin.getDefault().getBreakpointManager().addBreakpointListener((IBreakpointListener)this);
        this.fireCreationEvent();
    }

    public String getName() throws DebugException {
        return "EASE Debugger";
    }

    @Override
    public ScriptDebugTarget getDebugTarget() {
        return this;
    }

    public ILaunch getLaunch() {
        return this.fLaunch;
    }

    public IProcess getProcess() {
        return this.fProcess;
    }

    public ScriptDebugThread[] getThreads() {
        return this.fThreads.toArray(new ScriptDebugThread[this.fThreads.size()]);
    }

    public boolean hasThreads() throws DebugException {
        return !this.fThreads.isEmpty();
    }

    public boolean supportsBreakpoint(IBreakpoint breakpoint) {
        return false;
    }

    public void setDispatcher(EventDispatchJob dispatcher) {
        this.fDispatcher = dispatcher;
    }

    protected void fireDispatchEvent(IDebugEvent event) {
        this.fDispatcher.addEvent(event);
    }

    @Override
    public void handleEvent(IDebugEvent event) {
        if (event instanceof EngineStartedEvent) {
            this.fProcess = new ScriptDebugProcess(this);
            this.fProcess.fireCreationEvent();
        } else if (event instanceof ScriptReadyEvent) {
            ScriptDebugThread debugThread = this.findDebugThread(((ScriptReadyEvent)event).getThread());
            if (debugThread == null) {
                debugThread = new ScriptDebugThread(this.getDebugTarget(), ((ScriptReadyEvent)event).getThread());
                this.fThreads.add(debugThread);
                debugThread.fireCreationEvent();
            }
            debugThread.fireChangeEvent(512);
            this.setDeferredBreakpoints(((ScriptReadyEvent)event).getScript());
            this.fireSuspendEvent(32);
            debugThread.setSuspended(32);
            int stepType = 0;
            if (this.fSuspendOnScriptLoad) {
                stepType = 1;
            } else if (((ScriptReadyEvent)event).isRoot() && this.fSuspendOnStartup) {
                stepType = 1;
            }
            this.fireDispatchEvent(new ResumeRequest(stepType, debugThread.getThread()));
        } else if (event instanceof StackFramesEvent) {
            ScriptDebugThread debugThread = this.findDebugThread(((StackFramesEvent)event).getThread());
            debugThread.setStackFrames(this.filterFrames(((StackFramesEvent)event).getDebugFrames()));
        } else if (event instanceof ResumedEvent) {
            ScriptDebugThread debugThread = this.findDebugThread(((ResumedEvent)event).getThread());
            debugThread.setResumed(((ResumedEvent)event).getType());
        } else if (event instanceof SuspendedEvent) {
            ScriptDebugThread debugThread = this.findDebugThread(((SuspendedEvent)event).getThread());
            debugThread.setStackFrames(this.filterFrames(((SuspendedEvent)event).getDebugFrames()));
            debugThread.setSuspended(((SuspendedEvent)event).getType());
        } else if (event instanceof EngineTerminatedEvent) {
            DebugPlugin.getDefault().getBreakpointManager().removeBreakpointListener((IBreakpointListener)this);
            this.fState = ScriptDebugElement.State.TERMINATED;
            this.fireTerminateEvent();
            ScriptDebugThread[] scriptDebugThreadArray = this.getThreads();
            int n = scriptDebugThreadArray.length;
            int n2 = 0;
            while (n2 < n) {
                ScriptDebugThread thread = scriptDebugThreadArray[n2];
                thread.setTerminated();
                ++n2;
            }
        }
    }

    private List<IScriptDebugFrame> filterFrames(List<IScriptDebugFrame> frames) {
        if (this.fShowDynamicCode) {
            return frames;
        }
        ArrayList<IScriptDebugFrame> filteredFrames = new ArrayList<IScriptDebugFrame>(frames);
        for (IScriptDebugFrame frame : frames) {
            if (!frame.getScript().isDynamic()) continue;
            filteredFrames.remove(frame);
        }
        return filteredFrames;
    }

    private ScriptDebugThread findDebugThread(Thread thread) {
        ScriptDebugThread[] scriptDebugThreadArray = this.getThreads();
        int n = scriptDebugThreadArray.length;
        int n2 = 0;
        while (n2 < n) {
            ScriptDebugThread debugThread = scriptDebugThreadArray[n2];
            if (thread.equals(debugThread.getThread())) {
                return debugThread;
            }
            ++n2;
        }
        return null;
    }

    private void setDeferredBreakpoints(Script script) {
        Object file = script.getFile();
        if (file instanceof IResource) {
            IBreakpoint[] breakpoints;
            IBreakpoint[] iBreakpointArray = breakpoints = this.getBreakpoints(script);
            int n = breakpoints.length;
            int n2 = 0;
            while (n2 < n) {
                IBreakpoint breakpoint = iBreakpointArray[n2];
                if (file.equals(breakpoint.getMarker().getResource())) {
                    this.fireDispatchEvent(new BreakpointRequest(script, breakpoint, BreakpointRequest.Mode.ADD));
                }
                ++n2;
            }
        }
    }

    protected abstract IBreakpoint[] getBreakpoints(Script var1);

    public void breakpointAdded(IBreakpoint breakpoint) {
        this.handleBreakpointChange(breakpoint, BreakpointRequest.Mode.ADD);
    }

    public void breakpointRemoved(IBreakpoint breakpoint, IMarkerDelta delta) {
        this.handleBreakpointChange(breakpoint, BreakpointRequest.Mode.REMOVE);
    }

    public void breakpointChanged(IBreakpoint breakpoint, IMarkerDelta delta) {
        this.breakpointRemoved(breakpoint, delta);
        this.breakpointAdded(breakpoint);
    }

    private void handleBreakpointChange(IBreakpoint breakpoint, BreakpointRequest.Mode mode) {
        IResource affectedResource = breakpoint.getMarker().getResource();
        ScriptDebugThread[] scriptDebugThreadArray = this.getThreads();
        int n = scriptDebugThreadArray.length;
        int n2 = 0;
        while (n2 < n) {
            ScriptDebugThread thread = scriptDebugThreadArray[n2];
            IStackFrame[] iStackFrameArray = thread.getStackFrames();
            int n3 = iStackFrameArray.length;
            int n4 = 0;
            while (n4 < n3) {
                Script script;
                IStackFrame frame = iStackFrameArray[n4];
                if (frame instanceof ScriptDebugStackFrame && affectedResource.equals((script = ((ScriptDebugStackFrame)frame).getScript()).getFile())) {
                    this.fireDispatchEvent(new BreakpointRequest(script, breakpoint, mode));
                }
                ++n4;
            }
            ++n2;
        }
    }

    public boolean supportsStorageRetrieval() {
        return false;
    }

    public IMemoryBlock getMemoryBlock(long startAddress, long length) throws DebugException {
        throw new DebugException((IStatus)new Status(4, "Activator.PLUGIN_ID", "getMemoryBlock() not supported by " + this.getName()));
    }

    @Override
    public void terminate() throws DebugException {
        this.fireDispatchEvent(new TerminateRequest());
    }

    public boolean isTerminated() {
        return ScriptDebugElement.State.TERMINATED == this.fState;
    }

    public boolean isSuspended() {
        ScriptDebugThread[] threads = this.getThreads();
        if (threads.length == 1) {
            threads[0].isSuspended();
        }
        return false;
    }

    @Override
    public void resume() throws DebugException {
        ScriptDebugThread[] threads = this.getThreads();
        if (threads.length == 1) {
            this.fireDispatchEvent(new ResumeRequest(32, threads[0].getThread()));
        }
    }

    @Override
    public void disconnect() throws DebugException {
        this.fireDispatchEvent(new ResumeRequest(32, null));
        this.fState = ScriptDebugElement.State.TERMINATED;
        this.fireTerminateEvent();
    }

    public boolean isStepping() {
        ScriptDebugThread[] threads = this.getThreads();
        if (threads.length == 1) {
            threads[0].isStepping();
        }
        return false;
    }
}

