/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ease.ui.preferences;

import java.util.Map;
import org.eclipse.core.runtime.preferences.InstanceScope;
import org.eclipse.ease.service.EngineDescription;
import org.eclipse.ease.service.IScriptService;
import org.eclipse.ease.ui.Activator;
import org.eclipse.jface.preference.PreferencePage;
import org.eclipse.jface.viewers.ArrayContentProvider;
import org.eclipse.jface.viewers.ComboViewer;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.jface.viewers.ViewerComparator;
import org.eclipse.swt.custom.ScrolledComposite;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.TabFolder;
import org.eclipse.swt.widgets.TabItem;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.IWorkbench;
import org.eclipse.ui.IWorkbenchPreferencePage;
import org.eclipse.ui.PlatformUI;
import org.osgi.service.prefs.Preferences;

public class ShellPreferencePage
extends PreferencePage
implements IWorkbenchPreferencePage {
    private Text fTxtHistoryLength;
    private Button fChkAutoFocusText;
    private Button fChkKeepLastCommand;
    private TabFolder fTabFolder;
    private Button fChkModulesAsFlatList;
    private ComboViewer comboViewer;

    public void init(IWorkbench workbench) {
        this.setPreferenceStore(Activator.getDefault().getPreferenceStore());
    }

    protected Control createContents(Composite parent) {
        Composite container = new Composite(parent, 0);
        container.setLayout((Layout)new GridLayout(2, false));
        Label lblNewLabel = new Label(container, 64);
        lblNewLabel.setLayoutData((Object)new GridData(16384, 0x1000000, false, false, 2, 1));
        lblNewLabel.setText("Defines look and feel as well as behavior of the script shells.");
        Group grpAppearance = new Group(container, 0);
        grpAppearance.setLayout((Layout)new GridLayout(3, false));
        GridData gd_grpAppearance = new GridData(4, 0x1000000, true, false, 2, 1);
        gd_grpAppearance.verticalIndent = 15;
        grpAppearance.setLayoutData((Object)gd_grpAppearance);
        grpAppearance.setText("Appearance");
        Label lblSeeColorsAnd = new Label((Composite)grpAppearance, 0);
        lblSeeColorsAnd.setLayoutData((Object)new GridData(16384, 0x1000000, false, false, 3, 1));
        lblSeeColorsAnd.setText("See Colors and fonts to change the font settings for shell output.");
        Label lblHistoryLength = new Label((Composite)grpAppearance, 0);
        lblHistoryLength.setLayoutData((Object)new GridData(131072, 0x1000000, false, false, 1, 1));
        lblHistoryLength.setText("History Length:");
        this.fTxtHistoryLength = new Text((Composite)grpAppearance, 2048);
        Label lblEntries = new Label((Composite)grpAppearance, 0);
        lblEntries.setText("entries");
        this.fChkModulesAsFlatList = new Button((Composite)grpAppearance, 32);
        this.fChkModulesAsFlatList.setLayoutData((Object)new GridData(16384, 0x1000000, false, false, 3, 1));
        this.fChkModulesAsFlatList.setText("Show modules as flat list");
        this.fChkAutoFocusText = new Button((Composite)grpAppearance, 32);
        this.fChkAutoFocusText.setLayoutData((Object)new GridData(16384, 0x1000000, false, false, 3, 1));
        this.fChkAutoFocusText.setText("Auto focus text input field");
        this.fChkKeepLastCommand = new Button((Composite)grpAppearance, 32);
        this.fChkKeepLastCommand.setLayoutData((Object)new GridData(16384, 0x1000000, false, false, 3, 1));
        this.fChkKeepLastCommand.setText("Keep last command in input field");
        Label lblPreferredEngine = new Label(container, 0);
        lblPreferredEngine.setLayoutData((Object)new GridData(131072, 0x1000000, false, false, 1, 1));
        lblPreferredEngine.setText("Preferred Engine:");
        this.comboViewer = new ComboViewer(container, 0);
        Combo combo = this.comboViewer.getCombo();
        combo.setLayoutData((Object)new GridData(4, 0x1000000, true, false, 1, 1));
        this.comboViewer.setContentProvider((IContentProvider)ArrayContentProvider.getInstance());
        this.comboViewer.setComparator(new ViewerComparator(){

            public int compare(Viewer viewer, Object e1, Object e2) {
                return ((EngineDescription)e1).getName().compareTo(((EngineDescription)e2).getName());
            }
        });
        Label lblShellStartupCommands = new Label(container, 0);
        lblShellStartupCommands.setLayoutData((Object)new GridData(16384, 0x1000000, false, false, 2, 1));
        lblShellStartupCommands.setText("Shell startup commands");
        this.fTabFolder = new TabFolder(container, 0);
        this.fTabFolder.setLayoutData((Object)new GridData(4, 4, true, true, 2, 1));
        IScriptService scriptService = (IScriptService)PlatformUI.getWorkbench().getService(IScriptService.class);
        Map scriptTypes = scriptService.getAvailableScriptTypes();
        for (String type : scriptTypes.keySet()) {
            TabItem tbtmNewItem = new TabItem(this.fTabFolder, 0);
            tbtmNewItem.setText(type);
            ScrolledComposite scrolledComposite = new ScrolledComposite((Composite)this.fTabFolder, 768);
            tbtmNewItem.setControl((Control)scrolledComposite);
            scrolledComposite.setExpandHorizontal(true);
            scrolledComposite.setExpandVertical(true);
            Text input = new Text((Composite)scrolledComposite, 2562);
            scrolledComposite.setContent((Control)input);
        }
        this.performDefaults();
        return container;
    }

    protected void performDefaults() {
        Preferences prefs = InstanceScope.INSTANCE.getNode("org.eclipse.ease.ui").node("shell");
        int defaultLength = prefs.getInt("shellHistoryLength", 20);
        this.fTxtHistoryLength.setText(Integer.toString(defaultLength));
        boolean flatList = prefs.getBoolean("shellModulesAsList", false);
        this.fChkAutoFocusText.setSelection(flatList);
        boolean autofocus = prefs.getBoolean("shellAutoFocus", true);
        this.fChkAutoFocusText.setSelection(autofocus);
        boolean keepCommand = prefs.getBoolean("shellKeepCommand", false);
        this.fChkKeepLastCommand.setSelection(keepCommand);
        IScriptService scriptService = (IScriptService)PlatformUI.getWorkbench().getService(IScriptService.class);
        this.comboViewer.setInput((Object)scriptService.getEngines());
        String engineID = prefs.get("shellDefaultEngine", "org.eclipse.ease.javascript.rhino");
        this.comboViewer.setSelection((ISelection)new StructuredSelection((Object)scriptService.getEngineByID(engineID)), true);
        TabItem[] tabItemArray = this.fTabFolder.getItems();
        int n = tabItemArray.length;
        int n2 = 0;
        while (n2 < n) {
            TabItem item = tabItemArray[n2];
            String title = item.getText();
            String shellCommands = prefs.get("shellStartup" + title, "");
            ((Text)((ScrolledComposite)item.getControl()).getContent()).setText(shellCommands);
            ++n2;
        }
        super.performDefaults();
    }

    public boolean performOk() {
        Preferences prefs = InstanceScope.INSTANCE.getNode("org.eclipse.ease.ui").node("shell");
        prefs.putInt("shellHistoryLength", Integer.parseInt(this.fTxtHistoryLength.getText()));
        prefs.putBoolean("shellModulesAsList", this.fChkModulesAsFlatList.getSelection());
        prefs.putBoolean("shellAutoFocus", this.fChkAutoFocusText.getSelection());
        prefs.putBoolean("shellKeepCommand", this.fChkKeepLastCommand.getSelection());
        String engineId = ((EngineDescription)((IStructuredSelection)this.comboViewer.getSelection()).getFirstElement()).getID();
        prefs.put("shellDefaultEngine", engineId);
        TabItem[] tabItemArray = this.fTabFolder.getItems();
        int n = tabItemArray.length;
        int n2 = 0;
        while (n2 < n) {
            TabItem item = tabItemArray[n2];
            String title = item.getText();
            String commands = ((Text)((ScrolledComposite)item.getControl()).getContent()).getText();
            prefs.put("shellStartup" + title, commands);
            ++n2;
        }
        return super.performOk();
    }
}

