/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ease.ui.scripts.keywordhandler;

import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.ease.Logger;
import org.eclipse.ease.ui.scripts.repository.IScript;
import org.osgi.service.event.Event;
import org.osgi.service.event.EventHandler;

public class StartupHandler
implements EventHandler {
    public void handleEvent(Event event) {
        final IScript script = (IScript)event.getProperty("script");
        String value = (String)event.getProperty("value");
        String oldValue = (String)event.getProperty("oldValue");
        if (!value.isEmpty() && oldValue == null) {
            int delay = 0;
            try {
                delay = Integer.parseInt(value);
            }
            catch (NumberFormatException numberFormatException) {
                Logger.error((String)"org.eclipse.ease.ui.scripts", (String)("Invalid onStartup delay for script: " + script.getLocation()));
            }
            if (delay > 0) {
                new Job("Startup script execution"){

                    protected IStatus run(IProgressMonitor monitor) {
                        script.run();
                        return Status.OK_STATUS;
                    }
                }.schedule((long)(delay * 1000));
            } else {
                script.run();
            }
        }
    }
}

