/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ease.ui.scripts.expressions.ui;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.eclipse.core.commands.ExecutionEvent;
import org.eclipse.core.commands.ExecutionException;
import org.eclipse.core.commands.IExecutionListener;
import org.eclipse.core.commands.NotHandledException;
import org.eclipse.ease.ui.scripts.Activator;
import org.eclipse.ease.ui.scripts.expressions.ExpressionTools;
import org.eclipse.ease.ui.scripts.expressions.ICompositeExpressionDefinition;
import org.eclipse.ease.ui.scripts.expressions.IExpressionDefinition;
import org.eclipse.ease.ui.scripts.expressions.definitions.AbstractExpressionDefinition;
import org.eclipse.ease.ui.scripts.expressions.definitions.RootExpressionDefinition;
import org.eclipse.ease.ui.scripts.expressions.ui.ExpressionContentProvider;
import org.eclipse.jface.action.IContributionItem;
import org.eclipse.jface.action.MenuManager;
import org.eclipse.jface.action.Separator;
import org.eclipse.jface.layout.TreeColumnLayout;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.jface.viewers.CellEditor;
import org.eclipse.jface.viewers.CellLabelProvider;
import org.eclipse.jface.viewers.ColumnLabelProvider;
import org.eclipse.jface.viewers.ColumnLayoutData;
import org.eclipse.jface.viewers.ColumnViewer;
import org.eclipse.jface.viewers.ColumnWeightData;
import org.eclipse.jface.viewers.EditingSupport;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ISelectionProvider;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.jface.viewers.TreeViewerColumn;
import org.eclipse.swt.events.KeyEvent;
import org.eclipse.swt.events.KeyListener;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.layout.FillLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Menu;
import org.eclipse.swt.widgets.Tree;
import org.eclipse.swt.widgets.TreeColumn;
import org.eclipse.swt.widgets.Widget;
import org.eclipse.ui.IWorkbenchPartSite;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.commands.ICommandService;
import org.eclipse.ui.menus.CommandContributionItem;
import org.eclipse.ui.menus.CommandContributionItemParameter;
import org.eclipse.ui.services.IServiceLocator;

public class ExpressionComposite
extends Composite {
    private TreeViewer fTreeViewer;
    private Tree fTree;
    private final IWorkbenchPartSite fSite;
    private IExecutionListener fCommandExecutionListener;
    private String[] fFilterIds = null;
    private List<CommandContributionItem> fContributionItems = null;

    public ExpressionComposite(IWorkbenchPartSite site, Composite parent, int style) {
        super(parent, style);
        this.fSite = site != null ? site : PlatformUI.getWorkbench().getActiveWorkbenchWindow().getActivePage().getActivePart().getSite();
        this.createPartControl(this);
    }

    public void createPartControl(Composite parent) {
        this.setLayout((Layout)new FillLayout(256));
        Composite composite = new Composite((Composite)this, 0);
        TreeColumnLayout tcl_composite = new TreeColumnLayout();
        composite.setLayout((Layout)tcl_composite);
        this.fTreeViewer = new TreeViewer(composite, 2048);
        this.fTree = this.fTreeViewer.getTree();
        TreeViewerColumn treeViewerColumn = new TreeViewerColumn(this.fTreeViewer, 0);
        TreeColumn treeColumn = treeViewerColumn.getColumn();
        tcl_composite.setColumnData((Widget)treeColumn, (ColumnLayoutData)new ColumnWeightData(1, 20, true));
        treeViewerColumn.setLabelProvider((CellLabelProvider)new ColumnLabelProvider(){

            public String getText(Object element) {
                if (element instanceof AbstractExpressionDefinition.Parameter) {
                    return String.valueOf(((AbstractExpressionDefinition.Parameter)element).getName()) + ": " + ((AbstractExpressionDefinition.Parameter)element).getValue();
                }
                return super.getText(element);
            }

            public Image getImage(Object element) {
                ImageDescriptor imageDescriptor;
                if (element instanceof AbstractExpressionDefinition.Parameter) {
                    return Activator.getImageDescriptor("/icons/eobj16/expression_parameter.png").createImage();
                }
                ExpressionTools.ExpressionDescription description = ExpressionTools.loadDescriptions().get(element.toString());
                if (description != null && (imageDescriptor = description.getImageDescriptor()) != null) {
                    return imageDescriptor.createImage();
                }
                return Activator.getImageDescriptor("/icons/eobj16/expression.png").createImage();
            }
        });
        treeViewerColumn.setEditingSupport(new EditingSupport((ColumnViewer)this.fTreeViewer){

            protected void setValue(Object element, Object value) {
                ((AbstractExpressionDefinition.Parameter)element).setEditorValue(value.toString());
                ExpressionComposite.this.fTreeViewer.refresh(element);
            }

            protected Object getValue(Object element) {
                return ((AbstractExpressionDefinition.Parameter)element).getEditorValue();
            }

            protected CellEditor getCellEditor(Object element) {
                return ((AbstractExpressionDefinition.Parameter)element).getCellEditor((Composite)ExpressionComposite.this.fTree);
            }

            protected boolean canEdit(Object element) {
                return element instanceof AbstractExpressionDefinition.Parameter;
            }
        });
        this.fTreeViewer.setContentProvider((IContentProvider)new ExpressionContentProvider());
        this.fTree.addKeyListener(new KeyListener(){

            public void keyReleased(KeyEvent e) {
            }

            public void keyPressed(KeyEvent e) {
                if (e.character == '\u007f') {
                    for (Object element : ExpressionComposite.this.fTreeViewer.getStructuredSelection().toList()) {
                        ICompositeExpressionDefinition parent;
                        if (!(element instanceof AbstractExpressionDefinition) || (parent = ((AbstractExpressionDefinition)element).getParent()) == null) continue;
                        parent.removeChild((AbstractExpressionDefinition)element);
                    }
                    ExpressionComposite.this.fTreeViewer.refresh();
                }
            }
        });
        this.setExpression(null, "Root");
        this.createContextMenu();
        final ICommandService service = (ICommandService)this.fSite.getService(ICommandService.class);
        this.fCommandExecutionListener = new IExecutionListener(){

            public void preExecute(String commandId, ExecutionEvent event) {
            }

            public void postExecuteSuccess(String commandId, Object returnValue) {
                if (!ExpressionComposite.this.fTreeViewer.getTree().isDisposed()) {
                    if (commandId.startsWith("org.eclipse.ease.commands.expressions")) {
                        ExpressionComposite.this.fTreeViewer.refresh();
                    }
                } else {
                    service.removeExecutionListener((IExecutionListener)this);
                }
            }

            public void postExecuteFailure(String commandId, ExecutionException exception) {
            }

            public void notHandled(String commandId, NotHandledException exception) {
            }
        };
        service.addExecutionListener(this.fCommandExecutionListener);
    }

    public void dispose() {
        ICommandService service = (ICommandService)this.fSite.getService(ICommandService.class);
        service.removeExecutionListener(this.fCommandExecutionListener);
        super.dispose();
    }

    private void createContextMenu() {
        MenuManager menuManager = new MenuManager();
        this.prepareDynamicContributionItems();
        CommandContributionItemParameter contributionParameters = new CommandContributionItemParameter((IServiceLocator)this.fSite, null, "org.eclipse.ease.commands.expressions.deleteExpression", null, null, null, null, "Delete", null, "Delete", 8, null, true);
        CommandContributionItem deleteContributionItem = new CommandContributionItem(contributionParameters);
        Menu menu = menuManager.createContextMenu(this.fTreeViewer.getControl());
        this.fTreeViewer.getControl().setMenu(menu);
        this.fSite.registerContextMenu(menuManager, (ISelectionProvider)this.fTreeViewer);
        menuManager.addMenuListener(manager -> {
            boolean showMenu;
            Object element = this.fTreeViewer.getStructuredSelection().getFirstElement();
            boolean bl = showMenu = element instanceof ICompositeExpressionDefinition && ((ICompositeExpressionDefinition)element).acceptsChild();
            if (showMenu) {
                for (CommandContributionItem item : this.fContributionItems) {
                    manager.add((IContributionItem)item);
                }
                manager.add((IContributionItem)new Separator());
            }
            if (element instanceof IExpressionDefinition && ((IExpressionDefinition)element).getParent() != null) {
                manager.add((IContributionItem)deleteContributionItem);
            }
        });
        menuManager.setRemoveAllWhenShown(true);
    }

    private void prepareDynamicContributionItems() {
        this.fContributionItems = new ArrayList<CommandContributionItem>();
        Map<String, ExpressionTools.ExpressionDescription> descriptions = ExpressionTools.loadDescriptions();
        ArrayList<String> keys = new ArrayList<String>(descriptions.keySet());
        Collections.sort(keys);
        if (this.fFilterIds != null) {
            keys.retainAll(Arrays.asList(this.fFilterIds));
        }
        for (String key : keys) {
            ExpressionTools.ExpressionDescription description = descriptions.get(key);
            HashMap<String, String> parameters = new HashMap<String, String>();
            parameters.put("org.eclipse.ease.commands.expressions.createExpression.type", description.getName());
            CommandContributionItemParameter contributionParameters = new CommandContributionItemParameter((IServiceLocator)this.fSite, null, "org.eclipse.ease.commands.expressions.createExpression", parameters, description.getImageDescriptor(), null, null, description.getName(), null, "Add " + description.getName() + " Expression", 8, null, true);
            this.fContributionItems.add(new CommandContributionItem(contributionParameters));
        }
    }

    public void setExpression(IExpressionDefinition expression, String rootName) {
        if (this.fTree != null && !this.fTree.isDisposed()) {
            RootExpressionDefinition root = new RootExpressionDefinition(rootName);
            if (expression != null) {
                root.addChild(expression);
            }
            this.fTreeViewer.setInput((Object)new Object[]{root});
        }
    }

    public IExpressionDefinition getExpression() {
        if (this.fTree != null && !this.fTree.isDisposed()) {
            return (IExpressionDefinition)((Object[])this.fTreeViewer.getInput())[0];
        }
        return null;
    }

    public void setAcceptedFilters(String[] filterIds) {
        this.fFilterIds = filterIds;
        this.prepareDynamicContributionItems();
    }
}

