/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ease.ui.sign;

import java.io.ByteArrayInputStream;
import java.io.FileWriter;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStreamWriter;
import java.security.KeyStore;
import java.security.UnrecoverableKeyException;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.runtime.IPath;
import org.eclipse.ease.Logger;
import org.eclipse.ease.service.ScriptType;
import org.eclipse.ease.sign.PerformSignature;
import org.eclipse.ease.sign.ScriptSignatureException;
import org.eclipse.ease.sign.SignatureInfo;
import org.eclipse.ease.tools.ResourceTools;
import org.eclipse.ease.ui.Activator;
import org.eclipse.ease.ui.sign.GetInfo;
import org.eclipse.ease.ui.sign.PasswordDialog;
import org.eclipse.ease.ui.sign.PerformAdvancedSignPage;
import org.eclipse.ease.ui.sign.PerformBasicSignPage;
import org.eclipse.equinox.security.storage.ISecurePreferences;
import org.eclipse.equinox.security.storage.SecurePreferencesFactory;
import org.eclipse.jface.wizard.IWizardPage;
import org.eclipse.jface.wizard.Wizard;

public class PerformSignWizard
extends Wizard {
    protected PerformBasicSignPage fPerformBasicSignPage;
    protected PerformAdvancedSignPage fPerformAdvancedSignPage;
    protected final GetInfo fGetInfo;
    final IFile fFile;
    final ScriptType fScriptType;

    public PerformSignWizard(IFile iFile, ScriptType scriptType, GetInfo getInfo) {
        this.setNeedsProgressMonitor(true);
        this.fGetInfo = getInfo;
        this.fFile = iFile;
        this.fScriptType = scriptType;
    }

    public String getWindowTitle() {
        return "Perform Signature";
    }

    public void addPages() {
        super.addPages();
        this.fPerformBasicSignPage = new PerformBasicSignPage(this.fGetInfo);
        this.fPerformAdvancedSignPage = new PerformAdvancedSignPage();
        this.addPage((IWizardPage)this.fPerformBasicSignPage);
        this.addPage((IWizardPage)this.fPerformAdvancedSignPage);
    }

    public boolean canFinish() {
        return this.fPerformBasicSignPage.canComplete();
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public boolean performFinish() {
        try {
            String signature;
            block23: {
                this.fGetInfo.setCertificates(PerformSignature.getCertificate((KeyStore)this.fGetInfo.getKeyStore(), (String)this.fGetInfo.getAlias(), (boolean)true));
                signature = null;
                ISecurePreferences preferences = SecurePreferencesFactory.getDefault();
                ISecurePreferences node = preferences.node("KeystoreAliasPass");
                String pass = null;
                String aliasNodeKey = String.valueOf(this.fGetInfo.getKeyStoreFile()) + "/" + this.fGetInfo.getAlias();
                while (true) {
                    try {
                        SignatureInfo signatureInfo;
                        pass = node.get(aliasNodeKey, null);
                        if (pass == null) {
                            PasswordDialog passwordDialog = new PasswordDialog(this.getShell(), aliasNodeKey, "Alias Password");
                            if (passwordDialog.open() == 1) {
                                return false;
                            }
                            pass = passwordDialog.getPassword();
                        }
                        InputStream inputStream = (signatureInfo = this.fScriptType.getCodeParser().getSignatureInfo(this.fFile.getContents())) == null ? ResourceTools.getInputStream((Object)this.fFile) : new ByteArrayInputStream(signatureInfo.getContentOnly().getBytes());
                        signature = PerformSignature.createSignature((KeyStore)this.fGetInfo.getKeyStore(), (InputStream)inputStream, (String)this.fGetInfo.getAlias(), (String)pass, (String)this.fPerformAdvancedSignPage.getAliasProvider(), (String)this.fPerformAdvancedSignPage.getMessageDigestAlgo());
                        if (signatureInfo == null) break;
                        this.fGetInfo.setSignaturePresence(true);
                        this.fGetInfo.setContentOnly(signatureInfo.getContentOnly());
                    }
                    catch (UnrecoverableKeyException e) {
                        pass = null;
                        node.remove(aliasNodeKey);
                        this.fPerformBasicSignPage.setErrorMessage("Invalid Private Key Password");
                        this.fPerformAdvancedSignPage.setErrorMessage("Invalid Private Key Password");
                        continue;
                    }
                    catch (Exception e) {
                        Logger.error((String)"org.eclipse.ease.ui", (String)e.getMessage(), (Throwable)e);
                        continue;
                    }
                    break;
                }
                if (signature == null) {
                    this.fPerformBasicSignPage.reset();
                    this.fPerformBasicSignPage.setErrorMessage("Unable to access keystore. Try again");
                    this.fPerformAdvancedSignPage.setErrorMessage("Unable to access keystore. Try again");
                    return false;
                }
                OutputStreamWriter fw = null;
                try {
                    try {
                        IPath iPath = Activator.getDefault().getStateLocation();
                        fw = new FileWriter(iPath.append("EASE_KeyStoreFiles").toString());
                        for (String file : this.fGetInfo.getKeyStoreFiles()) {
                            fw.write(String.valueOf(file) + "\n");
                        }
                    }
                    catch (IOException ex) {
                        Logger.error((String)"org.eclipse.ease.ui", (String)ex.getMessage(), (Throwable)ex);
                        try {
                            if (fw != null) {
                                fw.close();
                            }
                            break block23;
                        }
                        catch (IOException ex2) {
                            Logger.error((String)"org.eclipse.ease.ui", (String)ex2.getMessage(), (Throwable)ex2);
                        }
                        break block23;
                    }
                }
                catch (Throwable throwable) {
                    try {
                        if (fw == null) throw throwable;
                        fw.close();
                        throw throwable;
                    }
                    catch (IOException ex) {
                        Logger.error((String)"org.eclipse.ease.ui", (String)ex.getMessage(), (Throwable)ex);
                    }
                    throw throwable;
                }
                try {
                    if (fw != null) {
                        fw.close();
                    }
                }
                catch (IOException ex) {
                    Logger.error((String)"org.eclipse.ease.ui", (String)ex.getMessage(), (Throwable)ex);
                }
            }
            this.fGetInfo.setSignMessageDigestAlgo(this.fPerformAdvancedSignPage.getMessageDigestAlgo());
            String[] temp = signature.split(":");
            this.fGetInfo.setSignature(temp[1]);
            this.fGetInfo.setSignProvider(temp[0]);
            return true;
        }
        catch (ScriptSignatureException e) {
            this.fPerformBasicSignPage.setErrorMessage(e.getMessage());
            this.fPerformAdvancedSignPage.setErrorMessage(e.getMessage());
            Logger.error((String)"org.eclipse.ease.ui", (String)e.getMessage(), (Throwable)(e.getCause() != null ? e.getCause() : e));
            return false;
        }
    }
}

