/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ease.ui.help.hovers;

import java.io.InputStreamReader;
import java.io.Reader;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.net.URL;
import org.eclipse.ease.Logger;
import org.eclipse.ease.modules.ModuleDefinition;
import org.eclipse.ease.ui.help.hovers.ConstantHelp;
import org.eclipse.ease.ui.help.hovers.HelpHoverImageProvider;
import org.eclipse.ease.ui.help.hovers.IHoverHelp;
import org.eclipse.ease.ui.help.hovers.MethodHelp;
import org.eclipse.ui.IMemento;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.XMLMemento;

public class ModuleHelp
implements IHoverHelp {
    private final IMemento fHelpContent;
    private final URL fHelpLocation;

    public static URL getModuleHelpLocation(ModuleDefinition definition) {
        String helpLocation = definition.getHelpLocation(null);
        return PlatformUI.getWorkbench().getHelpSystem().resolve(helpLocation, true);
    }

    private static IMemento getHtmlContent(URL url) throws Exception {
        try {
            XMLMemento rootNode = XMLMemento.createReadRoot((Reader)new InputStreamReader(url.openStream(), "UTF-8"));
            return rootNode.getChild("body");
        }
        catch (Exception e) {
            Logger.error((String)"org.eclipse.ease.ui", (String)"Cannot find the module help content ", (Throwable)e);
            throw e;
        }
    }

    public ModuleHelp(URL helpLocation) throws Exception {
        this.fHelpLocation = helpLocation;
        this.fHelpContent = ModuleHelp.getHtmlContent(helpLocation);
    }

    @Override
    public String getName() {
        IMemento[] iMementoArray = this.fHelpContent.getChildren();
        int n = iMementoArray.length;
        int n2 = 0;
        while (n2 < n) {
            IMemento node = iMementoArray[n2];
            if ("module".equals(node.getString("class"))) {
                return node.getString("title");
            }
            ++n2;
        }
        return "";
    }

    @Override
    public String getDescription() {
        IMemento[] iMementoArray = this.fHelpContent.getChildren();
        int n = iMementoArray.length;
        int n2 = 0;
        while (n2 < n) {
            IMemento node = iMementoArray[n2];
            if ("module".equals(node.getString("class"))) {
                IMemento[] iMementoArray2 = node.getChildren();
                int n3 = iMementoArray2.length;
                int n4 = 0;
                while (n4 < n3) {
                    IMemento contentNode = iMementoArray2[n4];
                    if ("description".equals(contentNode.getString("class"))) {
                        IHoverHelp.updateRelativeLinks(contentNode, this.fHelpLocation);
                        return IHoverHelp.getNodeContent(contentNode);
                    }
                    ++n4;
                }
            }
            ++n2;
        }
        return "";
    }

    @Override
    public String getHoverContent() {
        String description = this.getDescription();
        if (!description.isEmpty()) {
            StringBuffer help = new StringBuffer();
            help.append("<h5>");
            help.append(IHoverHelp.getImageAndLabel(HelpHoverImageProvider.getImageLocation("icons/eobj16/module.png"), this.getName()));
            help.append("</h5>");
            help.append("<br />");
            help.append(description);
            return help.toString();
        }
        return null;
    }

    public IHoverHelp getConstantHelp(Field field) {
        return new ConstantHelp(this.fHelpLocation, this.fHelpContent, field);
    }

    public IHoverHelp getMethodHelp(Method method) throws Exception {
        return new MethodHelp(this.fHelpLocation, this.fHelpContent, method);
    }
}

