/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ease.lang.scriptarchive.ui.export;

import java.io.File;
import java.util.ArrayList;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.jface.viewers.ArrayContentProvider;
import org.eclipse.jface.viewers.ILabelProvider;
import org.eclipse.jface.viewers.IStructuredContentProvider;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.ITreeContentProvider;
import org.eclipse.jface.viewers.ViewerComparator;
import org.eclipse.jface.wizard.IWizard;
import org.eclipse.jface.wizard.WizardPage;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.FileDialog;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.dialogs.ElementTreeSelectionDialog;
import org.eclipse.ui.dialogs.ListDialog;
import org.eclipse.ui.model.WorkbenchContentProvider;
import org.eclipse.ui.model.WorkbenchLabelProvider;
import org.eclipse.ui.views.navigator.ResourceComparator;

public class MainPage
extends WizardPage {
    public static final String DIALOG_SETTINGS_LAST_LOCATIONS = "Last path";
    private Text fTxtProject;
    private Text fTxtScriptFile;
    private final IStructuredSelection fSelection;
    private IProject fSelectedProject;
    private IFile fSelectedFile;
    private Combo fCmbTargetLocation;
    private File fTargetFile;

    protected MainPage(String pageName, String title, ImageDescriptor titleImage, IStructuredSelection selection) {
        super(pageName, title, titleImage);
        this.fSelection = selection;
        this.setDescription("Create an executable script archive.");
    }

    public void createControl(Composite parent) {
        String[] lastLocations;
        IProject project;
        Object candidate;
        Composite container = new Composite(parent, 0);
        this.setControl((Control)container);
        container.setLayout((Layout)new GridLayout(3, false));
        Label lblProject = new Label(container, 0);
        lblProject.setLayoutData((Object)new GridData(131072, 0x1000000, false, false, 1, 1));
        lblProject.setText("Project:");
        this.fTxtProject = new Text(container, 2048);
        this.fTxtProject.setLayoutData((Object)new GridData(4, 0x1000000, true, false, 1, 1));
        Button btnBrowseProject = new Button(container, 0);
        btnBrowseProject.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                ListDialog dialog = new ListDialog(MainPage.this.getShell());
                dialog.setContentProvider((IStructuredContentProvider)ArrayContentProvider.getInstance());
                dialog.setLabelProvider((ILabelProvider)new WorkbenchLabelProvider());
                dialog.setInput(MainPage.this.getOpenProject());
                dialog.setTitle("Project selection");
                dialog.setMessage("Select project to export.");
                if (dialog.open() == 0) {
                    IProject project = (IProject)dialog.getResult()[0];
                    MainPage.this.fTxtProject.setText(project.getName());
                    MainPage.this.validateData();
                }
            }
        });
        btnBrowseProject.setText("Browse...");
        Label lblStartScript = new Label(container, 0);
        lblStartScript.setLayoutData((Object)new GridData(131072, 0x1000000, false, false, 1, 1));
        lblStartScript.setText("Start Script:");
        this.fTxtScriptFile = new Text(container, 2048);
        this.fTxtScriptFile.setLayoutData((Object)new GridData(4, 0x1000000, true, false, 1, 1));
        Button btnBrowseScript = new Button(container, 0);
        btnBrowseScript.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                Object selectedFile;
                ElementTreeSelectionDialog dialog = new ElementTreeSelectionDialog(MainPage.this.getShell(), (ILabelProvider)new WorkbenchLabelProvider(), (ITreeContentProvider)new WorkbenchContentProvider());
                IProject project = ResourcesPlugin.getWorkspace().getRoot().getProject(MainPage.this.fTxtProject.getText());
                dialog.setInput(project.exists() ? project : ResourcesPlugin.getWorkspace().getRoot());
                dialog.setComparator((ViewerComparator)new ResourceComparator(1));
                dialog.setTitle("Script selection");
                dialog.setMessage("Select startup script.");
                if (dialog.open() == 0 && (selectedFile = dialog.getFirstResult()) instanceof IFile) {
                    MainPage.this.fTxtProject.setText(((IFile)selectedFile).getProject().getName());
                    MainPage.this.fTxtScriptFile.setText(((IFile)selectedFile).getFullPath().removeFirstSegments(1).toPortableString());
                    MainPage.this.validateData();
                }
            }
        });
        btnBrowseScript.setText("Browse...");
        Label label = new Label(container, 258);
        label.setLayoutData((Object)new GridData(4, 0x1000000, false, false, 3, 1));
        Label lblToArchiveFile = new Label(container, 0);
        lblToArchiveFile.setLayoutData((Object)new GridData(131072, 0x1000000, false, false, 1, 1));
        lblToArchiveFile.setText("To archive file:");
        this.fCmbTargetLocation = new Combo(container, 0);
        this.fCmbTargetLocation.setLayoutData((Object)new GridData(4, 0x1000000, true, false, 1, 1));
        Button btnBrowseArchive = new Button(container, 0);
        btnBrowseArchive.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                FileDialog dialog = new FileDialog(Display.getDefault().getActiveShell(), 8192);
                dialog.setText("Target location selection");
                dialog.setFilterExtensions(new String[]{"*.sar;*.jar;*.zip", "*.*"});
                dialog.setFilterNames(new String[]{"Script Archives", "All Files"});
                String targetLocation = dialog.open();
                if (targetLocation != null) {
                    MainPage.this.fCmbTargetLocation.setText(targetLocation);
                    MainPage.this.validateData();
                }
            }
        });
        btnBrowseArchive.setText("Browse...");
        this.setPageComplete(false);
        if (this.fSelection != null && (candidate = this.fSelection.getFirstElement()) instanceof IResource && (project = ((IResource)candidate).getProject()).isOpen()) {
            this.fTxtProject.setText(project.getName());
            if (candidate instanceof IFile) {
                this.fTxtScriptFile.setText(((IResource)candidate).getFullPath().removeFirstSegments(1).toPortableString());
            }
        }
        if ((lastLocations = this.getDialogSettings().getArray(DIALOG_SETTINGS_LAST_LOCATIONS)) != null) {
            this.fCmbTargetLocation.setItems(lastLocations);
            this.fCmbTargetLocation.setText(lastLocations[0]);
        }
        this.validateData();
        super.setErrorMessage(null);
        this.fTxtProject.addModifyListener(e -> this.validateData());
        this.fTxtScriptFile.addModifyListener(e -> this.validateData());
        this.fCmbTargetLocation.addModifyListener(e -> this.validateData());
    }

    private Object getOpenProject() {
        ArrayList<IProject> openProjects = new ArrayList<IProject>();
        IProject[] iProjectArray = ResourcesPlugin.getWorkspace().getRoot().getProjects();
        int n = iProjectArray.length;
        int n2 = 0;
        while (n2 < n) {
            IProject project = iProjectArray[n2];
            if (project.isOpen()) {
                openProjects.add(project);
            }
            ++n2;
        }
        return openProjects;
    }

    private void validateData() {
        String projectName = this.fTxtProject.getText();
        if (!projectName.isEmpty()) {
            IProject project = ResourcesPlugin.getWorkspace().getRoot().getProject(projectName);
            if (project.exists()) {
                String fileName = this.fTxtScriptFile.getText();
                if (!fileName.isEmpty()) {
                    IFile file = project.getFile((IPath)new Path(fileName));
                    if (file.exists()) {
                        String targetLocation = this.fCmbTargetLocation.getText();
                        if (!targetLocation.isEmpty()) {
                            File targetFile = new File(targetLocation);
                            if (!targetFile.isDirectory()) {
                                this.fSelectedProject = project;
                                this.fSelectedFile = file;
                                this.fTargetFile = targetFile;
                                this.setErrorMessage(null);
                            } else {
                                this.setErrorMessage("Expot destionation must be a file, not a directory.");
                            }
                        } else {
                            this.setErrorMessage("Please select an export location.");
                        }
                    } else {
                        this.setErrorMessage("The file \"" + fileName + "\" does not exist.");
                    }
                } else {
                    this.setErrorMessage("Please select a script file to execute.");
                }
            } else {
                this.setErrorMessage("The project \"" + projectName + "\" does not exist.");
            }
        } else {
            this.setErrorMessage("Please select a project.");
        }
    }

    public void setErrorMessage(String errorMessage) {
        this.setPageComplete(errorMessage == null);
        super.setErrorMessage(errorMessage);
    }

    public IFile getSelectedFile() {
        return this.fSelectedFile;
    }

    public IProject getSelectedProject() {
        return this.fSelectedProject;
    }

    public File getTargetFile() {
        return this.fTargetFile;
    }

    public void setWizard(IWizard newWizard) {
        super.setWizard(newWizard);
    }
}

