/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.eclemma.internal.ui.handlers;

import java.util.List;
import org.eclipse.core.commands.AbstractHandler;
import org.eclipse.core.commands.ExecutionEvent;
import org.eclipse.core.commands.ExecutionException;
import org.eclipse.core.commands.HandlerEvent;
import org.eclipse.core.commands.IHandler;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.debug.core.DebugEvent;
import org.eclipse.debug.core.DebugPlugin;
import org.eclipse.debug.core.IDebugEventSetListener;
import org.eclipse.debug.core.ILaunch;
import org.eclipse.debug.core.ILaunchesListener;
import org.eclipse.debug.core.model.IProcess;
import org.eclipse.eclemma.core.CoverageTools;
import org.eclipse.eclemma.core.EclEmmaStatus;
import org.eclipse.eclemma.core.launching.ICoverageLaunch;
import org.eclipse.eclemma.internal.ui.ContextHelp;
import org.eclipse.eclemma.internal.ui.EclEmmaUIPlugin;
import org.eclipse.eclemma.internal.ui.UIMessages;
import org.eclipse.eclemma.internal.ui.handlers.LaunchLabelProvider;
import org.eclipse.jface.viewers.ArrayContentProvider;
import org.eclipse.jface.viewers.ILabelProvider;
import org.eclipse.jface.viewers.IStructuredContentProvider;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.dialogs.ListDialog;
import org.eclipse.ui.handlers.HandlerUtil;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DumpExecutionDataHandler
extends AbstractHandler {
    private ILaunchesListener launchListener = new ILaunchesListener(){

        public void launchesRemoved(ILaunch[] launches) {
            DumpExecutionDataHandler.this.fireEnablementChanged();
        }

        public void launchesChanged(ILaunch[] launches) {
            DumpExecutionDataHandler.this.fireEnablementChanged();
        }

        public void launchesAdded(ILaunch[] launches) {
            DumpExecutionDataHandler.this.fireEnablementChanged();
        }
    };
    private IDebugEventSetListener debugListener = new IDebugEventSetListener(){

        public void handleDebugEvents(DebugEvent[] events) {
            DebugEvent[] debugEventArray = events;
            int n = events.length;
            int n2 = 0;
            while (n2 < n) {
                DebugEvent e = debugEventArray[n2];
                if (e.getSource() instanceof IProcess && e.getKind() == 8) {
                    DumpExecutionDataHandler.this.fireEnablementChanged();
                }
                ++n2;
            }
        }
    };

    private void fireEnablementChanged() {
        this.fireHandlerChanged(new HandlerEvent((IHandler)this, true, false));
    }

    public DumpExecutionDataHandler() {
        DebugPlugin debug = DebugPlugin.getDefault();
        debug.getLaunchManager().addLaunchListener(this.launchListener);
        debug.addDebugEventListener(this.debugListener);
    }

    public Object execute(ExecutionEvent event) throws ExecutionException {
        ICoverageLaunch launch;
        List launches = CoverageTools.getRunningCoverageLaunches();
        if (launches.size() == 1) {
            DumpExecutionDataHandler.requestDump((ICoverageLaunch)launches.get(0));
        } else if (launches.size() > 1 && (launch = this.openDialog(event, launches)) != null) {
            DumpExecutionDataHandler.requestDump(launch);
        }
        return null;
    }

    private ICoverageLaunch openDialog(ExecutionEvent event, List<ICoverageLaunch> launches) {
        ListDialog dialog = new ListDialog(HandlerUtil.getActiveShell((ExecutionEvent)event)){

            protected void configureShell(Shell shell) {
                super.configureShell(shell);
                ContextHelp.setHelp((Control)shell, "org.eclipse.eclemma.ui.dump_execution_data");
            }
        };
        dialog.setTitle(UIMessages.DumpExecutionDataDialog_title);
        dialog.setMessage(UIMessages.DumpExecutionDataDialog_message);
        dialog.setContentProvider((IStructuredContentProvider)new ArrayContentProvider());
        dialog.setLabelProvider((ILabelProvider)new LaunchLabelProvider());
        dialog.setInput(launches);
        if (dialog.open() == 0 || dialog.getResult().length == 1) {
            return (ICoverageLaunch)dialog.getResult()[0];
        }
        return null;
    }

    public static void requestDump(final ICoverageLaunch launch) {
        new Job(UIMessages.DumpExecutionData_task){

            protected IStatus run(IProgressMonitor monitor) {
                try {
                    boolean reset = EclEmmaUIPlugin.getInstance().getPreferenceStore().getBoolean("org.eclipse.eclemma.ui.reset_on_dump");
                    launch.requestDump(reset);
                }
                catch (CoreException e) {
                    return EclEmmaStatus.DUMP_REQUEST_ERROR.getStatus((Throwable)e);
                }
                return Status.OK_STATUS;
            }
        }.schedule();
    }

    public boolean isEnabled() {
        return !CoverageTools.getRunningCoverageLaunches().isEmpty();
    }

    public void dispose() {
        DebugPlugin debug = DebugPlugin.getDefault();
        debug.getLaunchManager().removeLaunchListener(this.launchListener);
        DebugPlugin.getDefault().addDebugEventListener(this.debugListener);
    }
}

