/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.eclemma.internal.ui.wizards;

import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;
import org.eclipse.eclemma.core.CoverageTools;
import org.eclipse.eclemma.core.ICoverageSession;
import org.eclipse.eclemma.core.ISessionExporter;
import org.eclipse.eclemma.internal.ui.ContextHelp;
import org.eclipse.eclemma.internal.ui.UIMessages;
import org.eclipse.eclemma.internal.ui.wizards.WidgetHistory;
import org.eclipse.jface.dialogs.IDialogSettings;
import org.eclipse.jface.viewers.ArrayContentProvider;
import org.eclipse.jface.viewers.ComboViewer;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.jface.wizard.WizardPage;
import org.eclipse.osgi.util.NLS;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.DirectoryDialog;
import org.eclipse.swt.widgets.FileDialog;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.ui.model.WorkbenchLabelProvider;

public class SessionExportPage1
extends WizardPage {
    private static final String ID = "SessionExportPage1";
    private static final String STORE_PREFIX = "SessionExportPage1.";
    private static final String STORE_FORMAT = "SessionExportPage1.format";
    private static final String STORE_DESTINATIONS = "SessionExportPage1.destinations";
    private TableViewer sessionstable;
    private ComboViewer formatcombo;
    private Combo destinationcombo;

    public SessionExportPage1() {
        super(ID);
        this.setTitle(UIMessages.ExportSessionPage1_title);
        this.setDescription(UIMessages.ExportSessionPage1_description);
    }

    public void createControl(Composite parent) {
        this.initializeDialogUnits((Control)parent);
        parent = new Composite(parent, 0);
        parent.setLayout((Layout)new GridLayout());
        new Label(parent, 0).setText(UIMessages.ExportSessionPage1Sessions_label);
        this.sessionstable = new TableViewer(parent, 2048);
        this.sessionstable.setLabelProvider((IBaseLabelProvider)new WorkbenchLabelProvider());
        this.sessionstable.setContentProvider((IContentProvider)new ArrayContentProvider());
        this.sessionstable.setInput((Object)CoverageTools.getSessionManager().getSessions());
        ICoverageSession active = CoverageTools.getSessionManager().getActiveSession();
        if (active != null) {
            this.sessionstable.setSelection((ISelection)new StructuredSelection((Object)active));
        }
        GridData gd = new GridData(1808);
        gd.heightHint = this.convertHeightInCharsToPixels(8);
        this.sessionstable.getControl().setLayoutData((Object)gd);
        Group group = new Group(parent, 0);
        group.setText(UIMessages.ExportSessionPage1DestinationGroup_label);
        group.setLayoutData((Object)new GridData(768));
        this.createExportOptionsGroup((Composite)group);
        this.setControl((Control)parent);
        ContextHelp.setHelp((Control)parent, "org.eclipse.eclemma.ui.session_export_context");
        this.restoreWidgetValues();
    }

    private void createExportOptionsGroup(Composite parent) {
        parent.setLayout((Layout)new GridLayout(3, false));
        new Label(parent, 0).setText(UIMessages.ExportSessionPage1Format_label);
        this.formatcombo = new ComboViewer(parent, 8);
        this.formatcombo.setContentProvider((IContentProvider)new ArrayContentProvider());
        this.formatcombo.setLabelProvider((IBaseLabelProvider)new LabelProvider(){

            public String getText(Object element) {
                return ((ISessionExporter.ExportFormat)element).getLabel();
            }
        });
        this.formatcombo.setInput((Object)ISessionExporter.ExportFormat.values());
        this.formatcombo.addSelectionChangedListener(new ISelectionChangedListener(){

            public void selectionChanged(SelectionChangedEvent event) {
                IPath path = Path.fromOSString((String)SessionExportPage1.this.destinationcombo.getText());
                path = path.removeFileExtension();
                ISessionExporter.ExportFormat format = SessionExportPage1.this.getExportFormat();
                if (!format.isFolderOutput()) {
                    path = path.addFileExtension(format.getFileExtension());
                }
                SessionExportPage1.this.destinationcombo.setText(path.toOSString());
            }
        });
        GridData gd = new GridData(768);
        gd.horizontalSpan = 2;
        this.formatcombo.getControl().setLayoutData((Object)gd);
        new Label(parent, 0).setText(UIMessages.ExportSessionPage1Destination_label);
        this.destinationcombo = new Combo(parent, 2048);
        this.destinationcombo.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                SessionExportPage1.this.update();
            }
        });
        gd = new GridData(768);
        gd.widthHint = this.convertHorizontalDLUsToPixels(120);
        this.destinationcombo.setLayoutData((Object)gd);
        Button browsebutton = new Button(parent, 0);
        browsebutton.setText(UIMessages.BrowseAction_label);
        this.setButtonLayoutData(browsebutton);
        browsebutton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                if (SessionExportPage1.this.getExportFormat().isFolderOutput()) {
                    SessionExportPage1.this.openFolderDialog();
                } else {
                    SessionExportPage1.this.openFileDialog();
                }
            }
        });
        this.update();
    }

    private void openFileDialog() {
        FileDialog fd = new FileDialog(this.getShell(), 8192);
        fd.setText(UIMessages.ExportSessionPage1BrowseDialog_title);
        fd.setFileName(this.destinationcombo.getText());
        String ext = this.getExportFormat().getFileExtension();
        fd.setFilterExtensions(new String[]{"*." + ext, "*.*"});
        String file = fd.open();
        if (file != null) {
            this.destinationcombo.setText(file);
        }
    }

    private void openFolderDialog() {
        DirectoryDialog fd = new DirectoryDialog(this.getShell(), 0);
        fd.setText(UIMessages.ExportSessionPage1BrowseDialog_title);
        fd.setFilterPath(this.destinationcombo.getText());
        String folder = fd.open();
        if (folder != null) {
            this.destinationcombo.setText(folder);
        }
    }

    private void update() {
        if (this.getSelectedSession() == null) {
            this.setErrorMessage(UIMessages.ExportSessionPage1NoSession_message);
            this.setPageComplete(false);
            return;
        }
        if (this.getDestination().length() == 0) {
            this.setMessage(UIMessages.ExportSessionPage1MissingDestination_message);
            this.setPageComplete(false);
            return;
        }
        ISessionExporter.ExportFormat format = this.getExportFormat();
        if (!format.isFolderOutput()) {
            String exta = Path.fromOSString((String)this.getDestination()).getFileExtension();
            String exte = format.getFileExtension();
            if (!exte.equalsIgnoreCase(exta)) {
                this.setMessage(NLS.bind((String)UIMessages.ExportSessionPage1WrongExtension_message, (Object)exte), 2);
                this.setPageComplete(true);
                return;
            }
        }
        this.setErrorMessage(null);
        this.setMessage(null);
        this.setPageComplete(true);
    }

    private void restoreWidgetValues() {
        IDialogSettings settings = this.getDialogSettings();
        this.formatcombo.setSelection((ISelection)new StructuredSelection((Object)this.readFormat(settings)));
        WidgetHistory.restoreCombo(settings, STORE_DESTINATIONS, this.destinationcombo);
    }

    private ISessionExporter.ExportFormat readFormat(IDialogSettings settings) {
        String format = settings.get(STORE_FORMAT);
        if (format != null) {
            try {
                return ISessionExporter.ExportFormat.valueOf((String)format);
            }
            catch (IllegalArgumentException illegalArgumentException) {}
        }
        return ISessionExporter.ExportFormat.HTML;
    }

    public void saveWidgetValues() {
        IDialogSettings settings = this.getDialogSettings();
        settings.put(STORE_FORMAT, this.getExportFormat().name());
        WidgetHistory.saveCombo(settings, STORE_DESTINATIONS, this.destinationcombo);
    }

    public ICoverageSession getSelectedSession() {
        IStructuredSelection sel = (IStructuredSelection)this.sessionstable.getSelection();
        return (ICoverageSession)sel.getFirstElement();
    }

    public ISessionExporter.ExportFormat getExportFormat() {
        IStructuredSelection selection = (IStructuredSelection)this.formatcombo.getSelection();
        return (ISessionExporter.ExportFormat)selection.getFirstElement();
    }

    public String getDestination() {
        return this.destinationcombo.getText().trim();
    }
}

